/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefinitionsScopedSearch
extends ExtensibleQueryFactory<PsiElement, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME;
    public static final DefinitionsScopedSearch INSTANCE;

    public static Query<PsiElement> search(PsiElement definitionsOf) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(definitionsOf));
    }

    public static Query<PsiElement> search(PsiElement definitionsOf, SearchScope searchScope) {
        return DefinitionsScopedSearch.search(definitionsOf, searchScope, true);
    }

    public static Query<PsiElement> search(PsiElement definitionsOf, SearchScope searchScope, boolean checkDeep) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(definitionsOf, searchScope, checkDeep));
    }

    static {
        QueryExecutor[] OLD_EXECUTORS;
        EP_NAME = ExtensionPointName.create("com.intellij.definitionsScopedSearch");
        INSTANCE = new DefinitionsScopedSearch();
        for (QueryExecutor executor : OLD_EXECUTORS = DefinitionsSearch.EP_NAME.getExtensions()) {
            INSTANCE.registerExecutor((queryParameters, consumer) -> executor.execute(queryParameters.getElement(), consumer));
        }
    }

    public static class SearchParameters
    implements QueryParameters {
        private final PsiElement myElement;
        private final SearchScope myScope;
        private final boolean myCheckDeep;

        public SearchParameters(@NotNull PsiElement element) {
            if (element == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            this(element, ReadAction.compute(element::getUseScope), true);
        }

        public SearchParameters(@NotNull PsiElement element, @NotNull SearchScope scope, boolean checkDeep) {
            if (element == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            this.myElement = element;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myElement.getProject();
        }

        @Override
        public boolean isQueryValid() {
            return this.myElement.isValid();
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = ReadAction.compute(() -> {
                PsiFile file = this.myElement.getContainingFile();
                return this.myScope.intersectWith(PsiSearchHelper.SERVICE.getInstance(this.myElement.getProject()).getUseScope(file != null ? file : this.myElement));
            });
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            return searchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/DefinitionsScopedSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/DefinitionsScopedSearch$SearchParameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

