/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NonProtectedConstructorInAbstractClassInspection
extends BaseInspection {
    public boolean m_ignoreNonPublicClasses = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.display.name", new Object[0]);
        if (string == null) {
            NonProtectedConstructorInAbstractClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("ConstructorNotProtectedInAbstractClass" == null) {
            NonProtectedConstructorInAbstractClassInspection.$$$reportNull$$$0(1);
        }
        return "ConstructorNotProtectedInAbstractClass";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.problem.descriptor", new Object[0]);
        if (string == null) {
            NonProtectedConstructorInAbstractClassInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.ignore.option", new Object[0]), this, "m_ignoreNonPublicClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonProtectedConstructorInAbstractClassVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("protected");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/NonProtectedConstructorInAbstractClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NonProtectedConstructorInAbstractClassVisitor
    extends BaseInspectionVisitor {
        private NonProtectedConstructorInAbstractClassVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NonProtectedConstructorInAbstractClassVisitor.$$$reportNull$$$0(0);
            }
            if (!method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("protected") || method.hasModifierProperty("private") || method.hasModifierProperty("packageLocal")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (NonProtectedConstructorInAbstractClassInspection.this.m_ignoreNonPublicClasses && !containingClass.hasModifierProperty("public")) {
                return;
            }
            if (!containingClass.hasModifierProperty("abstract")) {
                return;
            }
            if (containingClass.isEnum()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/NonProtectedConstructorInAbstractClassInspection$NonProtectedConstructorInAbstractClassVisitor", "visitMethod"));
        }
    }
}

