/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.threading.AbstractReplaceWithAnotherMethodCallFix;
import org.jetbrains.annotations.NotNull;

public class ThreadRunInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.run.display.name", new Object[0]);
        if (string == null) {
            ThreadRunInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("CallToThreadRun" == null) {
            ThreadRunInspection.$$$reportNull$$$0(1);
        }
        return "CallToThreadRun";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.run.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadRunInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ThreadRunFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadRunVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/ThreadRunInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ThreadRunVisitor
    extends BaseInspectionVisitor {
        private ThreadRunVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ThreadRunVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"run".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (!parameterList.isEmpty()) {
                return;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor(methodClass, "java.lang.Thread")) {
                return;
            }
            if (ThreadRunVisitor.isInsideThreadRun(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isInsideThreadRun(PsiElement element) {
            PsiMethod method = PsiTreeUtil.getParentOfType(element, PsiMethod.class);
            if (method == null) {
                return false;
            }
            String methodName = method.getName();
            if (!"run".equals(methodName)) {
                return false;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            return InheritanceUtil.isInheritor(methodClass, "java.lang.Thread");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/ThreadRunInspection$ThreadRunVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ThreadRunFix
    extends AbstractReplaceWithAnotherMethodCallFix {
        private ThreadRunFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("thread.run.replace.quickfix", new Object[0]);
            if (string == null) {
                ThreadRunFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected String getMethodName() {
            return "start";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadRunInspection$ThreadRunFix", "getFamilyName"));
        }
    }
}

