/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class VariablesProcessor
implements PsiScopeProcessor,
ElementClassHint {
    private boolean myStaticScopeFlag;
    private final boolean myStaticSensitiveFlag;
    private final List<PsiVariable> myResultList;

    public VariablesProcessor(boolean staticSensitive) {
        this(staticSensitive, new SmartList<PsiVariable>());
    }

    public VariablesProcessor(boolean staticSensitive, List<PsiVariable> list) {
        this.myStaticSensitiveFlag = staticSensitive;
        this.myResultList = list;
    }

    protected abstract boolean check(PsiVariable var1, ResolveState var2);

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.VARIABLE || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    @Override
    public boolean execute(@NotNull PsiElement pe, @NotNull ResolveState state) {
        if (pe == null) {
            VariablesProcessor.$$$reportNull$$$0(0);
        }
        if (state == null) {
            VariablesProcessor.$$$reportNull$$$0(1);
        }
        if (pe instanceof PsiVariable) {
            PsiVariable pvar = (PsiVariable)pe;
            if ((!this.myStaticSensitiveFlag || !this.myStaticScopeFlag || pvar.hasModifierProperty("static")) && this.check(pvar, state)) {
                this.myResultList.add(pvar);
            }
        }
        return true;
    }

    @Override
    public final void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            VariablesProcessor.$$$reportNull$$$0(2);
        }
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        }
    }

    public int size() {
        return this.myResultList.size();
    }

    public PsiVariable getResult(int i) {
        return this.myResultList.get(i);
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            VariablesProcessor.$$$reportNull$$$0(3);
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pe";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/scope/processor/VariablesProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

