/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceWithObjectsEqualsFix
implements LocalQuickFix {
    private final String myQualifierText;
    private final String myReplacementText;

    private ReplaceWithObjectsEqualsFix(String qualifierText, String replacementText) {
        this.myQualifierText = qualifierText;
        this.myReplacementText = replacementText;
    }

    @Override
    @Nls
    @NotNull
    public String getName() {
        String string = "Replace '" + this.myQualifierText + ".equals(...)' with 'Objects.equals(" + this.myReplacementText + ", ...)'";
        if (string == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Replace '.equals()' with 'Objects.equals()'" == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(1);
        }
        return "Replace '.equals()' with 'Objects.equals()'";
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethodCallExpression call;
        if (project == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(3);
        }
        if ((call = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiMethodCallExpression.class)) == null) {
            return;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return;
        }
        String replacementText = "java.util.Objects.equals(" + this.myReplacementText + ", " + args[0].getText() + ")";
        PsiElement replaced = call.replace(JavaPsiFacade.getElementFactory(project).createExpressionFromText(replacementText, call));
        JavaCodeStyleManager.getInstance(project).shortenClassReferences(((PsiMethodCallExpression)replaced).getMethodExpression());
    }

    @Nullable
    public static ReplaceWithObjectsEqualsFix createFix(@NotNull PsiMethodCallExpression call, @NotNull PsiReferenceExpression methodExpression) {
        if (call == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(4);
        }
        if (methodExpression == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(5);
        }
        if (!"equals".equals(methodExpression.getReferenceName()) || call.getArgumentList().getExpressionCount() != 1 || !PsiUtil.getLanguageLevel(call).isAtLeast(LanguageLevel.JDK_1_7)) {
            return null;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        PsiExpression noParens = PsiUtil.skipParenthesizedExprDown(qualifier);
        if (noParens == null) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method != null && method.getParameterList().getParametersCount() == 1 && method.getParameterList().getParameters()[0].getType().equalsToText("java.lang.Object")) {
            return new ReplaceWithObjectsEqualsFix(qualifier.getText(), noParens.getText());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithObjectsEqualsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithObjectsEqualsFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

