/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.impl.java.AccessLevelProvider;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyGroup
implements Group,
ColoredItemPresentation,
AccessLevelProvider,
WeighedItem {
    @NotNull
    private final String myPropertyName;
    @NotNull
    private final String myTypeText;
    private SmartPsiElementPointer myFieldPointer;
    private SmartPsiElementPointer myGetterPointer;
    private SmartPsiElementPointer mySetterPointer;
    private boolean myIsStatic;
    public static final Icon PROPERTY_READ_ICON = PropertyGroup.loadIcon("/nodes/propertyRead.png");
    public static final Icon PROPERTY_READ_STATIC_ICON = PropertyGroup.loadIcon("/nodes/propertyReadStatic.png");
    public static final Icon PROPERTY_WRITE_ICON = PropertyGroup.loadIcon("/nodes/propertyWrite.png");
    public static final Icon PROPERTY_WRITE_STATIC_ICON = PropertyGroup.loadIcon("/nodes/propertyWriteStatic.png");
    public static final Icon PROPERTY_READ_WRITE_ICON = PropertyGroup.loadIcon("/nodes/propertyReadWrite.png");
    public static final Icon PROPERTY_READ_WRITE_STATIC_ICON = PropertyGroup.loadIcon("/nodes/propertyReadWriteStatic.png");
    private final Project myProject;
    private final Collection<TreeElement> myChildren;

    private PropertyGroup(@NotNull String propertyName, @NotNull PsiType propertyType, boolean isStatic, @NotNull Project project) {
        if (propertyName == null) {
            PropertyGroup.$$$reportNull$$$0(0);
        }
        if (propertyType == null) {
            PropertyGroup.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PropertyGroup.$$$reportNull$$$0(2);
        }
        this.myChildren = new ArrayList<TreeElement>();
        this.myPropertyName = propertyName;
        this.myTypeText = propertyType.getPresentableText();
        this.myIsStatic = isStatic;
        this.myProject = project;
    }

    public static PropertyGroup createOn(PsiElement object, TreeElement treeElement) {
        if (object instanceof PsiField) {
            PsiField field = (PsiField)object;
            PropertyGroup group = new PropertyGroup(PropertyUtilBase.suggestPropertyName(field), field.getType(), field.hasModifierProperty("static"), object.getProject());
            group.setField(field);
            group.myChildren.add(treeElement);
            return group;
        }
        if (object instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)object;
            if (PropertyUtilBase.isSimplePropertyGetter(method)) {
                PropertyGroup group = new PropertyGroup(PropertyUtilBase.getPropertyNameByGetter(method), method.getReturnType(), method.hasModifierProperty("static"), object.getProject());
                group.setGetter(method);
                group.myChildren.add(treeElement);
                return group;
            }
            if (PropertyUtilBase.isSimplePropertySetter(method)) {
                PropertyGroup group = new PropertyGroup(PropertyUtilBase.getPropertyNameBySetter(method), method.getParameterList().getParameters()[0].getType(), method.hasModifierProperty("static"), object.getProject());
                group.setSetter(method);
                group.myChildren.add(treeElement);
                return group;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<TreeElement> getChildren() {
        Collection<TreeElement> collection = this.myChildren;
        if (collection == null) {
            PropertyGroup.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        PropertyGroup propertyGroup = this;
        if (propertyGroup == null) {
            PropertyGroup.$$$reportNull$$$0(4);
        }
        return propertyGroup;
    }

    @Override
    public Icon getIcon(boolean open) {
        if (this.isStatic()) {
            if (this.getGetter() != null && this.getSetter() != null) {
                return PROPERTY_READ_WRITE_STATIC_ICON;
            }
            if (this.getGetter() != null) {
                return PROPERTY_READ_STATIC_ICON;
            }
            return PROPERTY_WRITE_STATIC_ICON;
        }
        if (this.getGetter() != null && this.getSetter() != null) {
            return PROPERTY_READ_WRITE_ICON;
        }
        if (this.getGetter() != null) {
            return PROPERTY_READ_ICON;
        }
        return PROPERTY_WRITE_ICON;
    }

    private boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    public String getLocationString() {
        return null;
    }

    @Override
    public String getPresentableText() {
        return this.myPropertyName + ": " + this.myTypeText;
    }

    public String toString() {
        return this.myPropertyName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyGroup)) {
            return false;
        }
        return this.myPropertyName.equals(((PropertyGroup)o).myPropertyName) && this.myTypeText.equals(((PropertyGroup)o).myTypeText);
    }

    public int hashCode() {
        return this.myPropertyName.hashCode() * 31 + this.myTypeText.hashCode();
    }

    @Override
    public int getAccessLevel() {
        int result2 = 1;
        if (this.getGetter() != null) {
            result2 = Math.max(result2, PsiUtil.getAccessLevel(this.getGetter().getModifierList()));
        }
        if (this.getSetter() != null) {
            result2 = Math.max(result2, PsiUtil.getAccessLevel(this.getSetter().getModifierList()));
        }
        if (this.getField() != null) {
            result2 = Math.max(result2, PsiUtil.getAccessLevel(this.getField().getModifierList()));
        }
        return result2;
    }

    @Override
    public int getSubLevel() {
        return 0;
    }

    public void setField(PsiField field) {
        this.myFieldPointer = SmartPointerManager.getInstance(this.myProject).createSmartPsiElementPointer(field);
        this.myIsStatic &= field.hasModifierProperty("static");
    }

    public void setGetter(PsiMethod getter) {
        this.myGetterPointer = SmartPointerManager.getInstance(this.myProject).createSmartPsiElementPointer(getter);
        this.myIsStatic &= getter.hasModifierProperty("static");
    }

    public void setSetter(PsiMethod setter) {
        this.mySetterPointer = SmartPointerManager.getInstance(this.myProject).createSmartPsiElementPointer(setter);
        this.myIsStatic &= setter.hasModifierProperty("static");
    }

    public PsiField getField() {
        return this.myFieldPointer == null ? null : this.myFieldPointer.getElement();
    }

    public PsiMethod getGetter() {
        return this.myGetterPointer == null ? null : this.myGetterPointer.getElement();
    }

    public PsiMethod getSetter() {
        return this.mySetterPointer == null ? null : this.mySetterPointer.getElement();
    }

    void copyAccessorsFrom(PropertyGroup group) {
        if (group.getGetter() != null) {
            this.setGetter(group.getGetter());
        }
        if (group.getSetter() != null) {
            this.setSetter(group.getSetter());
        }
        if (group.getField() != null) {
            this.setField(group.getField());
        }
        this.myChildren.addAll(group.myChildren);
    }

    private static Icon loadIcon(@NonNls String resourceName) {
        Icon icon = IconLoader.findIcon(resourceName);
        Application application = ApplicationManager.getApplication();
        if (icon == null && application != null && application.isUnitTestMode()) {
            return new ImageIcon();
        }
        return icon;
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return this.isDeprecated() ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null;
    }

    private boolean isDeprecated() {
        return PropertyGroup.isDeprecated(this.getField()) && PropertyGroup.isDeprecated(this.getGetter()) && PropertyGroup.isDeprecated(this.getSetter());
    }

    private static boolean isDeprecated(@Nullable PsiDocCommentOwner element) {
        try {
            return element != null && element.isValid() && element.isDeprecated();
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public boolean isComplete() {
        return this.getGetter() != null || this.getSetter() != null;
    }

    public Object getValue() {
        return this;
    }

    @Override
    public int getWeight() {
        return 60;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/java/PropertyGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/java/PropertyGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

