/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiJvmConversionHelper {
    private static final Logger LOG = Logger.getInstance(PsiJvmConversionHelper.class);
    private static final Map<String, JvmModifier> MODIFIERS = ContainerUtil.immutableMapBuilder().put("public", JvmModifier.PUBLIC).put("protected", JvmModifier.PROTECTED).put("private", JvmModifier.PRIVATE).put("packageLocal", JvmModifier.PACKAGE_LOCAL).put("static", JvmModifier.STATIC).put("abstract", JvmModifier.ABSTRACT).put("final", JvmModifier.FINAL).put("native", JvmModifier.NATIVE).put("synchronized", JvmModifier.SYNCHRONIZED).put("strictfp", JvmModifier.STRICTFP).put("transient", JvmModifier.TRANSIENT).put("volatile", JvmModifier.VOLATILE).put("transitive", JvmModifier.TRANSITIVE).build();

    PsiJvmConversionHelper() {
    }

    @NotNull
    static PsiAnnotation[] getListAnnotations(@NotNull PsiModifierListOwner modifierListOwner) {
        PsiModifierList list;
        if (modifierListOwner == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(0);
        }
        PsiAnnotation[] psiAnnotationArray = (list = modifierListOwner.getModifierList()) == null ? PsiAnnotation.EMPTY_ARRAY : list.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(1);
        }
        return psiAnnotationArray;
    }

    @NotNull
    static JvmModifier[] getListModifiers(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(2);
        }
        EnumSet<JvmModifier> result2 = EnumSet.noneOf(JvmModifier.class);
        MODIFIERS.forEach((psi, jvm) -> {
            if (modifierListOwner == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(15);
            }
            if (modifierListOwner.hasModifierProperty((String)psi)) {
                result2.add((JvmModifier)((Object)jvm));
            }
        });
        JvmModifier[] jvmModifierArray = result2.toArray(JvmModifier.EMPTY_ARRAY);
        if (jvmModifierArray == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(3);
        }
        return jvmModifierArray;
    }

    @NotNull
    static JvmClassKind getJvmClassKind(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(4);
        }
        if (psiClass.isAnnotationType()) {
            JvmClassKind jvmClassKind = JvmClassKind.ANNOTATION;
            if (jvmClassKind == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(5);
            }
            return jvmClassKind;
        }
        if (psiClass.isInterface()) {
            JvmClassKind jvmClassKind = JvmClassKind.INTERFACE;
            if (jvmClassKind == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(6);
            }
            return jvmClassKind;
        }
        if (psiClass.isEnum()) {
            JvmClassKind jvmClassKind = JvmClassKind.ENUM;
            if (jvmClassKind == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(7);
            }
            return jvmClassKind;
        }
        JvmClassKind jvmClassKind = JvmClassKind.CLASS;
        if (jvmClassKind == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(8);
        }
        return jvmClassKind;
    }

    @Nullable
    static JvmReferenceType getClassSuperType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(9);
        }
        if (psiClass.isInterface()) {
            return null;
        }
        if (psiClass.isEnum()) {
            return PsiType.getTypeByName("java.lang.Enum", psiClass.getProject(), psiClass.getResolveScope());
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null || !baseClass.isInterface()) {
                return baseClassType;
            }
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        if (extendsTypes.length != 1) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        return extendsTypes[0];
    }

    @NotNull
    static JvmReferenceType[] getClassInterfaces(@NotNull PsiClass psiClass) {
        PsiReferenceList referenceList;
        if (psiClass == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(10);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                JvmReferenceType[] jvmReferenceTypeArray = new JvmReferenceType[]{baseClassType};
                if (jvmReferenceTypeArray == null) {
                    PsiJvmConversionHelper.$$$reportNull$$$0(11);
                }
                return jvmReferenceTypeArray;
            }
            if (JvmReferenceType.EMPTY_ARRAY == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(12);
            }
            return JvmReferenceType.EMPTY_ARRAY;
        }
        PsiReferenceList psiReferenceList = referenceList = psiClass.isInterface() ? psiClass.getExtendsList() : psiClass.getImplementsList();
        if (referenceList == null) {
            if (JvmReferenceType.EMPTY_ARRAY == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(13);
            }
            return JvmReferenceType.EMPTY_ARRAY;
        }
        JvmReferenceType[] jvmReferenceTypeArray = referenceList.getReferencedTypes();
        if (jvmReferenceTypeArray == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(14);
        }
        return jvmReferenceTypeArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiJvmConversionHelper";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiJvmConversionHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getListAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListModifiers";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmClassKind";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassInterfaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getListAnnotations";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getListModifiers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJvmClassKind";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClassSuperType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getClassInterfaces";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getListModifiers$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

