/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.TLongFunction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;

public class ConcurrentBitSet {
    private final AtomicReferenceArray<AtomicLongArray> arrays;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;

    public ConcurrentBitSet() {
        this.arrays = new AtomicReferenceArray(32);
    }

    private static int arrayIndex(int bitIndex) {
        int i = (bitIndex >> 6) + 1;
        return 31 - Integer.numberOfLeadingZeros(i);
    }

    private static int wordIndexInArray(int bitIndex) {
        int i = (bitIndex >> 6) + 1;
        return ConcurrentBitSet.clearHighestBit(i);
    }

    private static int clearHighestBit(int index) {
        int i = index >> 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return index & i;
    }

    public boolean flip(final int bitIndex) {
        long prevWord = this.changeWord(bitIndex, new TLongFunction(){

            public long execute(long word) {
                return word ^ 1L << bitIndex;
            }
        });
        return (prevWord & 1L << bitIndex) == 0L;
    }

    public boolean set(int bitIndex) {
        final long mask = 1L << bitIndex;
        long prevWord = this.changeWord(bitIndex, new TLongFunction(){

            public long execute(long word) {
                return word | mask;
            }
        });
        return (prevWord & mask) != 0L;
    }

    long changeWord(int bitIndex, @NotNull TLongFunction change) {
        long newWord;
        long word;
        if (change == null) {
            ConcurrentBitSet.$$$reportNull$$$0(0);
        }
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        AtomicLongArray array = this.getOrCreateArray(bitIndex);
        int wordIndexInArray = ConcurrentBitSet.wordIndexInArray(bitIndex);
        while (!array.compareAndSet(wordIndexInArray, word = array.get(wordIndexInArray), newWord = change.execute(word))) {
        }
        return word;
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public boolean clear(final int bitIndex) {
        long prevWord = this.changeWord(bitIndex, new TLongFunction(){

            public long execute(long word) {
                return word & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
            }
        });
        return (prevWord & 1L << bitIndex) != 0L;
    }

    @NotNull
    private AtomicLongArray getOrCreateArray(int bitIndex) {
        AtomicLongArray array;
        int arrayIndex = ConcurrentBitSet.arrayIndex(bitIndex);
        while ((array = this.arrays.get(arrayIndex)) == null) {
            this.arrays.compareAndSet(arrayIndex, null, new AtomicLongArray(1 << arrayIndex));
        }
        AtomicLongArray atomicLongArray = array;
        if (atomicLongArray == null) {
            ConcurrentBitSet.$$$reportNull$$$0(1);
        }
        return atomicLongArray;
    }

    public void clear() {
        for (int i = 0; i < this.arrays.length(); ++i) {
            this.arrays.set(i, null);
        }
    }

    public boolean get(int bitIndex) {
        return (this.getWord(bitIndex) & 1L << bitIndex) != 0L;
    }

    long getWord(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int arrayIndex = ConcurrentBitSet.arrayIndex(bitIndex);
        AtomicLongArray array = this.arrays.get(arrayIndex);
        if (array == null) {
            return 0L;
        }
        int wordIndexInArray = ConcurrentBitSet.wordIndexInArray(bitIndex);
        return array.get(wordIndexInArray);
    }

    public int nextSetBit(int fromIndex) {
        int arrayIndex;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + fromIndex);
        }
        AtomicLongArray array = null;
        for (arrayIndex = ConcurrentBitSet.arrayIndex(fromIndex); arrayIndex < this.arrays.length() && (array = this.arrays.get(arrayIndex)) == null; ++arrayIndex) {
        }
        if (array == null) {
            return -1;
        }
        int wordIndexInArray = ConcurrentBitSet.wordIndexInArray(fromIndex);
        long word = array.get(wordIndexInArray) & -1L << fromIndex;
        while (word == 0L) {
            if (++wordIndexInArray == array.length()) {
                wordIndexInArray = 0;
                ++arrayIndex;
                while (arrayIndex != this.arrays.length() && (array = this.arrays.get(arrayIndex)) == null) {
                    ++arrayIndex;
                }
                if (array == null) {
                    return -1;
                }
            }
            word = array.get(wordIndexInArray);
        }
        return ((1 << arrayIndex) - 1 + wordIndexInArray) * 64 + Long.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int arrayIndex = ConcurrentBitSet.arrayIndex(fromIndex);
        AtomicLongArray array = this.arrays.get(arrayIndex);
        int wordIndexInArray = ConcurrentBitSet.wordIndexInArray(fromIndex);
        if (array == null) {
            return ((1 << arrayIndex) - 1 + wordIndexInArray) * 64 + fromIndex % 64;
        }
        long word = (array.get(wordIndexInArray) ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++wordIndexInArray == array.length()) {
                wordIndexInArray = 0;
                if (++arrayIndex == this.arrays.length()) {
                    return -1;
                }
                array = this.arrays.get(arrayIndex);
                if (array == null) {
                    return ((1 << arrayIndex) - 1 + wordIndexInArray) * 64;
                }
            }
            word = array.get(wordIndexInArray) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return ((1 << arrayIndex) - 1 + wordIndexInArray) * 64 + Long.numberOfTrailingZeros(word);
    }

    public int hashCode() {
        long h = 1234L;
        for (int a = 0; a < this.arrays.length(); ++a) {
            AtomicLongArray array = this.arrays.get(a);
            if (array == null) continue;
            for (int i = 0; i < array.length(); ++i) {
                long word = array.get(i);
                h ^= word * (long)((1 << a) + i);
            }
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        AtomicLongArray array;
        int a;
        for (a = this.arrays.length() - 1; a >= 0 && (array = this.arrays.get(a)) == null; --a) {
        }
        return ((1 << a + 1) - 1) * 64;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConcurrentBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConcurrentBitSet set = (ConcurrentBitSet)obj;
        for (int i = 0; i < this.arrays.length(); ++i) {
            AtomicLongArray array1 = this.arrays.get(i);
            AtomicLongArray array2 = set.arrays.get(i);
            if (array1 == null && array2 == null) continue;
            int size = array1 == null ? array2.length() : array1.length();
            for (int k = 0; k < size; ++k) {
                long word2;
                long word1 = array1 == null ? 0L : array1.get(k);
                long l = word2 = array2 == null ? 0L : array2.get(k);
                if (word1 == word2) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        int i = this.nextSetBit(0);
        while (i >= 0) {
            int endOfRun = this.nextClearBit(i);
            if (endOfRun - i > 1) {
                if (b.length() != 1) {
                    b.append(", ");
                }
                b.append(i).append("...").append(endOfRun - 1);
                i = endOfRun;
            } else {
                do {
                    if (b.length() != 1) {
                        b.append(", ");
                    }
                    b.append(i);
                } while (++i < endOfRun);
            }
            i = this.nextSetBit(i + 1);
        }
        b.append('}');
        return b.toString();
    }

    @NotNull
    public long[] toLongArray() {
        int bits = this.size();
        long[] result2 = new long[bits / 64];
        int i = 0;
        for (int b = 0; b < bits; b += 64) {
            AtomicLongArray array = this.arrays.get(ConcurrentBitSet.arrayIndex(b));
            long word = array == null ? 0L : array.get(ConcurrentBitSet.wordIndexInArray(b));
            result2[i++] = word;
        }
        if (result2 == null) {
            ConcurrentBitSet.$$$reportNull$$$0(2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(@NotNull File file) throws IOException {
        if (file == null) {
            ConcurrentBitSet.$$$reportNull$$$0(3);
        }
        DataOutputStream bitSetStorage = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            long[] words;
            for (long word : words = this.toLongArray()) {
                bitSetStorage.writeLong(word);
            }
        }
        finally {
            bitSetStorage.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ConcurrentBitSet readFrom(@NotNull File file) throws IOException {
        if (file == null) {
            ConcurrentBitSet.$$$reportNull$$$0(4);
        }
        if (!file.exists()) {
            ConcurrentBitSet concurrentBitSet = new ConcurrentBitSet();
            if (concurrentBitSet == null) {
                ConcurrentBitSet.$$$reportNull$$$0(5);
            }
            return concurrentBitSet;
        }
        DataInputStream bitSetStorage = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        long length = file.length();
        long[] words = new long[(int)(length / 8L)];
        for (int i = 0; i < words.length; ++i) {
            words[i] = bitSetStorage.readLong();
        }
        ConcurrentBitSet concurrentBitSet = new ConcurrentBitSet(words);
        ConcurrentBitSet concurrentBitSet2 = concurrentBitSet;
        if (concurrentBitSet2 == null) {
            ConcurrentBitSet.$$$reportNull$$$0(6);
        }
        return concurrentBitSet2;
        finally {
            bitSetStorage.close();
        }
    }

    private ConcurrentBitSet(@NotNull long[] words) {
        if (words == null) {
            ConcurrentBitSet.$$$reportNull$$$0(7);
        }
        this.arrays = new AtomicReferenceArray(32);
        for (int i = 0; i < words.length; ++i) {
            long word = words[i];
            for (int b = 0; b < 64; ++b) {
                boolean bit = (word & 1L << b) != 0L;
                this.set(i * 64 + b, bit);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentBitSet";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentBitSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateArray";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toLongArray";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeWord";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

