/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ExceptionUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializationException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyAccessor
implements MutableAccessor {
    private final String myName;
    private final Class<?> myType;
    private final Method myReadMethod;
    private final Method myWriteMethod;
    private final Type myGenericType;

    public PropertyAccessor(PropertyDescriptor descriptor) {
        this(descriptor.getName(), descriptor.getPropertyType(), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    public PropertyAccessor(String name, Class<?> type, @NotNull Method readMethod2, @Nullable Method writeMethod2) {
        if (readMethod2 == null) {
            PropertyAccessor.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myType = type;
        this.myReadMethod = readMethod2;
        this.myWriteMethod = writeMethod2;
        this.myGenericType = this.myReadMethod.getGenericReturnType();
        try {
            this.myReadMethod.setAccessible(true);
            if (this.myWriteMethod != null) {
                this.myWriteMethod.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @NotNull
    public String getGetterName() {
        String string = this.myReadMethod.getName();
        if (string == null) {
            PropertyAccessor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public Object read(@NotNull Object o) {
        if (o == null) {
            PropertyAccessor.$$$reportNull$$$0(2);
        }
        try {
            return this.myReadMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            ExceptionUtil.rethrowUnchecked(exception);
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(3);
        }
        try {
            this.myWriteMethod.invoke(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            T[] constants;
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException && this.myGenericType instanceof Class && ((Class)this.myGenericType).isEnum() && cause.getMessage().contains("Parameter specified as non-null is null:") && (constants = ((Class)this.myGenericType).getEnumConstants()).length > 0) {
                try {
                    Binding.LOG.warn("Cannot set enum value, will be set to first enum value", e);
                    this.myWriteMethod.invoke(host, constants[0]);
                    return;
                }
                catch (IllegalAccessException e1) {
                    throw new XmlSerializationException(e);
                }
                catch (InvocationTargetException e1) {
                    throw new XmlSerializationException(cause);
                }
            }
            throw new XmlSerializationException(cause);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(4);
        }
        this.set(host, value);
    }

    @Override
    public void setInt(@NotNull Object host, int value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(5);
        }
        this.set(host, value);
    }

    @Override
    public void setShort(@NotNull Object host, short value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(6);
        }
        this.set(host, value);
    }

    @Override
    public void setLong(@NotNull Object host, long value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(7);
        }
        this.set(host, value);
    }

    @Override
    public void setDouble(@NotNull Object host, double value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(8);
        }
        this.set(host, value);
    }

    @Override
    public void setFloat(@NotNull Object host, float value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(9);
        }
        this.set(host, Float.valueOf(value));
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        T annotation;
        if (annotationClass == null) {
            PropertyAccessor.$$$reportNull$$$0(10);
        }
        if ((annotation = this.myReadMethod.getAnnotation(annotationClass)) == null && this.myWriteMethod != null) {
            annotation = this.myWriteMethod.getAnnotation(annotationClass);
        }
        return annotation;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Class<?> getValueClass() {
        return this.myType;
    }

    @Override
    public Type getGenericType() {
        return this.myGenericType;
    }

    @Override
    public boolean isFinal() {
        return this.myWriteMethod == null;
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor[" + this.myReadMethod.getDeclaringClass().getName() + "." + this.getName() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/PropertyAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/PropertyAccessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBoolean";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setInt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setShort";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLong";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDouble";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFloat";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

