/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallUtils {
    @NonNls
    private static final Set<String> regexMethodNames = new HashSet<String>(5);

    private MethodCallUtils() {
    }

    @Nullable
    public static String getMethodName(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(0);
        }
        PsiReferenceExpression method = expression.getMethodExpression();
        return method.getReferenceName();
    }

    @Nullable
    public static PsiType getTargetType(@NotNull PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(1);
        }
        if ((qualifierExpression = (methodExpression = expression.getMethodExpression()).getQualifierExpression()) == null) {
            return null;
        }
        return qualifierExpression.getType();
    }

    public static boolean isCompareToCall(@NotNull PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(2);
        }
        if (!"compareTo".equals((methodExpression = expression.getMethodExpression()).getReferenceName())) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        return MethodUtils.isCompareTo(method);
    }

    public static boolean isCompareToIgnoreCaseCall(@NotNull PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(3);
        }
        if (!"compareToIgnoreCase".equals((methodExpression = expression.getMethodExpression()).getReferenceName())) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        return MethodUtils.isCompareToIgnoreCase(method);
    }

    public static boolean isEqualsCall(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!"equals".equals(name)) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        return MethodUtils.isEquals(method);
    }

    public static boolean isEqualsIgnoreCaseCall(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!"equalsIgnoreCase".equals(name)) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        return MethodUtils.isEqualsIgnoreCase(method);
    }

    public static boolean isSimpleCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(4);
        }
        if (parameterTypeStrings == null) {
            return MethodCallUtils.isCallToMethod(expression, calledOnClassName, returnType, methodName, (PsiType[])null);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(expression.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiType[] parameterTypes = PsiType.createArray(parameterTypeStrings.length);
        GlobalSearchScope scope = expression.getResolveScope();
        for (int i = 0; i < parameterTypeStrings.length; ++i) {
            String parameterTypeString = parameterTypeStrings[i];
            parameterTypes[i] = factory.createTypeByFQClassName(parameterTypeString, scope);
        }
        return MethodCallUtils.isCallToMethod(expression, calledOnClassName, returnType, methodName, parameterTypes);
    }

    public static boolean isCallToStaticMethod(@NotNull PsiMethodCallExpression expression, @NonNls @NotNull String calledOnClassName, @NonNls @NotNull String methodName, int parameterCount) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(5);
        }
        if (calledOnClassName == null) {
            MethodCallUtils.$$$reportNull$$$0(6);
        }
        if (methodName == null) {
            MethodCallUtils.$$$reportNull$$$0(7);
        }
        PsiExpression[] args = expression.getArgumentList().getExpressions();
        if (!methodName.equals(MethodCallUtils.getMethodName(expression)) || args.length < parameterCount) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null || !method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != parameterCount || !method.isVarArgs() && args.length != parameterCount) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass != null && calledOnClassName.equals(aClass.getQualifiedName());
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        PsiExpression qualifier;
        PsiMethod method;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(8);
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        if (methodNamePattern != null) {
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return false;
            }
            Matcher matcher = methodNamePattern.matcher(referenceName);
            if (!matcher.matches()) {
                return false;
            }
        }
        if ((method = expression.resolveMethod()) == null) {
            return false;
        }
        if (calledOnClassName != null && (qualifier = methodExpression.getQualifierExpression()) != null) {
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, calledOnClassName)) {
                return false;
            }
            return MethodUtils.methodMatches(method, null, returnType, methodNamePattern, parameterTypes);
        }
        return MethodUtils.methodMatches(method, calledOnClassName, returnType, methodNamePattern, parameterTypes);
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        PsiReferenceExpression methodExpression;
        String referenceName;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(9);
        }
        if (methodName != null && !methodName.equals(referenceName = (methodExpression = expression.getMethodExpression()).getReferenceName())) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        return MethodUtils.methodMatches(method, calledOnClassName, returnType, methodName, parameterTypes);
    }

    public static boolean isCallToRegexMethod(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!regexMethodNames.contains(name)) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String className = containingClass.getQualifiedName();
        return "java.lang.String".equals(className) || "java.util.regex.Pattern".equals(className);
    }

    public static boolean isCallDuringObjectConstruction(PsiMethodCallExpression expression) {
        PsiExpression qualifier = expression.getMethodExpression().getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return false;
        }
        PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMember.class, true, PsiClass.class, PsiLambdaExpression.class);
        if (member == null) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null || containingClass.hasModifierProperty("final")) {
            return false;
        }
        if (member instanceof PsiClassInitializer) {
            PsiClassInitializer classInitializer = (PsiClassInitializer)member;
            if (!classInitializer.hasModifierProperty("static")) {
                return true;
            }
        } else {
            PsiField field;
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                if (method.isConstructor()) {
                    return true;
                }
                if (CloneUtils.isClone(method)) {
                    return true;
                }
                if (MethodUtils.simpleMethodMatches(method, null, "void", "readObject", "java.io.ObjectInputStream")) {
                    return true;
                }
                return MethodUtils.simpleMethodMatches(method, null, "void", "readObjectNoData", new String[0]);
            }
            if (member instanceof PsiField && !(field = (PsiField)member).hasModifierProperty("static")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMethodCallOnVariable(@NotNull PsiMethodCallExpression expression, @NotNull PsiVariable variable, @NotNull String methodName) {
        PsiReferenceExpression methodExpression;
        String name;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(10);
        }
        if (variable == null) {
            MethodCallUtils.$$$reportNull$$$0(11);
        }
        if (methodName == null) {
            MethodCallUtils.$$$reportNull$$$0(12);
        }
        if (!methodName.equals(name = (methodExpression = expression.getMethodExpression()).getReferenceName())) {
            return false;
        }
        PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement element = referenceExpression.resolve();
        return variable.equals(element);
    }

    @Nullable
    public static PsiMethod findMethodWithReplacedArgument(@NotNull PsiCall call, @NotNull PsiExpression target, @NotNull PsiExpression replacement) {
        PsiExpressionList argumentList;
        if (call == null) {
            MethodCallUtils.$$$reportNull$$$0(13);
        }
        if (target == null) {
            MethodCallUtils.$$$reportNull$$$0(14);
        }
        if (replacement == null) {
            MethodCallUtils.$$$reportNull$$$0(15);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return null;
        }
        PsiExpression[] expressions = argumentList.getExpressions();
        int index = -1;
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            if (expression != target) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return null;
        }
        PsiCall copy = (PsiCall)call.copy();
        PsiExpressionList copyArgumentList = copy.getArgumentList();
        assert (copyArgumentList != null);
        PsiExpression[] arguments = copyArgumentList.getExpressions();
        arguments[index].replace(replacement);
        if (call instanceof PsiEnumConstant) {
            PsiClass containingClass = ((PsiEnumConstant)call).getContainingClass();
            assert (containingClass != null);
            JavaPsiFacade facade = JavaPsiFacade.getInstance(call.getProject());
            PsiClassType type = facade.getElementFactory().createType(containingClass);
            JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(type, copy.getArgumentList(), call);
            return (PsiMethod)resolveResult.getElement();
        }
        return copy.resolveMethod();
    }

    public static boolean isNecessaryForSurroundingMethodCall(PsiExpression expression, PsiExpression replacement) {
        PsiElement parent = expression.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            expression = (PsiExpression)parent;
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiCall)) {
            return false;
        }
        PsiCall call = (PsiCall)grandParent;
        return call.resolveMethod() != MethodCallUtils.findMethodWithReplacedArgument(call, expression, replacement);
    }

    public static boolean isSuperMethodCall(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethod method) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(16);
        }
        if (method == null) {
            MethodCallUtils.$$$reportNull$$$0(17);
        }
        if (!MethodCallUtils.hasSuperQualifier(expression)) {
            return false;
        }
        PsiMethod targetMethod = expression.resolveMethod();
        return targetMethod != null && MethodSignatureUtil.isSuperMethod(targetMethod, method);
    }

    public static boolean hasSuperQualifier(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(18);
        }
        return ParenthesesUtils.stripParentheses(expression.getMethodExpression().getQualifierExpression()) instanceof PsiSuperExpression;
    }

    public static boolean isVarArgCall(PsiMethodCallExpression call) {
        JavaResolveResult result2 = call.resolveMethodGenerics();
        PsiMethod method = ObjectUtils.tryCast(result2.getElement(), PsiMethod.class);
        if (method == null || !method.isVarArgs()) {
            return false;
        }
        PsiSubstitutor substitutor = result2.getSubstitutor();
        return MethodCallInstruction.isVarArgCall(method, substitutor, call.getArgumentList().getExpressions(), method.getParameterList().getParameters());
    }

    public static boolean containsSuperMethodCall(@NotNull PsiMethod method) {
        if (method == null) {
            MethodCallUtils.$$$reportNull$$$0(19);
        }
        SuperCallVisitor visitor = new SuperCallVisitor(method);
        method.accept(visitor);
        return visitor.isSuperCallFound();
    }

    public static boolean callWithNonConstantString(@NotNull PsiMethodCallExpression expression, boolean considerStaticFinalConstant, String className, String ... methodNames) {
        PsiField field;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(20);
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        boolean found = false;
        for (String name : methodNames) {
            if (!name.equals(methodName)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor(aClass, className)) {
            return false;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression argument = ParenthesesUtils.stripParentheses(ExpressionUtils.getFirstExpressionInList(argumentList));
        if (argument == null) {
            return false;
        }
        PsiType type = argument.getType();
        if (type == null || !type.equalsToText("java.lang.String")) {
            return false;
        }
        if (considerStaticFinalConstant && argument instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)argument).resolve()) instanceof PsiField && (field = (PsiField)target).hasModifierProperty("static") && field.hasModifierProperty("final")) {
            return false;
        }
        return !PsiUtil.isConstantExpression(argument);
    }

    @Nullable
    public static PsiMethodCallExpression getQualifierMethodCall(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            MethodCallUtils.$$$reportNull$$$0(21);
        }
        return ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(methodCall.getMethodExpression().getQualifierExpression()), PsiMethodCallExpression.class);
    }

    public static boolean isUsedAsSuperConstructorCallArgument(@NotNull PsiParameter parameter, boolean superMustBeLibrary) {
        PsiElement scope;
        if (parameter == null) {
            MethodCallUtils.$$$reportNull$$$0(22);
        }
        if (!((scope = parameter.getDeclarationScope()) instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        THashSet checked = new THashSet();
        while (true) {
            ProgressManager.checkCanceled();
            if (!checked.add(method)) {
                return false;
            }
            PsiMethodCallExpression call = MethodUtils.findSuperOrThisCall(method);
            if (call == null) {
                return false;
            }
            int index = MethodCallUtils.getParameterReferenceIndex(call, parameter);
            if (index < 0) {
                return false;
            }
            JavaResolveResult resolveResult = call.resolveMethodGenerics();
            if (!resolveResult.isValidResult()) {
                return false;
            }
            method = (PsiMethod)resolveResult.getElement();
            if (method == null) {
                return false;
            }
            if (RefactoringChangeUtil.isSuperMethodCall(call) && (!superMustBeLibrary || method instanceof PsiCompiledElement)) {
                return true;
            }
            parameter = method.getParameterList().getParameters()[index];
        }
    }

    private static int getParameterReferenceIndex(PsiMethodCallExpression call, PsiParameter parameter) {
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        for (int i = 0; i < arguments.length; ++i) {
            PsiElement target;
            PsiExpression argument = arguments[i];
            if (!((argument = ParenthesesUtils.stripParentheses(argument)) instanceof PsiReferenceExpression) || (target = ((PsiReferenceExpression)argument).resolve()) != parameter) continue;
            return i;
        }
        return -1;
    }

    static {
        regexMethodNames.add("compile");
        regexMethodNames.add("matches");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledOnClassName";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/MethodCallUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompareToCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompareToIgnoreCaseCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimpleCallToMethod";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallToStaticMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallToMethod";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodCallOnVariable";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodWithReplacedArgument";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuperMethodCall";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuperQualifier";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "containsSuperMethodCall";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "callWithNonConstantString";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifierMethodCall";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedAsSuperConstructorCallArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMethod myMethod;
        private boolean mySuperCallFound;

        public SuperCallVisitor(@NotNull PsiMethod method) {
            if (method == null) {
                SuperCallVisitor.$$$reportNull$$$0(0);
            }
            this.myMethod = method;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                SuperCallVisitor.$$$reportNull$$$0(1);
            }
            if (!this.mySuperCallFound) {
                super.visitElement(element);
            }
        }

        @Override
        public void visitIfStatement(PsiIfStatement statement) {
            PsiExpression condition = statement.getCondition();
            Object result2 = ExpressionUtils.computeConstantExpression(condition);
            if (result2 != null && result2.equals(Boolean.FALSE)) {
                return;
            }
            super.visitIfStatement(statement);
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                SuperCallVisitor.$$$reportNull$$$0(2);
            }
            if (this.mySuperCallFound) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (MethodCallUtils.isSuperMethodCall(expression, this.myMethod)) {
                this.mySuperCallFound = true;
            }
        }

        @Override
        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            PsiElement target;
            if (this.mySuperCallFound) {
                return;
            }
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier instanceof PsiSuperExpression && (target = expression.resolve()) instanceof PsiMethod && MethodSignatureUtil.isSuperMethod((PsiMethod)target, this.myMethod)) {
                this.mySuperCallFound = true;
                return;
            }
            super.visitMethodReferenceExpression(expression);
        }

        boolean isSuperCallFound() {
            return this.mySuperCallFound;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/MethodCallUtils$SuperCallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

