/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import gnu.trove.TDoubleObjectHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBUI {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.JBUI");
    public static final String USER_SCALE_FACTOR_PROPERTY = "JBUI.userScaleFactor";
    private static final PropertyChangeSupport PCS = new PropertyChangeSupport(new JBUI());
    private static final float DISCRETE_SCALE_RESOLUTION = 0.25f;
    private static final Float SYSTEM_SCALE_FACTOR = Float.valueOf(JBUI.sysScale());
    private static float userScaleFactor;

    public static void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PCS.addPropertyChangeListener(propertyName, listener);
    }

    public static void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PCS.removePropertyChangeListener(propertyName, listener);
    }

    public static float sysScale() {
        if (SYSTEM_SCALE_FACTOR != null) {
            return SYSTEM_SCALE_FACTOR.floatValue();
        }
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            return 1.0f;
        }
        if (UIUtil.isJreHiDPIEnabled()) {
            GraphicsDevice gd = null;
            try {
                gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            if (gd != null && gd.getDefaultConfiguration() != null) {
                return JBUI.sysScale(gd.getDefaultConfiguration());
            }
            return 1.0f;
        }
        UIUtil.initSystemFontData();
        Pair<String, Integer> fdata = UIUtil.getSystemFontData();
        int size = fdata == null ? Fonts.label().getSize() : fdata.getSecond().intValue();
        return JBUI.getFontScale(size);
    }

    public static float sysScale(@Nullable GraphicsConfiguration gc) {
        if (UIUtil.isJreHiDPIEnabled() && gc != null && gc.getDevice().getType() == 0) {
            if (SystemInfo.isMac && UIUtil.isJreHiDPI_earlierVersion()) {
                return UIUtil.DetectRetinaKit.isOracleMacRetinaDevice(gc.getDevice()) ? 2.0f : 1.0f;
            }
            return (float)gc.getDefaultTransform().getScaleX();
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Graphics2D g) {
        if (UIUtil.isJreHiDPIEnabled() && g != null) {
            GraphicsConfiguration gc = g.getDeviceConfiguration();
            if (gc == null || gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1) {
                return (float)g.getTransform().getScaleX();
            }
            return JBUI.sysScale(gc);
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Component comp) {
        if (comp != null) {
            return JBUI.sysScale(comp.getGraphicsConfiguration());
        }
        return JBUI.sysScale();
    }

    public static double sysScale(@Nullable ScaleContext ctx) {
        if (ctx != null) {
            return ctx.getScale(ScaleType.SYS_SCALE);
        }
        return JBUI.sysScale();
    }

    public static float pixScale() {
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale() * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(float f) {
        return JBUI.pixScale() * f;
    }

    public static float pixScale(@Nullable GraphicsConfiguration gc, float f) {
        return JBUI.pixScale(gc) * f;
    }

    public static float pixScale(@Nullable GraphicsConfiguration gc) {
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale(gc) * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(@Nullable Graphics2D g) {
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale(g) * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(@Nullable Component comp) {
        return JBUI.pixScale(comp != null ? comp.getGraphicsConfiguration() : null);
    }

    public static <T extends BaseScaleContext> double pixScale(@Nullable T ctx) {
        if (ctx != null) {
            double usrScale = ctx.getScale(ScaleType.USR_SCALE);
            return UIUtil.isJreHiDPIEnabled() ? ctx.getScale(ScaleType.SYS_SCALE) * usrScale : usrScale;
        }
        return JBUI.pixScale();
    }

    private static void setUserScaleFactorProperty(float scale) {
        Float f = Float.valueOf(userScaleFactor);
        userScaleFactor = scale;
        PCS.firePropertyChange(USER_SCALE_FACTOR_PROPERTY, f, Float.valueOf(userScaleFactor));
        LOG.info("User scale factor: " + userScaleFactor);
    }

    public static void setUserScaleFactor(float scale) {
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            JBUI.setUserScaleFactorProperty(1.0f);
            return;
        }
        if ((scale = JBUI.discreteScale(scale)) < 1.0f && JBUI.sysScale() >= 1.0f) {
            scale = 1.0f;
        }
        if (SystemInfo.isLinux && scale == 1.25f && UIUtil.DEF_SYSTEM_FONT_SIZE == 12.0f) {
            scale = 1.0f;
        }
        if (userScaleFactor == scale) {
            return;
        }
        JBUI.setUserScaleFactorProperty(scale);
    }

    static float discreteScale(float scale) {
        return (float)Math.round(scale / 0.25f) * 0.25f;
    }

    public static float scale(float f) {
        return f * userScaleFactor;
    }

    public static int scale(int i) {
        return Math.round(userScaleFactor * (float)i);
    }

    public static int scaleFontSize(float fontSize) {
        if (userScaleFactor == 1.25f) {
            return (int)(fontSize * 1.34f);
        }
        if (userScaleFactor == 1.75f) {
            return (int)(fontSize * 1.67f);
        }
        return (int)JBUI.scale(fontSize);
    }

    public static float getFontScale(float fontSize) {
        return fontSize / UIUtil.DEF_SYSTEM_FONT_SIZE;
    }

    public static JBDimension size(int width, int height) {
        return new JBDimension(width, height);
    }

    public static JBDimension size(int widthAndHeight) {
        return new JBDimension(widthAndHeight, widthAndHeight);
    }

    public static JBDimension size(Dimension size) {
        if (size instanceof JBDimension) {
            JBDimension newSize = ((JBDimension)size).newSize();
            return size instanceof UIResource ? newSize.asUIResource() : newSize;
        }
        return new JBDimension(size.width, size.height);
    }

    public static JBInsets insets(int top, int left, int bottom, int right) {
        return new JBInsets(top, left, bottom, right);
    }

    public static JBInsets insets(int all) {
        return JBUI.insets(all, all, all, all);
    }

    public static JBInsets insets(int topBottom, int leftRight) {
        return JBUI.insets(topBottom, leftRight, topBottom, leftRight);
    }

    public static JBInsets emptyInsets() {
        return new JBInsets(0, 0, 0, 0);
    }

    public static JBInsets insetsTop(int t) {
        return JBUI.insets(t, 0, 0, 0);
    }

    public static JBInsets insetsLeft(int l) {
        return JBUI.insets(0, l, 0, 0);
    }

    public static JBInsets insetsBottom(int b) {
        return JBUI.insets(0, 0, b, 0);
    }

    public static JBInsets insetsRight(int r) {
        return JBUI.insets(0, 0, 0, r);
    }

    public static EmptyIcon emptyIcon(int size) {
        return JBUI.scale(EmptyIcon.create(size));
    }

    @NotNull
    public static <T extends JBIcon> T scale(@NotNull T icon) {
        if (icon == null) {
            JBUI.$$$reportNull$$$0(0);
        }
        JBIcon jBIcon = icon.withIconPreScaled(false);
        if (jBIcon == null) {
            JBUI.$$$reportNull$$$0(1);
        }
        return (T)jBIcon;
    }

    @NotNull
    public static JBDimension emptySize() {
        JBDimension jBDimension = new JBDimension(0, 0);
        if (jBDimension == null) {
            JBUI.$$$reportNull$$$0(2);
        }
        return jBDimension;
    }

    @NotNull
    public static JBInsets insets(@NotNull Insets insets) {
        if (insets == null) {
            JBUI.$$$reportNull$$$0(3);
        }
        JBInsets jBInsets = JBInsets.create(insets);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(4);
        }
        return jBInsets;
    }

    @Deprecated
    public static boolean isHiDPI() {
        return JBUI.isUsrHiDPI();
    }

    public static boolean isUsrHiDPI() {
        return JBUI.isHiDPI(JBUI.scale(1.0f));
    }

    public static boolean isPixHiDPI(@Nullable GraphicsConfiguration gc) {
        return JBUI.isHiDPI(JBUI.pixScale(gc));
    }

    public static boolean isPixHiDPI(@Nullable Graphics2D g) {
        return JBUI.isHiDPI(JBUI.pixScale(g));
    }

    public static boolean isPixHiDPI(@Nullable Component comp) {
        return JBUI.isHiDPI(JBUI.pixScale(comp));
    }

    public static boolean isHiDPI(double scale) {
        return scale > 1.0;
    }

    private static Color getColor(String propertyName, int defaultColor) {
        return JBUI.getColor(propertyName, new Color(defaultColor));
    }

    private static Color getColor(String propertyName, Color defaultColor) {
        Color color = UIManager.getColor(propertyName);
        return color == null ? defaultColor : color;
    }

    private static int getInt(String propertyName, int defaultValue) {
        Object value = UIManager.get(propertyName);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    private static Icon getIcon(String propertyName, Icon defaultIcon) {
        Icon icon = UIManager.getIcon(propertyName);
        return icon == null ? defaultIcon : icon;
    }

    static {
        JBUI.setUserScaleFactor(UIUtil.isJreHiDPIEnabled() ? 1.0f : SYSTEM_SCALE_FACTOR.floatValue());
        LOG.info("System scale factor: " + SYSTEM_SCALE_FACTOR + " (" + (UIUtil.isJreHiDPIEnabled() ? "JRE-managed" : "IDE-managed") + " HiDPI)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBUI";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBUI";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "emptySize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "insets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "insets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CurrentTheme {

        public static class Label {
            public static Color foreground(boolean selected) {
                return selected ? JBUI.getColor("Label.selectedForeground", 0xFFFFFF) : JBUI.getColor("Label.foreground", 0);
            }

            public static Color foreground() {
                return Label.foreground(false);
            }

            public static Color disabledForeground(boolean selected) {
                return selected ? JBUI.getColor("Label.selectedDisabledForeground", 0x999999) : JBUI.getColor("Label.disabledForeground", JBUI.getColor("Label.disabledText", 0x999999));
            }

            public static Color disabledForeground() {
                return Label.foreground(false);
            }
        }

        public static class ToolWindow {
            public static Color tabSelectedBackground() {
                return JBUI.getColor("ToolWindow.header.tab.selected.background", 0xDEDEDE);
            }

            public static Color tabSelectedActiveBackground() {
                return JBUI.getColor("ToolWindow.header.tab.selected.active.background", 13685976);
            }

            public static Color tabHoveredBackground() {
                return JBUI.getColor("ToolWindow.header.tab.hovered.background", ToolWindow.tabSelectedBackground());
            }

            public static Color tabHoveredActiveBackground() {
                return JBUI.getColor("ToolWindow.header.tab.hovered.active.background", ToolWindow.tabSelectedActiveBackground());
            }

            public static Color tabSelectedBackground(boolean active) {
                return active ? ToolWindow.tabSelectedActiveBackground() : ToolWindow.tabSelectedBackground();
            }

            public static Color tabHoveredBackground(boolean active) {
                return active ? ToolWindow.tabHoveredActiveBackground() : ToolWindow.tabHoveredBackground();
            }

            public static Color headerBackground(boolean active) {
                return active ? ToolWindow.headerActiveBackground() : ToolWindow.headerBackground();
            }

            public static Color headerBackground() {
                return JBUI.getColor("ToolWindow.header.background", 0xECECEC);
            }

            public static Color headerBorderBackground() {
                return JBUI.getColor("ToolWindow.header.border.background", 0xC9C9C9);
            }

            public static Color headerActiveBackground() {
                return JBUI.getColor("ToolWindow.header.active.background", 14870252);
            }

            public static int tabVerticalPadding() {
                return JBUI.getInt("ToolWindow.tab.verticalPadding", JBUI.scale(3));
            }

            public static Font headerFont() {
                JBFont font = Fonts.label();
                Object size = UIManager.get("ToolWindow.header.font.size");
                if (size instanceof Integer) {
                    return font.deriveFont(((Integer)size).floatValue());
                }
                return font;
            }

            public static Color hoveredIconBackground() {
                return JBUI.getColor("ToolWindow.header.closeButton.background", 0xB9B9B9);
            }

            public static Icon closeTabIcon(boolean hovered) {
                return hovered ? JBUI.getIcon("ToolWindow.header.closeButton.hovered.icon", AllIcons.Actions.CloseNewHovered) : JBUI.getIcon("ToolWindow.header.closeButton.icon", AllIcons.Actions.CloseNew);
            }

            public static Icon comboTabIcon(boolean hovered) {
                return hovered ? JBUI.getIcon("ToolWindow.header.comboButton.hovered.icon", AllIcons.General.ComboArrow) : JBUI.getIcon("ToolWindow.header.comboButton.icon", AllIcons.General.ComboArrow);
            }
        }
    }

    public static abstract class RasterJBIcon
    extends ScaleContextSupport<ScaleContext>
    implements Icon {
        public RasterJBIcon() {
            super(ScaleContext.create());
        }
    }

    public static abstract class CachingScalableJBIcon<T extends CachingScalableJBIcon>
    extends ScalableJBIcon {
        private CachingScalableJBIcon myScaledIconCache;

        protected CachingScalableJBIcon() {
        }

        protected CachingScalableJBIcon(CachingScalableJBIcon icon) {
            super(icon);
        }

        @Override
        public Icon scale(float scale) {
            if (scale == this.getScale()) {
                return this;
            }
            if (this.myScaledIconCache == null || this.myScaledIconCache.getScale() != scale) {
                this.myScaledIconCache = this.copy();
                this.myScaledIconCache.updateScale(ScaleType.OBJ_SCALE.of(scale));
            }
            return this.myScaledIconCache;
        }

        @NotNull
        protected abstract T copy();
    }

    public static abstract class ScalableJBIcon
    extends JBIcon
    implements ScalableIcon {
        protected ScalableJBIcon() {
        }

        protected ScalableJBIcon(ScalableJBIcon icon) {
            super(icon);
        }

        @Override
        public float getScale() {
            return (float)this.getScale(ScaleType.OBJ_SCALE);
        }

        @Override
        public Icon scale(float scale) {
            this.updateScale(ScaleType.OBJ_SCALE.of(scale));
            return this;
        }

        @Override
        protected double scaleVal(double value) {
            return this.scaleVal(value, ScaleType.PIX_SCALE);
        }

        protected double scaleVal(double value, ScaleType type) {
            switch (type) {
                case USR_SCALE: {
                    return super.scaleVal(value);
                }
                case SYS_SCALE: {
                    return value * this.getScale(ScaleType.SYS_SCALE);
                }
                case OBJ_SCALE: {
                    return value * this.getScale(ScaleType.OBJ_SCALE);
                }
                case PIX_SCALE: {
                    return super.scaleVal(value * this.getScale(ScaleType.OBJ_SCALE));
                }
            }
            return value;
        }
    }

    public static abstract class JBIcon
    extends ScaleContextSupport<BaseScaleContext>
    implements Icon {
        private final Scaler myScaler = new Scaler(){

            @Override
            protected double currentScale() {
                if (JBIcon.this.autoUpdateScaleContext) {
                    ((BaseScaleContext)JBIcon.this.getScaleContext()).update();
                }
                return JBIcon.this.getScale(ScaleType.USR_SCALE);
            }
        };
        private boolean autoUpdateScaleContext = true;

        protected JBIcon() {
            super(BaseScaleContext.create());
        }

        protected JBIcon(JBIcon icon) {
            this();
            this.updateScaleContext(icon.getScaleContext());
            this.myScaler.update(icon.myScaler);
            this.autoUpdateScaleContext = icon.autoUpdateScaleContext;
        }

        protected boolean isIconPreScaled() {
            return this.myScaler.isPreScaled();
        }

        protected void setIconPreScaled(boolean preScaled) {
            this.myScaler.setPreScaled(preScaled);
        }

        @NotNull
        public JBIcon withIconPreScaled(boolean preScaled) {
            this.setIconPreScaled(preScaled);
            JBIcon jBIcon = this;
            if (jBIcon == null) {
                JBIcon.$$$reportNull$$$0(0);
            }
            return jBIcon;
        }

        protected double scaleVal(double value) {
            return this.myScaler.scaleVal(value);
        }

        protected void setAutoUpdateScaleContext(boolean autoUpdate) {
            this.autoUpdateScaleContext = autoUpdate;
        }

        public String toString() {
            return this.getClass().getName() + " " + this.getIconWidth() + "x" + this.getIconHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$JBIcon", "withIconPreScaled"));
        }
    }

    public static class ScaleContextSupport<T extends BaseScaleContext>
    implements ScaleContextAware<T> {
        @NotNull
        private final T myScaleContext;

        public ScaleContextSupport(@NotNull T ctx) {
            if (ctx == null) {
                ScaleContextSupport.$$$reportNull$$$0(0);
            }
            this.myScaleContext = ctx;
        }

        @Override
        @NotNull
        public T getScaleContext() {
            T t = this.myScaleContext;
            if (t == null) {
                ScaleContextSupport.$$$reportNull$$$0(1);
            }
            return t;
        }

        @Override
        public boolean updateScaleContext(@Nullable T ctx) {
            return ((BaseScaleContext)this.myScaleContext).update((BaseScaleContext)ctx);
        }

        @Override
        public double getScale(ScaleType type) {
            return ((BaseScaleContext)this.getScaleContext()).getScale(type);
        }

        @Override
        public boolean updateScale(Scale scale) {
            return ((BaseScaleContext)this.getScaleContext()).update(scale);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$ScaleContextSupport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$ScaleContextSupport";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScaleContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ScaleContextAware<T extends BaseScaleContext> {
        @NotNull
        public T getScaleContext();

        public boolean updateScaleContext(@Nullable T var1);

        public double getScale(ScaleType var1);

        public boolean updateScale(Scale var1);
    }

    public static class ScaleContext
    extends BaseScaleContext {
        protected Scale sysScale = ScaleType.SYS_SCALE.of(JBUI.sysScale());
        @Nullable
        private WeakReference<Component> compRef;

        private ScaleContext() {
            this.update(this.pixScale, this.derivePixScale());
        }

        private ScaleContext(Scale scale) {
            switch (scale.type) {
                case USR_SCALE: {
                    this.update(this.usrScale, scale.value);
                    break;
                }
                case SYS_SCALE: {
                    this.update(this.sysScale, scale.value);
                    break;
                }
                case OBJ_SCALE: {
                    this.update(this.objScale, scale.value);
                    break;
                }
            }
            this.update(this.pixScale, this.derivePixScale());
        }

        public static ScaleContext createIdentity() {
            return ScaleContext.create(ScaleType.USR_SCALE.of(1.0), ScaleType.SYS_SCALE.of(1.0));
        }

        public static ScaleContext create(@NotNull Component comp) {
            if (comp == null) {
                ScaleContext.$$$reportNull$$$0(0);
            }
            ScaleContext ctx = new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(comp)));
            ctx.compRef = new WeakReference<Component>(comp);
            return ctx;
        }

        public static ScaleContext create(GraphicsConfiguration gc) {
            return new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(gc)));
        }

        public static ScaleContext create(Graphics2D g) {
            return new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(g)));
        }

        public static ScaleContext create(@NotNull Scale scale) {
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(1);
            }
            return new ScaleContext(scale);
        }

        public static ScaleContext create(Scale ... scales) {
            if (scales == null) {
                ScaleContext.$$$reportNull$$$0(2);
            }
            ScaleContext ctx = ScaleContext.create();
            for (Scale s : scales) {
                ctx.update(s);
            }
            return ctx;
        }

        public static ScaleContext create() {
            return new ScaleContext();
        }

        @Override
        protected double derivePixScale() {
            return UIUtil.isJreHiDPIEnabled() ? this.sysScale.value * super.derivePixScale() : super.derivePixScale();
        }

        @Override
        public double getScale(ScaleType type) {
            if (type == ScaleType.SYS_SCALE) {
                return this.sysScale.value;
            }
            return super.getScale(type);
        }

        @Override
        public boolean update() {
            Component comp;
            boolean updated = this.update(this.usrScale, JBUI.scale(1.0f));
            if (this.compRef != null && (comp = (Component)this.compRef.get()) != null) {
                updated = this.update(this.sysScale, JBUI.sysScale(comp)) || updated;
            }
            return this.onUpdated(updated);
        }

        @Override
        public boolean update(@NotNull Scale scale) {
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(3);
            }
            if (scale.type == ScaleType.SYS_SCALE) {
                return this.onUpdated(this.update(this.sysScale, scale.value));
            }
            return super.update(scale);
        }

        @Override
        protected <T extends BaseScaleContext> boolean updateAll(@NotNull T ctx) {
            if (ctx == null) {
                ScaleContext.$$$reportNull$$$0(4);
            }
            boolean updated = super.updateAll(ctx);
            if (!(ctx instanceof ScaleContext)) {
                return updated;
            }
            ScaleContext context = (ScaleContext)ctx;
            if (this.compRef != null) {
                this.compRef.clear();
            }
            this.compRef = context.compRef;
            return this.update(this.sysScale, context.sysScale.value) || updated;
        }

        @Override
        protected boolean update(@NotNull Scale scale, double value) {
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(5);
            }
            if (scale.type == ScaleType.SYS_SCALE) {
                Scale newScale = scale.newOrThis(value);
                if (newScale == scale) {
                    return false;
                }
                this.sysScale = newScale;
                return true;
            }
            return super.update(scale, value);
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof ScaleContext) {
                ScaleContext that = (ScaleContext)obj;
                return that.sysScale.value == this.sysScale.value;
            }
            return false;
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.compRef != null) {
                this.compRef.clear();
            }
        }

        @Override
        public <T extends BaseScaleContext> T copy() {
            ScaleContext ctx = ScaleContext.createIdentity();
            ctx.updateAll(this);
            return (T)ctx;
        }

        @Override
        public String toString() {
            return this.usrScale + ", " + this.sysScale + ", " + this.objScale + ", " + this.pixScale;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comp";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scales";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/JBUI$ScaleContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateAll";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BaseScaleContext {
        protected Scale usrScale = ScaleType.USR_SCALE.of(JBUI.scale(1.0f));
        protected Scale objScale = ScaleType.OBJ_SCALE.of(1.0);
        protected Scale pixScale = ScaleType.PIX_SCALE.of(Scale.access$000(this.usrScale));
        private List<UpdateListener> listeners;

        private BaseScaleContext() {
        }

        public static BaseScaleContext createIdentity() {
            return BaseScaleContext.create(ScaleType.USR_SCALE.of(1.0));
        }

        public static BaseScaleContext create(Scale ... scales) {
            if (scales == null) {
                BaseScaleContext.$$$reportNull$$$0(0);
            }
            BaseScaleContext ctx = BaseScaleContext.create();
            for (Scale s : scales) {
                ctx.update(s);
            }
            return ctx;
        }

        public static BaseScaleContext create() {
            return new BaseScaleContext();
        }

        protected double derivePixScale() {
            return this.usrScale.value * this.objScale.value;
        }

        public double getScale(ScaleType type) {
            switch (type) {
                case USR_SCALE: {
                    return this.usrScale.value;
                }
                case SYS_SCALE: {
                    return 1.0;
                }
                case OBJ_SCALE: {
                    return this.objScale.value;
                }
                case PIX_SCALE: {
                    return this.pixScale.value;
                }
            }
            return 1.0;
        }

        protected boolean onUpdated(boolean updated) {
            if (updated) {
                this.update(this.pixScale, this.derivePixScale());
                this.notifyUpdateListeners();
            }
            return updated;
        }

        public boolean update() {
            return this.onUpdated(this.update(this.usrScale, JBUI.scale(1.0f)));
        }

        public boolean update(@NotNull Scale scale) {
            if (scale == null) {
                BaseScaleContext.$$$reportNull$$$0(1);
            }
            boolean updated = false;
            switch (scale.type) {
                case USR_SCALE: {
                    updated = this.update(this.usrScale, scale.value);
                    break;
                }
                case SYS_SCALE: {
                    break;
                }
                case OBJ_SCALE: {
                    updated = this.update(this.objScale, scale.value);
                    break;
                }
            }
            return this.onUpdated(updated);
        }

        public boolean update(@Nullable BaseScaleContext ctx) {
            if (ctx == null) {
                return this.update();
            }
            return this.onUpdated(this.updateAll(ctx));
        }

        protected <T extends BaseScaleContext> boolean updateAll(@NotNull T ctx) {
            if (ctx == null) {
                BaseScaleContext.$$$reportNull$$$0(2);
            }
            boolean updated = this.update(this.usrScale, ctx.usrScale.value);
            return this.update(this.objScale, ctx.objScale.value) || updated;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BaseScaleContext)) {
                return false;
            }
            BaseScaleContext that = (BaseScaleContext)obj;
            return that.usrScale.value == this.usrScale.value && that.objScale.value == this.objScale.value;
        }

        public void dispose() {
            this.listeners = null;
        }

        public void addUpdateListener(UpdateListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<UpdateListener>(1);
            }
            this.listeners.add(l);
        }

        public void removeUpdateListener(UpdateListener l) {
            if (this.listeners != null) {
                this.listeners.remove(l);
            }
        }

        protected void notifyUpdateListeners() {
            if (this.listeners == null) {
                return;
            }
            for (UpdateListener l : this.listeners) {
                l.contextUpdated();
            }
        }

        protected boolean update(@NotNull Scale scale, double value) {
            Scale newScale;
            if (scale == null) {
                BaseScaleContext.$$$reportNull$$$0(3);
            }
            if ((newScale = scale.newOrThis(value)) == scale) {
                return false;
            }
            switch (scale.type) {
                case USR_SCALE: {
                    this.usrScale = newScale;
                    break;
                }
                case OBJ_SCALE: {
                    this.objScale = newScale;
                    break;
                }
                case PIX_SCALE: {
                    this.pixScale = newScale;
                }
            }
            return true;
        }

        public <T extends BaseScaleContext> T copy() {
            BaseScaleContext ctx = BaseScaleContext.createIdentity();
            ctx.updateAll(this);
            return (T)ctx;
        }

        public String toString() {
            return this.usrScale + ", " + this.objScale + ", " + this.pixScale;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scales";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/JBUI$BaseScaleContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateAll";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static interface UpdateListener {
            public void contextUpdated();
        }
    }

    public static abstract class Scaler {
        protected double initialScale = this.currentScale();

        private double alignedScale() {
            return this.currentScale() / this.initialScale;
        }

        protected boolean isPreScaled() {
            return this.initialScale != 1.0;
        }

        protected void setPreScaled(boolean preScaled) {
            this.initialScale = preScaled ? this.currentScale() : 1.0;
        }

        public double scaleVal(double value) {
            return value * this.alignedScale();
        }

        protected abstract double currentScale();

        public boolean update(@NotNull Scaler scaler) {
            if (scaler == null) {
                Scaler.$$$reportNull$$$0(0);
            }
            boolean updated = this.initialScale != scaler.initialScale;
            this.initialScale = scaler.initialScale;
            return updated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scaler", "com/intellij/util/ui/JBUI$Scaler", "update"));
        }
    }

    public static class Panels {
        public static BorderLayoutPanel simplePanel() {
            return new BorderLayoutPanel();
        }

        public static BorderLayoutPanel simplePanel(Component comp) {
            return Panels.simplePanel().addToCenter(comp);
        }

        public static BorderLayoutPanel simplePanel(int hgap, int vgap) {
            return new BorderLayoutPanel(hgap, vgap);
        }
    }

    public static class Borders {
        public static JBEmptyBorder empty(int top, int left, int bottom, int right) {
            return new JBEmptyBorder(top, left, bottom, right);
        }

        public static JBEmptyBorder empty(int topAndBottom, int leftAndRight) {
            return Borders.empty(topAndBottom, leftAndRight, topAndBottom, leftAndRight);
        }

        public static JBEmptyBorder emptyTop(int offset) {
            return Borders.empty(offset, 0, 0, 0);
        }

        public static JBEmptyBorder emptyLeft(int offset) {
            return Borders.empty(0, offset, 0, 0);
        }

        public static JBEmptyBorder emptyBottom(int offset) {
            return Borders.empty(0, 0, offset, 0);
        }

        public static JBEmptyBorder emptyRight(int offset) {
            return Borders.empty(0, 0, 0, offset);
        }

        public static JBEmptyBorder empty() {
            return Borders.empty(0, 0, 0, 0);
        }

        public static Border empty(int offsets) {
            return Borders.empty(offsets, offsets, offsets, offsets);
        }

        public static Border customLine(Color color, int top, int left, int bottom, int right) {
            return new CustomLineBorder(color, JBUI.insets(top, left, bottom, right));
        }

        public static Border customLine(Color color, int thickness) {
            return Borders.customLine(color, thickness, thickness, thickness, thickness);
        }

        public static Border customLine(Color color) {
            return Borders.customLine(color, 1);
        }

        public static Border merge(@Nullable Border source, @NotNull Border extra, boolean extraIsOutside) {
            if (extra == null) {
                Borders.$$$reportNull$$$0(0);
            }
            if (source == null) {
                return extra;
            }
            return new CompoundBorder(extraIsOutside ? extra : source, extraIsOutside ? source : extra);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extra", "com/intellij/util/ui/JBUI$Borders", "merge"));
        }
    }

    public static class Fonts {
        @NotNull
        public static JBFont label() {
            JBFont jBFont = JBFont.create(UIManager.getFont("Label.font"), false);
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(0);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont label(float size) {
            JBFont jBFont = Fonts.label().deriveFont(JBUI.scale(size));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(1);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont smallFont() {
            JBFont jBFont = Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(2);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont miniFont() {
            JBFont jBFont = Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.MINI));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(3);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont create(String fontFamily, int size) {
            JBFont jBFont = JBFont.create(new Font(fontFamily, 0, size));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(4);
            }
            return jBFont;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/ui/JBUI$Fonts";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "label";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "smallFont";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "miniFont";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Scale {
        private final double value;
        private final ScaleType type;
        private static final ThreadLocal<EnumMap<ScaleType, TDoubleObjectHashMap<Scale>>> cache = new ThreadLocal<EnumMap<ScaleType, TDoubleObjectHashMap<Scale>>>(){

            @Override
            protected EnumMap<ScaleType, TDoubleObjectHashMap<Scale>> initialValue() {
                return new EnumMap<ScaleType, TDoubleObjectHashMap<Scale>>(ScaleType.class);
            }
        };

        public static Scale create(double value, ScaleType type) {
            Scale scale;
            EnumMap<ScaleType, TDoubleObjectHashMap<Scale>> emap = cache.get();
            TDoubleObjectHashMap map = emap.get((Object)type);
            if (map == null) {
                map = new TDoubleObjectHashMap();
                emap.put(type, (TDoubleObjectHashMap<Scale>)map);
            }
            if ((scale = (Scale)map.get(value)) != null) {
                return scale;
            }
            scale = new Scale(value, type);
            map.put(value, (Object)scale);
            return scale;
        }

        private Scale(double value, ScaleType type) {
            this.value = value;
            this.type = type;
        }

        public double value() {
            return this.value;
        }

        public ScaleType type() {
            return this.type;
        }

        public Scale newOrThis(double value) {
            if (this.value == value) {
                return this;
            }
            return this.type.of(value);
        }

        public String toString() {
            return "[" + this.type.name() + " " + this.value + "]";
        }
    }

    public static enum ScaleType {
        USR_SCALE,
        SYS_SCALE,
        OBJ_SCALE,
        PIX_SCALE;


        public Scale of(double value) {
            return Scale.create(value, this);
        }
    }
}

