/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapWithAdapterMethodCallFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private static final Wrapper[] WRAPPERS = new Wrapper[]{new Wrapper("new java.io.File({0})", inType -> inType.equalsToText("java.lang.String"), outType -> outType.equalsToText("java.io.File")), new Wrapper("java.nio.file.Paths.get({0})", inType -> inType.equalsToText("java.lang.String"), outType -> outType.equalsToText("java.nio.file.Path")), new Wrapper("java.util.Arrays.asList({0})", inType -> inType instanceof PsiArrayType && ((PsiArrayType)inType).getComponentType() instanceof PsiClassType, outType -> InheritanceUtil.isInheritor(outType, "java.lang.Iterable")), new Wrapper("java.lang.Math.toIntExact({0})", inType -> PsiType.LONG.equals(inType) || inType.equalsToText("java.lang.Long"), outType -> PsiType.INT.equals(outType) || outType.equalsToText("java.lang.Integer")), new Wrapper("java.util.Collections.singleton({0})", inType -> true, outType -> InheritanceUtil.isInheritor(outType, "java.lang.Iterable")), new Wrapper("java.util.Collections.singletonList({0})", inType -> true, outType -> outType instanceof PsiClassType && ((PsiClassType)outType).rawType().equalsToText("java.util.List")), new Wrapper("java.util.Arrays.stream({0})", inType -> inType instanceof PsiArrayType, outType -> InheritanceUtil.isInheritor(outType, "java.util.stream.BaseStream"))};
    @Nullable
    private final PsiType myType;
    @Nullable
    private final Wrapper myWrapper;

    public WrapWithAdapterMethodCallFix(@Nullable PsiType type, @NotNull PsiExpression expression) {
        if (expression == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(0);
        }
        super(expression);
        this.myType = type;
        this.myWrapper = StreamEx.of((Object[])WRAPPERS).findFirst(w -> {
            if (expression == null) {
                WrapWithAdapterMethodCallFix.$$$reportNull$$$0(14);
            }
            return w.isApplicable(expression, expression.getType(), type);
        }).orElse(null);
    }

    @Override
    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("wrap.with.adapter.text", this.myWrapper);
        if (string == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("wrap.with.adapter.call.family.name", new Object[0]);
        if (string == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(6);
        }
        return this.myType != null && this.myWrapper != null && this.myType.isValid() && startElement.getManager().isInProject(startElement);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(10);
        }
        JavaCodeStyleManager.getInstance(project).shortenClassReferences(startElement.replace(this.getModifiedExpression(startElement)));
    }

    private PsiExpression getModifiedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(11);
        }
        assert (this.myWrapper != null);
        return this.myWrapper.createReplacement(expression, expression.getText());
    }

    public static void registerCastActions(@NotNull CandidateInfo[] candidates, @NotNull PsiCall call, HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(12);
        }
        if (call == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(13);
        }
        for (Wrapper wrapper : WRAPPERS) {
            wrapper.registerCastActions(candidates, call, highlightInfo, fixRange);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModifiedExpression";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerCastActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$14";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMethodArgumentFix
    extends MethodArgumentFix
    implements HighPriorityAction {
        protected MyMethodArgumentFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull Wrapper fixerActionFactory) {
            if (list == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(0);
            }
            if (toType == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(1);
            }
            if (fixerActionFactory == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(2);
            }
            super(list, i, toType, fixerActionFactory);
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String string = this.myArgList.getExpressionCount() == 1 ? QuickFixBundle.message("wrap.with.adapter.parameter.single.text", this.myArgumentFixerActionFactory) : QuickFixBundle.message("wrap.with.adapter.parameter.multiple.text", this.myIndex + 1, this.myArgumentFixerActionFactory);
            if (string == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixerActionFactory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix$MyMethodArgumentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix$MyMethodArgumentFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class Wrapper
    extends ArgumentFixerActionFactory {
        final Predicate<PsiType> myInTypeFilter;
        final Predicate<PsiType> myOutTypeFilter;
        final String myTemplate;

        Wrapper(String template, Predicate<PsiType> inTypeFilter, Predicate<PsiType> outTypeFilter) {
            this.myInTypeFilter = inTypeFilter;
            this.myOutTypeFilter = outTypeFilter;
            this.myTemplate = template;
        }

        boolean isApplicable(PsiElement context, PsiType inType, PsiType outType) {
            PsiExpression replacement;
            String typeText;
            if (inType == null || outType == null || inType.equals(PsiType.NULL) || !this.myInTypeFilter.test(inType) || !this.myOutTypeFilter.test(outType)) {
                return false;
            }
            PsiType variableType = GenericsUtil.getVariableTypeByExpressionType(inType);
            if (LambdaUtil.notInferredType(variableType)) {
                return false;
            }
            if (variableType instanceof PsiDisjunctionType) {
                variableType = ((PsiDisjunctionType)variableType).getLeastUpperBound();
            }
            if ((typeText = variableType.getCanonicalText()).isEmpty()) {
                return false;
            }
            try {
                replacement = this.createReplacement(context, "((" + typeText + ")null)");
            }
            catch (IncorrectOperationException ioe) {
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(variableType);
                String message = "Cannot create expression for type " + variableType.getClass() + "\nCanonical text: " + variableType.getCanonicalText() + "\nInternal text: " + variableType.getInternalCanonicalText() + "\n";
                if (aClass != null) {
                    message = message + "Class: " + aClass.getClass() + "|" + aClass.getQualifiedName() + "\nFile: " + aClass.getContainingFile() + "\n";
                }
                throw new IncorrectOperationException(message, (Throwable)ioe);
            }
            PsiDeclarationStatement declaration = JavaPsiFacade.getElementFactory(context.getProject()).createVariableDeclarationStatement("x", outType, replacement, context);
            PsiVariable var = ObjectUtils.tryCast(ArrayUtil.getFirstElement(declaration.getDeclaredElements()), PsiVariable.class);
            if (var == null) {
                return false;
            }
            PsiExpression initializer = var.getInitializer();
            if (initializer == null) {
                return false;
            }
            PsiType resultType = initializer.getType();
            return resultType != null && outType.isAssignableFrom(resultType);
        }

        @NotNull
        private PsiExpression createReplacement(PsiElement context, String replacement) {
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory(context.getProject()).createExpressionFromText(this.myTemplate.replace("{0}", replacement), context);
            if (psiExpression == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            return psiExpression;
        }

        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            if (this.isApplicable(expression, expression.getType(), toType)) {
                return (PsiExpression)JavaCodeStyleManager.getInstance(expression.getProject()).shortenClassReferences(this.createReplacement(expression, expression.getText()));
            }
            return null;
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                Wrapper.$$$reportNull$$$0(1);
            }
            if (parameterType == null) {
                Wrapper.$$$reportNull$$$0(2);
            }
            if (context == null) {
                Wrapper.$$$reportNull$$$0(3);
            }
            return parameterType.isConvertibleFrom(exprType) || this.isApplicable(context, exprType, parameterType);
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new MyMethodArgumentFix(list, i, toType, this);
        }

        public String toString() {
            return this.myTemplate.replace("{0}", "").replaceAll("\\b[a-z.]+\\.", "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix$Wrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exprType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReplacement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix$Wrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "areTypesConvertible";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

