/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class PuritySolver {
    private final HashMap<EKey, Effects> solved = new HashMap();
    private final HashMap<EKey, Set<EKey>> dependencies = new HashMap();
    private final ArrayDeque<EKey> moving = new ArrayDeque();
    HashMap<EKey, Effects> pending = new HashMap();

    PuritySolver() {
    }

    void addEquation(EKey key, Effects effects) {
        Set depKeys = effects.dependencies().collect(Collectors.toSet());
        if (depKeys.isEmpty()) {
            this.solved.put(key, effects);
            this.moving.add(key);
        } else {
            this.pending.put(key, effects);
            for (EKey depKey : depKeys) {
                this.dependencies.computeIfAbsent(depKey, k -> new HashSet()).add(key);
            }
        }
    }

    public Map<EKey, Effects> solve() {
        while (!this.moving.isEmpty()) {
            Effects[] propagateEffects;
            EKey[] propagateKeys;
            EKey key = this.moving.pop();
            Effects effects = this.solved.get(key);
            if (key.stable) {
                propagateKeys = new EKey[]{key, key.mkUnstable()};
                propagateEffects = new Effects[]{effects, effects};
            } else {
                propagateKeys = new EKey[]{key.mkStable(), key};
                propagateEffects = new Effects[]{effects, new Effects(DataValue.UnknownDataValue1, Effects.TOP_EFFECTS)};
            }
            for (int i = 0; i < propagateKeys.length; ++i) {
                EKey pKey = propagateKeys[i];
                Effects pEffects = propagateEffects[i];
                Set<EKey> dKeys = this.dependencies.remove(pKey);
                if (dKeys == null) continue;
                for (EKey dKey : dKeys) {
                    Effects dEffects = this.pending.remove(dKey);
                    if (dEffects == null) continue;
                    Set<EffectQuantum> newEffects = new HashSet<EffectQuantum>();
                    Set<EffectQuantum> delta = null;
                    DataValue returnValue = PuritySolver.substitute(dEffects.returnValue, pKey, pEffects);
                    for (EffectQuantum dEffect : dEffects.effects) {
                        if (dEffect instanceof EffectQuantum.CallQuantum) {
                            EffectQuantum.CallQuantum call = PuritySolver.substitute((EffectQuantum.CallQuantum)dEffect, pKey, pEffects);
                            if (call.key.equals(pKey)) {
                                delta = PuritySolver.substitute(pEffects, call.data, call.isStatic);
                                if (delta.equals(Effects.TOP_EFFECTS)) {
                                    newEffects = delta;
                                    break;
                                }
                                newEffects.addAll(delta);
                                continue;
                            }
                            newEffects.add(call);
                            continue;
                        }
                        if (dEffect instanceof EffectQuantum.ReturnChangeQuantum) {
                            EffectQuantum.ReturnChangeQuantum retChange = (EffectQuantum.ReturnChangeQuantum)dEffect;
                            if (retChange.key.equals(pKey)) {
                                if (pEffects.returnValue == DataValue.LocalDataValue) continue;
                                delta = Effects.TOP_EFFECTS;
                                newEffects = delta;
                                break;
                            }
                        }
                        if (dEffect instanceof EffectQuantum.FieldReadQuantum && ((EffectQuantum.FieldReadQuantum)dEffect).key.equals(pKey)) {
                            newEffects.addAll(pEffects.effects);
                            continue;
                        }
                        newEffects.add(dEffect);
                    }
                    if (Effects.TOP_EFFECTS.equals(delta) && returnValue.equals(DataValue.UnknownDataValue1)) {
                        this.solved.put(dKey, new Effects(returnValue, Effects.TOP_EFFECTS));
                        this.moving.push(dKey);
                        continue;
                    }
                    Effects result2 = new Effects(returnValue, newEffects);
                    if (result2.dependencies().findFirst().isPresent()) {
                        this.pending.put(dKey, result2);
                        continue;
                    }
                    this.solved.put(dKey, result2);
                    this.moving.push(dKey);
                }
            }
        }
        return this.solved;
    }

    public void addPlainFieldEquations(Predicate<MemberDescriptor> plainByDefault) {
        for (EKey key : this.dependencies.keySet()) {
            if (key.getDirection() != Direction.Volatile || !plainByDefault.test(key.member)) continue;
            this.solved.putIfAbsent(key, new Effects(DataValue.UnknownDataValue1, Collections.emptySet()));
            this.moving.add(key);
        }
    }

    private static EffectQuantum.CallQuantum substitute(EffectQuantum.CallQuantum call, EKey pKey, Effects pEffects) {
        ArrayList<DataValue> list = new ArrayList<DataValue>();
        boolean same = true;
        for (DataValue value : call.data) {
            DataValue newValue = PuritySolver.substitute(value, pKey, pEffects);
            same &= newValue.equals(value);
            list.add(newValue);
        }
        return same ? call : new EffectQuantum.CallQuantum(call.key, list.toArray(DataValue.EMPTY), call.isStatic);
    }

    private static DataValue substitute(DataValue value, EKey key, Effects effects) {
        if (value instanceof DataValue.ReturnDataValue && ((DataValue.ReturnDataValue)value).key.equals(key)) {
            return effects.returnValue == DataValue.LocalDataValue ? DataValue.LocalDataValue : DataValue.UnknownDataValue1;
        }
        return value;
    }

    private static Set<EffectQuantum> substitute(Effects effects, DataValue[] data, boolean isStatic) {
        if (effects.effects.isEmpty() || Effects.TOP_EFFECTS.equals(effects.effects)) {
            return effects.effects;
        }
        HashSet<EffectQuantum> newEffects = new HashSet<EffectQuantum>(effects.effects.size());
        int shift = isStatic ? 0 : 1;
        for (EffectQuantum effect : effects.effects) {
            DataValue arg = null;
            if (effect == EffectQuantum.ThisChangeQuantum) {
                arg = data[0];
            } else if (effect instanceof EffectQuantum.ParamChangeQuantum) {
                EffectQuantum.ParamChangeQuantum paramChange = (EffectQuantum.ParamChangeQuantum)effect;
                arg = data[paramChange.n + shift];
            }
            if (arg == null || arg == DataValue.LocalDataValue) continue;
            if (arg == DataValue.ThisDataValue || arg == DataValue.OwnedDataValue) {
                newEffects.add(EffectQuantum.ThisChangeQuantum);
                continue;
            }
            if (arg instanceof DataValue.ParameterDataValue) {
                newEffects.add(new EffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)arg).n));
                continue;
            }
            if (arg instanceof DataValue.ReturnDataValue) {
                newEffects.add(new EffectQuantum.ReturnChangeQuantum(((DataValue.ReturnDataValue)arg).key));
                continue;
            }
            return Effects.TOP_EFFECTS;
        }
        return newEffects;
    }
}

