/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.htmlInspections.RemoveExtraClosingTagIntentionAction;
import com.intellij.codeInspection.htmlInspections.RenameTagBeginOrEndIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlWrongClosingTagNameInspection
implements Annotator {
    @Override
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            XmlWrongClosingTagNameInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            XmlWrongClosingTagNameInspection.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof XmlToken) {
            String message;
            PsiFile psiFile;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof XmlTag) {
                XmlTag tag = (XmlTag)parent;
                XmlToken start = XmlTagUtil.getStartTagNameElement(tag);
                XmlToken endTagName = XmlTagUtil.getEndTagNameElement(tag);
                if (start == psiElement) {
                    PsiErrorElement errorElement;
                    if (endTagName != null && !(tag instanceof HtmlTag) && !tag.getName().equals(endTagName.getText())) {
                        XmlWrongClosingTagNameInspection.registerProblemStart(holder, tag, start, endTagName);
                    } else if (!(endTagName != null || tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag.getName()) || (endTagName = XmlWrongClosingTagNameInspection.findEndTagName(errorElement = PsiTreeUtil.getChildOfType(tag, PsiErrorElement.class))) == null)) {
                        XmlWrongClosingTagNameInspection.registerProblemStart(holder, tag, start, endTagName);
                    }
                } else if (endTagName == psiElement && !(tag instanceof HtmlTag) && !tag.getName().equals(endTagName.getText())) {
                    XmlWrongClosingTagNameInspection.registerProblemEnd(holder, tag, endTagName);
                }
            } else if (parent instanceof PsiErrorElement && XmlTokenType.XML_NAME == ((XmlToken)psiElement).getTokenType() && (psiFile = psiElement.getContainingFile()) != null && (HTMLLanguage.INSTANCE == psiFile.getViewProvider().getBaseLanguage() || HTMLLanguage.INSTANCE == parent.getLanguage()) && (message = XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0])).equals(((PsiErrorElement)parent).getErrorDescription()) && psiFile.getContext() == null) {
                Annotation annotation = holder.createWarningAnnotation(parent, message);
                annotation.registerFix(new RemoveExtraClosingTagIntentionAction());
            }
        }
    }

    private static void registerProblemStart(@NotNull AnnotationHolder holder, @NotNull XmlTag tag, @NotNull XmlToken start, @NotNull XmlToken end) {
        ASTNode contextNode;
        ParserDefinition parserDefinition;
        PsiElement context;
        if (holder == null) {
            XmlWrongClosingTagNameInspection.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            XmlWrongClosingTagNameInspection.$$$reportNull$$$0(3);
        }
        if (start == null) {
            XmlWrongClosingTagNameInspection.$$$reportNull$$$0(4);
        }
        if (end == null) {
            XmlWrongClosingTagNameInspection.$$$reportNull$$$0(5);
        }
        if ((context = tag.getContainingFile().getContext()) != null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(context.getLanguage())) != null && (contextNode = context.getNode()) != null && contextNode.getChildren(parserDefinition.getStringLiteralElements()) != null) {
            return;
        }
        String tagName = tag.getName();
        String endTokenText = end.getText();
        RenameTagBeginOrEndIntentionAction renameEndAction = new RenameTagBeginOrEndIntentionAction(tagName, endTokenText, false);
        RenameTagBeginOrEndIntentionAction renameStartAction = new RenameTagBeginOrEndIntentionAction(endTokenText, tagName, true);
        Annotation annotation = holder.createErrorAnnotation(start, XmlErrorMessages.message("tag.has.wrong.closing.tag.name", new Object[0]));
        annotation.registerFix(renameEndAction);
        annotation.registerFix(renameStartAction);
    }

    private static void registerProblemEnd(@NotNull AnnotationHolder holder, @NotNull XmlTag tag, @NotNull XmlToken end) {
        ASTNode contextNode;
        ParserDefinition parserDefinition;
        PsiElement context;
        if (holder == null) {
            XmlWrongClosingTagNameInspection.$$$reportNull$$$0(6);
        }
        if (tag == null) {
            XmlWrongClosingTagNameInspection.$$$reportNull$$$0(7);
        }
        if (end == null) {
            XmlWrongClosingTagNameInspection.$$$reportNull$$$0(8);
        }
        if ((context = tag.getContainingFile().getContext()) != null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(context.getLanguage())) != null && (contextNode = context.getNode()) != null && contextNode.getChildren(parserDefinition.getStringLiteralElements()) != null) {
            return;
        }
        String tagName = tag.getName();
        String endTokenText = end.getText();
        RenameTagBeginOrEndIntentionAction renameEndAction = new RenameTagBeginOrEndIntentionAction(tagName, endTokenText, false);
        RenameTagBeginOrEndIntentionAction renameStartAction = new RenameTagBeginOrEndIntentionAction(endTokenText, tagName, true);
        Annotation annotation = holder.createErrorAnnotation(end, XmlErrorMessages.message("wrong.closing.tag.name", new Object[0]));
        annotation.registerFix(new RemoveExtraClosingTagIntentionAction());
        annotation.registerFix(renameEndAction);
        annotation.registerFix(renameStartAction);
    }

    @Nullable
    static XmlToken findEndTagName(@Nullable PsiErrorElement element) {
        ASTNode current;
        if (element == null) {
            return null;
        }
        ASTNode astNode = element.getNode();
        if (astNode == null) {
            return null;
        }
        ASTNode prev = current = astNode.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current;
            current = current.getTreePrev();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblemStart";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblemEnd";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

