/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ZipEntryMap
extends AbstractMap<String, ArchiveHandler.EntryInfo> {
    private ArchiveHandler.EntryInfo[] entries;
    private int size = 0;
    private EntrySet entrySet;

    ZipEntryMap(int expectedSize) {
        this.entries = new ArchiveHandler.EntryInfo[Math.max(10, expectedSize * 2)];
    }

    @Override
    public ArchiveHandler.EntryInfo get(@NotNull Object key) {
        ArchiveHandler.EntryInfo entry;
        int index;
        if (key == null) {
            ZipEntryMap.$$$reportNull$$$0(0);
        }
        String relativePath = (String)key;
        int i = index = ZipEntryMap.index(relativePath, this.entries);
        while ((entry = this.entries[i]) != null && !ZipEntryMap.isTheOne(entry, relativePath)) {
            if (++i == this.entries.length) {
                i = 0;
            }
            if (i != index) continue;
            entry = null;
            break;
        }
        return entry;
    }

    private static int index(@NotNull String relativePath, @NotNull ArchiveHandler.EntryInfo[] entries) {
        if (relativePath == null) {
            ZipEntryMap.$$$reportNull$$$0(1);
        }
        if (entries == null) {
            ZipEntryMap.$$$reportNull$$$0(2);
        }
        return (relativePath.hashCode() & Integer.MAX_VALUE) % entries.length;
    }

    @Override
    public ArchiveHandler.EntryInfo put(String relativePath, ArchiveHandler.EntryInfo value) {
        ArchiveHandler.EntryInfo old;
        if (this.size >= 5 * this.entries.length / 8) {
            this.rehash();
        }
        if ((old = ZipEntryMap.put(relativePath, value, this.entries)) == null) {
            ++this.size;
        }
        return old;
    }

    @Nullable
    private static ArchiveHandler.EntryInfo put(@NotNull String relativePath, @NotNull ArchiveHandler.EntryInfo value, @NotNull ArchiveHandler.EntryInfo[] entries) {
        ArchiveHandler.EntryInfo entry;
        int index;
        if (relativePath == null) {
            ZipEntryMap.$$$reportNull$$$0(3);
        }
        if (value == null) {
            ZipEntryMap.$$$reportNull$$$0(4);
        }
        if (entries == null) {
            ZipEntryMap.$$$reportNull$$$0(5);
        }
        int i = index = ZipEntryMap.index(relativePath, entries);
        while (true) {
            if ((entry = entries[i]) == null || ZipEntryMap.isTheOne(entry, relativePath)) break;
            if (++i != entries.length) continue;
            i = 0;
        }
        entries[i] = value;
        return entry;
    }

    private static boolean isTheOne(@NotNull ArchiveHandler.EntryInfo entry, @NotNull CharSequence relativePath) {
        if (entry == null) {
            ZipEntryMap.$$$reportNull$$$0(6);
        }
        if (relativePath == null) {
            ZipEntryMap.$$$reportNull$$$0(7);
        }
        int endIndex = relativePath.length();
        ArchiveHandler.EntryInfo e = entry;
        while (e != null) {
            CharSequence shortName = e.shortName;
            if (!CharArrayUtil.regionMatches(relativePath, endIndex - shortName.length(), relativePath.length(), shortName)) {
                return false;
            }
            if (e.parent != null && e.parent.shortName.length() != 0 && (endIndex -= shortName.length()) != 0) {
                if (relativePath.charAt(endIndex - 1) == '/') {
                    --endIndex;
                } else {
                    return false;
                }
            }
            e = e.parent;
        }
        return endIndex == 0;
    }

    @NotNull
    private ArchiveHandler.EntryInfo[] rehash() {
        ArchiveHandler.EntryInfo[] newEntries = new ArchiveHandler.EntryInfo[this.entries.length < 1000 ? this.entries.length * 2 : this.entries.length * 3 / 2];
        for (ArchiveHandler.EntryInfo entry : this.entries) {
            if (entry == null) continue;
            ZipEntryMap.put(ZipEntryMap.getRelativePath(entry), entry, newEntries);
        }
        this.entries = newEntries;
        if (newEntries == null) {
            ZipEntryMap.$$$reportNull$$$0(8);
        }
        return newEntries;
    }

    @NotNull
    private static String getRelativePath(@NotNull ArchiveHandler.EntryInfo entry) {
        if (entry == null) {
            ZipEntryMap.$$$reportNull$$$0(9);
        }
        StringBuilder result2 = new StringBuilder(entry.shortName.length() + 10);
        ArchiveHandler.EntryInfo e = entry;
        while (e != null) {
            if (result2.length() != 0 && e.shortName.length() != 0) {
                result2.append('/');
            }
            ZipEntryMap.appendReversed(result2, e.shortName);
            e = e.parent;
        }
        String string = result2.reverse().toString();
        if (string == null) {
            ZipEntryMap.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void appendReversed(@NotNull StringBuilder builder, @NotNull CharSequence sequence) {
        if (builder == null) {
            ZipEntryMap.$$$reportNull$$$0(11);
        }
        if (sequence == null) {
            ZipEntryMap.$$$reportNull$$$0(12);
        }
        for (int i = sequence.length() - 1; i >= 0; --i) {
            builder.append(sequence.charAt(i));
        }
    }

    @Override
    public ArchiveHandler.EntryInfo remove(@NotNull Object key) {
        if (key == null) {
            ZipEntryMap.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.entries = new ArchiveHandler.EntryInfo[10];
    }

    @NotNull
    public EntrySet entrySet() {
        EntrySet es = this.entrySet;
        EntrySet entrySet = es == null ? (this.entrySet = new EntrySet()) : es;
        if (entrySet == null) {
            ZipEntryMap.$$$reportNull$$$0(14);
        }
        return entrySet;
    }

    @Override
    @NotNull
    public Collection<ArchiveHandler.EntryInfo> values() {
        List<Object> list = ContainerUtil.filter(this.entries, Condition.NOT_NULL);
        if (list == null) {
            ZipEntryMap.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipEntryMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipEntryMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "rehash";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTheOne";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendReversed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<String, ArchiveHandler.EntryInfo>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return ZipEntryMap.this.size();
        }

        @Override
        public final void clear() {
            ZipEntryMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<String, ArchiveHandler.EntryInfo>> iterator() {
            return ContainerUtil.mapIterator(ContainerUtil.iterate(ZipEntryMap.this.entries, Condition.NOT_NULL).iterator(), entry -> new AbstractMap.SimpleEntry<String, ArchiveHandler.EntryInfo>(ZipEntryMap.getRelativePath(entry), (ArchiveHandler.EntryInfo)entry));
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String key = (String)e.getKey();
            ArchiveHandler.EntryInfo value = (ArchiveHandler.EntryInfo)e.getValue();
            return value.equals(ZipEntryMap.this.get(key));
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

