/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.JvmTypeDeclaration;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.lang.jvm.types.JvmTypeResolveResult;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJvmSubstitutor;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiClassType
extends PsiType
implements JvmReferenceType {
    public static final PsiClassType[] EMPTY_ARRAY = new PsiClassType[0];
    public static final ArrayFactory<PsiClassType> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiClassType[count];
    protected final LanguageLevel myLanguageLevel;

    protected PsiClassType(LanguageLevel languageLevel) {
        this(languageLevel, PsiAnnotation.EMPTY_ARRAY);
    }

    protected PsiClassType(LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            PsiClassType.$$$reportNull$$$0(0);
        }
        super(annotations);
        this.myLanguageLevel = languageLevel;
    }

    public PsiClassType(LanguageLevel languageLevel, @NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiClassType.$$$reportNull$$$0(1);
        }
        super(provider);
        this.myLanguageLevel = languageLevel;
    }

    @Override
    @NotNull
    public PsiClassType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiClassType.$$$reportNull$$$0(2);
        }
        PsiClassType psiClassType = (PsiClassType)super.annotate(provider);
        if (psiClassType == null) {
            PsiClassType.$$$reportNull$$$0(3);
        }
        return psiClassType;
    }

    @Override
    @Nullable
    public abstract PsiClass resolve();

    public abstract String getClassName();

    @NotNull
    public abstract PsiType[] getParameters();

    public int getParameterCount() {
        return this.getParameters().length;
    }

    public boolean equals(Object obj) {
        ClassResolveResult otherResult;
        String otherClassName;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiClassType)) {
            return obj instanceof PsiCapturedWildcardType && ((PsiCapturedWildcardType)obj).getLowerBound().equalsToText("java.lang.Object") && this.equalsToText("java.lang.Object");
        }
        PsiClassType otherClassType = (PsiClassType)obj;
        String className = this.getClassName();
        if (!Comparing.equal(className, otherClassName = otherClassType.getClassName())) {
            return false;
        }
        if (this.getParameterCount() != otherClassType.getParameterCount()) {
            return false;
        }
        ClassResolveResult result2 = this.resolveGenerics();
        if (result2 == (otherResult = otherClassType.resolveGenerics())) {
            return true;
        }
        PsiClass aClass = result2.getElement();
        PsiClass otherClass = otherResult.getElement();
        if (aClass == null || otherClass == null) {
            return aClass == otherClass;
        }
        return aClass.getManager().areElementsEquivalent(aClass, otherClass) && (PsiUtil.isRawSubstitutor(aClass, result2.getSubstitutor()) || PsiUtil.equalOnEquivalentClasses(this, aClass, otherClassType, otherClass));
    }

    public boolean hasParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            return false;
        }
        boolean hasParams = false;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
            if (resolveResult.getSubstitutor().substitute(parameter) == null) {
                return false;
            }
            hasParams = true;
        }
        return hasParams;
    }

    public boolean hasNonTrivialParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
            PsiClass superClass;
            PsiType type = resolveResult.getSubstitutor().substitute(parameter);
            if (type == null) continue;
            if (!(type instanceof PsiWildcardType)) {
                return true;
            }
            PsiType bound = ((PsiWildcardType)type).getBound();
            if (bound == null || ((PsiWildcardType)type).isExtends() && (superClass = parameter.getSuperClass()) != null && PsiUtil.resolveClassInType(bound) == superClass) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        String className = this.getClassName();
        if (className == null) {
            return 0;
        }
        return className.hashCode();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            if (EMPTY_ARRAY == null) {
                PsiClassType.$$$reportNull$$$0(4);
            }
            return EMPTY_ARRAY;
        }
        PsiClassType[] superTypes = aClass.getSuperTypes();
        PsiType[] substitutionResults = PsiClassType.createArray(superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            substitutionResults[i] = resolveResult.getSubstitutor().substitute(superTypes[i]);
        }
        if (substitutionResults == null) {
            PsiClassType.$$$reportNull$$$0(5);
        }
        return substitutionResults;
    }

    public static boolean isRaw(ClassResolveResult resolveResult) {
        PsiClass psiClass = resolveResult.getElement();
        return psiClass != null && PsiUtil.isRawSubstitutor(psiClass, resolveResult.getSubstitutor());
    }

    public boolean isRaw() {
        return PsiClassType.isRaw(this.resolveGenerics());
    }

    @NotNull
    public abstract ClassResolveResult resolveGenerics();

    @NotNull
    public abstract PsiClassType rawType();

    @Override
    @NotNull
    public abstract GlobalSearchScope getResolveScope();

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            PsiClassType.$$$reportNull$$$0(6);
        }
        return visitor.visitClassType(this);
    }

    @NotNull
    public abstract LanguageLevel getLanguageLevel();

    @NotNull
    @Contract(pure=true)
    public abstract PsiClassType setLanguageLevel(@NotNull LanguageLevel var1);

    @Override
    @NotNull
    public String getName() {
        String string = this.getClassName();
        if (string == null) {
            PsiClassType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    public JvmTypeResolveResult resolveType() {
        final ClassResolveResult resolveResult = this.resolveGenerics();
        final PsiClass clazz = resolveResult.getElement();
        return clazz == null ? null : new JvmTypeResolveResult(){
            private final JvmSubstitutor mySubstitutor;
            {
                this.mySubstitutor = new PsiJvmSubstitutor(clazz.getProject(), resolveResult.getSubstitutor());
            }

            @Override
            @NotNull
            public JvmTypeDeclaration getDeclaration() {
                PsiClass psiClass = clazz;
                if (psiClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiClass;
            }

            @Override
            @NotNull
            public JvmSubstitutor getSubstitutor() {
                JvmSubstitutor jvmSubstitutor = this.mySubstitutor;
                if (jvmSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jvmSubstitutor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/PsiClassType$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubstitutor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public Iterable<JvmType> typeArguments() {
        List<JvmType> list = Arrays.asList(this.getParameters());
        if (list == null) {
            PsiClassType.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiClassType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiClassType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "typeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Stub
    extends PsiClassType {
        protected Stub(LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
            if (annotations == null) {
                Stub.$$$reportNull$$$0(0);
            }
            super(languageLevel, annotations);
        }

        protected Stub(LanguageLevel languageLevel, @NotNull TypeAnnotationProvider annotations) {
            if (annotations == null) {
                Stub.$$$reportNull$$$0(1);
            }
            super(languageLevel, annotations);
        }

        @Override
        @NotNull
        public final String getPresentableText() {
            String string = this.getPresentableText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getPresentableText(boolean var1);

        @Override
        @NotNull
        public final String getCanonicalText() {
            String string = this.getCanonicalText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotations";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/PsiClassType$Stub";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/PsiClassType$Stub";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ClassResolveResult
    extends JavaResolveResult {
        public static final ClassResolveResult EMPTY = new ClassResolveResult(){

            @Override
            public PsiClass getElement() {
                return null;
            }

            @Override
            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
                if (psiSubstitutor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiSubstitutor;
            }

            @Override
            public boolean isValidResult() {
                return false;
            }

            @Override
            public boolean isAccessible() {
                return false;
            }

            @Override
            public boolean isStaticsScopeCorrect() {
                return false;
            }

            @Override
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            @Override
            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiClassType$ClassResolveResult$1", "getSubstitutor"));
            }
        };

        @Override
        public PsiClass getElement();
    }
}

