/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.ProjectTopics;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBus;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class UpdatingScopeOnProjectStructureChangeListener
implements ProjectComponent,
ModuleListener {
    public UpdatingScopeOnProjectStructureChangeListener(MessageBus messageBus) {
        messageBus.connect().subscribe(ProjectTopics.MODULES, this);
    }

    @Override
    public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
        if (project == null) {
            UpdatingScopeOnProjectStructureChangeListener.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            UpdatingScopeOnProjectStructureChangeListener.$$$reportNull$$$0(1);
        }
        if (oldNameProvider == null) {
            UpdatingScopeOnProjectStructureChangeListener.$$$reportNull$$$0(2);
        }
        Map<String, String> moduleMap = modules.stream().collect(Collectors.toMap(oldNameProvider::fun, Module::getName));
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(project)) {
            Object[] oldScopes = holder.getEditableScopes();
            Object[] newScopes = new NamedScope[oldScopes.length];
            for (int i = 0; i < oldScopes.length; ++i) {
                newScopes[i] = UpdatingScopeOnProjectStructureChangeListener.renameModulesIn((NamedScope)oldScopes[i], moduleMap);
            }
            if (Arrays.equals(newScopes, oldScopes)) continue;
            holder.setScopes((NamedScope[])newScopes);
        }
    }

    private static NamedScope renameModulesIn(NamedScope scope, Map<String, String> nameMapping) {
        PackageSet oldSet = scope.getValue();
        if (oldSet == null) {
            return scope;
        }
        PackageSet newSet = oldSet.map(packageSet -> {
            String modulePattern;
            String newName;
            if (packageSet instanceof PatternBasedPackageSet && (newName = (String)nameMapping.get(modulePattern = ((PatternBasedPackageSet)packageSet).getModulePattern())) != null) {
                return ((PatternBasedPackageSet)packageSet).updateModulePattern(modulePattern, newName);
            }
            return packageSet;
        });
        if (newSet != oldSet) {
            return new NamedScope(scope.getName(), newSet);
        }
        return scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "modules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "oldNameProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/search/scope/packageSet/UpdatingScopeOnProjectStructureChangeListener";
        objectArray[2] = "modulesRenamed";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

