/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.foundation.FoundationLibrary;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Callback;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Foundation {
    private static final FoundationLibrary myFoundationLibrary;
    static Callback ourRunnableCallback;
    private static final Map<String, RunnableInfo> ourMainThreadRunnables;
    private static long ourCurrentRunnableCount;
    private static final Object RUNNABLE_LOCK;

    public static void init() {
    }

    private Foundation() {
    }

    public static ID getObjcClass(String className) {
        return myFoundationLibrary.objc_getClass(className);
    }

    public static ID getProtocol(String name) {
        return myFoundationLibrary.objc_getProtocol(name);
    }

    public static Pointer createSelector(String s) {
        return myFoundationLibrary.sel_registerName(s);
    }

    public static ID invoke(ID id, Pointer selector, Object ... args) {
        return myFoundationLibrary.objc_msgSend(id, selector, args);
    }

    public static ID invoke(String cls, String selector, Object ... args) {
        return Foundation.invoke(Foundation.getObjcClass(cls), Foundation.createSelector(selector), args);
    }

    public static ID safeInvoke(String stringCls, String stringSelector, Object ... args) {
        ID cls = Foundation.getObjcClass(stringCls);
        Pointer selector = Foundation.createSelector(stringSelector);
        if (Foundation.invoke(cls, "respondsToSelector:", selector).intValue() == 0) {
            throw new RuntimeException(String.format("Missing selector %s for %s", stringSelector, stringCls));
        }
        return Foundation.invoke(cls, selector, args);
    }

    public static ID invoke(ID id, String selector, Object ... args) {
        return Foundation.invoke(id, Foundation.createSelector(selector), args);
    }

    public static ID safeInvoke(ID id, String stringSelector, Object ... args) {
        Pointer selector = Foundation.createSelector(stringSelector);
        if (!id.equals((Object)ID.NIL) && Foundation.invoke(id, "respondsToSelector:", selector).intValue() == 0) {
            throw new RuntimeException(String.format("Missing selector %s for %s", stringSelector, Foundation.toStringViaUTF8(Foundation.invoke(id, "description", new Object[0]))));
        }
        return Foundation.invoke(id, selector, args);
    }

    public static ID allocateObjcClassPair(ID superCls, String name) {
        return myFoundationLibrary.objc_allocateClassPair(superCls, name, 0);
    }

    public static void registerObjcClassPair(ID cls) {
        myFoundationLibrary.objc_registerClassPair(cls);
    }

    public static boolean isClassRespondsToSelector(ID cls, Pointer selectorName) {
        return myFoundationLibrary.class_respondsToSelector(cls, selectorName);
    }

    public static boolean addMethod(ID cls, Pointer selectorName, Callback impl, String types) {
        return myFoundationLibrary.class_addMethod(cls, selectorName, impl, types);
    }

    public static boolean addProtocol(ID aClass, ID protocol) {
        return myFoundationLibrary.class_addProtocol(aClass, protocol);
    }

    public static boolean addMethodByID(ID cls, Pointer selectorName, ID impl, String types) {
        return myFoundationLibrary.class_addMethod(cls, selectorName, impl, types);
    }

    public static boolean isMetaClass(ID cls) {
        return myFoundationLibrary.class_isMetaClass(cls);
    }

    @Nullable
    public static String stringFromSelector(Pointer selector) {
        ID id = myFoundationLibrary.NSStringFromSelector(selector);
        if (id.intValue() > 0) {
            return Foundation.toStringViaUTF8(id);
        }
        return null;
    }

    public static Pointer getClass(Pointer clazz) {
        return myFoundationLibrary.objc_getClass(clazz);
    }

    public static String fullUserName() {
        return Foundation.toStringViaUTF8(myFoundationLibrary.NSFullUserName());
    }

    public static ID class_replaceMethod(ID cls, Pointer selector, Callback impl, String types) {
        return myFoundationLibrary.class_replaceMethod(cls, selector, impl, types);
    }

    public static ID getMetaClass(String className) {
        return myFoundationLibrary.objc_getMetaClass(className);
    }

    public static boolean isPackageAtPath(@NotNull String path) {
        if (path == null) {
            Foundation.$$$reportNull$$$0(0);
        }
        ID workspace = Foundation.invoke("NSWorkspace", "sharedWorkspace", new Object[0]);
        ID result2 = Foundation.invoke(workspace, Foundation.createSelector("isFilePackageAtPath:"), new Object[]{Foundation.nsString(path)});
        return result2.intValue() == 1;
    }

    public static boolean isPackageAtPath(@NotNull File file) {
        if (file == null) {
            Foundation.$$$reportNull$$$0(1);
        }
        if (!file.isDirectory()) {
            return false;
        }
        return Foundation.isPackageAtPath(file.getPath());
    }

    @NotNull
    public static ID nsString(@Nullable String s) {
        block7: {
            ID iD;
            if (s == null) {
                ID iD2 = ID.NIL;
                if (iD2 == null) {
                    Foundation.$$$reportNull$$$0(2);
                }
                return iD2;
            }
            try {
                if (!s.isEmpty()) break block7;
                iD = Foundation.invoke("NSString", "string", new Object[0]);
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
            if (iD == null) {
                Foundation.$$$reportNull$$$0(3);
            }
            return iD;
        }
        byte[] utf16Bytes = s.getBytes("UTF-16LE");
        ID iD = Foundation.invoke(Foundation.invoke(Foundation.invoke("NSString", "alloc", new Object[0]), "initWithBytes:length:encoding:", utf16Bytes, utf16Bytes.length, Foundation.convertCFEncodingToNS(0x14000100L)), "autorelease", new Object[0]);
        if (iD == null) {
            Foundation.$$$reportNull$$$0(4);
        }
        return iD;
    }

    public static ID nsUUID(@NotNull UUID uuid) {
        if (uuid == null) {
            Foundation.$$$reportNull$$$0(5);
        }
        return Foundation.nsUUID(uuid.toString());
    }

    public static ID nsUUID(@NotNull String uuid) {
        if (uuid == null) {
            Foundation.$$$reportNull$$$0(6);
        }
        return Foundation.invoke(Foundation.invoke(Foundation.invoke("NSUUID", "alloc", new Object[0]), "initWithUUIDString:", new Object[]{Foundation.nsString(uuid)}), "autorelease", new Object[0]);
    }

    @Nullable
    public static String toStringViaUTF8(ID cfString) {
        if (cfString.intValue() == 0) {
            return null;
        }
        int lengthInChars = myFoundationLibrary.CFStringGetLength(cfString);
        int potentialLengthInBytes = 3 * lengthInChars + 1;
        byte[] buffer = new byte[potentialLengthInBytes];
        byte ok = myFoundationLibrary.CFStringGetCString(cfString, buffer, buffer.length, 0x8000100);
        if (ok == 0) {
            throw new RuntimeException("Could not convert string");
        }
        return Native.toString((byte[])buffer);
    }

    @Nullable
    public static String getNSErrorText(@Nullable ID error) {
        if (error == null || error.byteValue() == 0) {
            return null;
        }
        String description = Foundation.toStringViaUTF8(Foundation.invoke(error, "localizedDescription", new Object[0]));
        String recovery = Foundation.toStringViaUTF8(Foundation.invoke(error, "localizedRecoverySuggestion", new Object[0]));
        if (recovery != null) {
            description = description + "\n" + recovery;
        }
        return StringUtil.notNullize(description);
    }

    @Nullable
    public static String getEncodingName(long nsStringEncoding) {
        long cfEncoding = myFoundationLibrary.CFStringConvertNSStringEncodingToEncoding(nsStringEncoding);
        ID pointer = myFoundationLibrary.CFStringConvertEncodingToIANACharSetName(cfEncoding);
        String name = Foundation.toStringViaUTF8(pointer);
        if ("macintosh".equals(name)) {
            name = "MacRoman";
        }
        return name;
    }

    public static long getEncodingCode(@Nullable String encodingName) {
        if (StringUtil.isEmptyOrSpaces(encodingName)) {
            return -1L;
        }
        ID converted = Foundation.nsString(encodingName);
        long cfEncoding = myFoundationLibrary.CFStringConvertIANACharSetNameToEncoding(converted);
        ID restored = myFoundationLibrary.CFStringConvertEncodingToIANACharSetName(cfEncoding);
        if (ID.NIL.equals((Object)restored)) {
            return -1L;
        }
        return Foundation.convertCFEncodingToNS(cfEncoding);
    }

    private static long convertCFEncodingToNS(long cfEncoding) {
        return myFoundationLibrary.CFStringConvertEncodingToNSStringEncoding(cfEncoding) & 0xFFFFFFFFFFL;
    }

    public static void cfRetain(ID id) {
        myFoundationLibrary.CFRetain(id);
    }

    public static ID cgWindowListCreateImage(NSRect screenBounds, int windowOption, ID windowID, int imageOption) {
        return myFoundationLibrary.CGWindowListCreateImage(screenBounds, windowOption, windowID, imageOption);
    }

    public static void cfRelease(ID ... ids) {
        for (ID id : ids) {
            if (id == null) continue;
            myFoundationLibrary.CFRelease(id);
        }
    }

    public static boolean isMainThread() {
        return Foundation.invoke("NSThread", "isMainThread", new Object[0]).intValue() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeOnMainThread(boolean withAutoreleasePool, boolean waitUntilDone, Runnable runnable) {
        Foundation.initRunnableSupport();
        Object object = RUNNABLE_LOCK;
        synchronized (object) {
            ourMainThreadRunnables.put(String.valueOf(++ourCurrentRunnableCount), new RunnableInfo(runnable, withAutoreleasePool));
        }
        ID ideaRunnable = Foundation.getObjcClass("IdeaRunnable");
        ID runnableObject = Foundation.invoke(Foundation.invoke(ideaRunnable, "alloc", new Object[0]), "init", new Object[0]);
        Foundation.invoke(runnableObject, "performSelectorOnMainThread:withObject:waitUntilDone:", new Object[]{Foundation.createSelector("run:"), Foundation.nsString(String.valueOf(ourCurrentRunnableCount)), waitUntilDone});
        Foundation.invoke(runnableObject, "release", new Object[0]);
    }

    private static void initRunnableSupport() {
        if (ourRunnableCallback == null) {
            ID runnableClass = Foundation.allocateObjcClassPair(Foundation.getObjcClass("NSObject"), "IdeaRunnable");
            Foundation.registerObjcClassPair(runnableClass);
            Callback callback = new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void callback(ID self, String selector, ID keyObject) {
                    RunnableInfo info;
                    String key = Foundation.toStringViaUTF8(keyObject);
                    Object object = RUNNABLE_LOCK;
                    synchronized (object) {
                        info = (RunnableInfo)ourMainThreadRunnables.remove(key);
                    }
                    if (info == null) {
                        return;
                    }
                    ID pool = null;
                    try {
                        if (info.myUseAutoreleasePool) {
                            pool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
                        }
                        info.myRunnable.run();
                    }
                    finally {
                        if (pool != null) {
                            Foundation.invoke(pool, "release", new Object[0]);
                        }
                    }
                }
            };
            if (!Foundation.addMethod(runnableClass, Foundation.createSelector("run:"), callback, "v@:*")) {
                throw new RuntimeException("Unable to add method to objective-c runnableClass class!");
            }
            ourRunnableCallback = callback;
        }
    }

    public static ID fillArray(Object[] a) {
        ID result2 = Foundation.invoke("NSMutableArray", "array", new Object[0]);
        for (Object s : a) {
            Foundation.invoke(result2, "addObject:", Foundation.convertType(s));
        }
        return result2;
    }

    public static ID createDict(@NotNull String[] keys, @NotNull Object[] values) {
        if (keys == null) {
            Foundation.$$$reportNull$$$0(7);
        }
        if (values == null) {
            Foundation.$$$reportNull$$$0(8);
        }
        ID nsKeys = Foundation.invoke("NSArray", "arrayWithObjects:", Foundation.convertTypes(keys));
        ID nsData = Foundation.invoke("NSArray", "arrayWithObjects:", Foundation.convertTypes(values));
        return Foundation.invoke("NSDictionary", "dictionaryWithObjects:forKeys:", new Object[]{nsData, nsKeys});
    }

    @NotNull
    public static PointerType createPointerReference() {
        PointerByReference reference = new PointerByReference((Pointer)new Memory((long)Native.POINTER_SIZE));
        reference.getPointer().clear((long)Native.POINTER_SIZE);
        PointerByReference pointerByReference = reference;
        if (pointerByReference == null) {
            Foundation.$$$reportNull$$$0(9);
        }
        return pointerByReference;
    }

    private static Object[] convertTypes(@NotNull Object[] v) {
        if (v == null) {
            Foundation.$$$reportNull$$$0(10);
        }
        Object[] result2 = new Object[v.length];
        for (int i = 0; i < v.length; ++i) {
            result2[i] = Foundation.convertType(v[i]);
        }
        return result2;
    }

    private static Object convertType(@NotNull Object o) {
        if (o == null) {
            Foundation.$$$reportNull$$$0(11);
        }
        if (o instanceof Pointer || o instanceof ID) {
            return o;
        }
        if (o instanceof String) {
            return Foundation.nsString((String)o);
        }
        throw new IllegalArgumentException("Unsupported type! " + o.getClass());
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        HashMap foundationOptions = new HashMap();
        myFoundationLibrary = (FoundationLibrary)Native.loadLibrary((String)"Foundation", FoundationLibrary.class, foundationOptions);
        ourMainThreadRunnables = new HashMap<String, RunnableInfo>();
        ourCurrentRunnableCount = 0L;
        RUNNABLE_LOCK = new Object();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/foundation/Foundation";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/foundation/Foundation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "nsString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointerReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPackageAtPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nsUUID";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDict";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertTypes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CGFloat
    implements NativeMapped {
        private final double value;

        public CGFloat() {
            this(0.0);
        }

        public CGFloat(double d) {
            this.value = d;
        }

        public Object fromNative(Object o, FromNativeContext fromNativeContext) {
            switch (Native.LONG_SIZE) {
                case 4: {
                    return new CGFloat(((Float)o).floatValue());
                }
                case 8: {
                    return new CGFloat((Double)o);
                }
            }
            throw new IllegalStateException();
        }

        public Object toNative() {
            switch (Native.LONG_SIZE) {
                case 4: {
                    return Float.valueOf((float)this.value);
                }
                case 8: {
                    return this.value;
                }
            }
            throw new IllegalStateException();
        }

        public Class<?> nativeType() {
            switch (Native.LONG_SIZE) {
                case 4: {
                    return Float.class;
                }
                case 8: {
                    return Double.class;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class NSSize
    extends Structure
    implements Structure.ByValue {
        private static final List __FIELDS = Arrays.asList("width", "height");
        public CGFloat width;
        public CGFloat height;

        public NSSize() {
            this(0.0, 0.0);
        }

        public NSSize(double width, double height) {
            this.width = new CGFloat(width);
            this.height = new CGFloat(height);
        }

        protected List getFieldOrder() {
            return __FIELDS;
        }
    }

    public static class NSPoint
    extends Structure
    implements Structure.ByValue {
        private static final List __FIELDS = Arrays.asList("x", "y");
        public CGFloat x;
        public CGFloat y;

        public NSPoint() {
            this(0.0, 0.0);
        }

        public NSPoint(double x, double y) {
            this.x = new CGFloat(x);
            this.y = new CGFloat(y);
        }

        protected List getFieldOrder() {
            return __FIELDS;
        }
    }

    public static class NSRect
    extends Structure
    implements Structure.ByValue {
        private static final List __FIELDS = Arrays.asList("origin", "size");
        public NSPoint origin;
        public NSSize size;

        public NSRect(double x, double y, double w, double h) {
            this.origin = new NSPoint(x, y);
            this.size = new NSSize(w, h);
        }

        protected List getFieldOrder() {
            return __FIELDS;
        }
    }

    public static class NSAutoreleasePool {
        private final ID myDelegate = Foundation.invoke(Foundation.invoke("NSAutoreleasePool", "alloc", new Object[0]), "init", new Object[0]);

        public void drain() {
            Foundation.invoke(this.myDelegate, "drain", new Object[0]);
        }
    }

    public static class NSArray {
        private final ID myDelegate;

        public NSArray(ID delegate) {
            this.myDelegate = delegate;
        }

        public int count() {
            return Foundation.invoke(this.myDelegate, "count", new Object[0]).intValue();
        }

        public ID at(int index) {
            return Foundation.invoke(this.myDelegate, "objectAtIndex:", index);
        }
    }

    public static class NSDictionary {
        private final ID myDelegate;

        public NSDictionary(ID delegate) {
            this.myDelegate = delegate;
        }

        public ID get(ID key) {
            return Foundation.invoke(this.myDelegate, "objectForKey:", new Object[]{key});
        }

        public ID get(String key) {
            return this.get(Foundation.nsString(key));
        }

        public int count() {
            return Foundation.invoke(this.myDelegate, "count", new Object[0]).intValue();
        }

        public NSArray keys() {
            return new NSArray(Foundation.invoke(this.myDelegate, "allKeys", new Object[0]));
        }

        @NotNull
        public static Map<String, String> toStringMap(ID delegate) {
            NSDictionary dict = new NSDictionary(delegate);
            NSArray keys = dict.keys();
            HashMap<String, String> result2 = new HashMap<String, String>();
            for (int i = 0; i < keys.count(); ++i) {
                String key = Foundation.toStringViaUTF8(keys.at(i));
                String val = Foundation.toStringViaUTF8(dict.get(key));
                result2.put(key, val);
            }
            HashMap<String, String> hashMap = result2;
            if (hashMap == null) {
                NSDictionary.$$$reportNull$$$0(0);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/mac/foundation/Foundation$NSDictionary", "toStringMap"));
        }
    }

    static class RunnableInfo {
        Runnable myRunnable;
        boolean myUseAutoreleasePool;

        RunnableInfo(Runnable runnable, boolean useAutoreleasePool) {
            this.myRunnable = runnable;
            this.myUseAutoreleasePool = useAutoreleasePool;
        }
    }
}

