/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.WeakestTypeFinder;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclareCollectionAsInterfaceInspection
extends BaseInspection {
    public boolean ignoreLocalVariables = false;
    public boolean ignorePrivateMethodsAndFields = false;

    @Override
    @NotNull
    public String getID() {
        if ("CollectionDeclaredAsConcreteClass" == null) {
            DeclareCollectionAsInterfaceInspection.$$$reportNull$$$0(0);
        }
        return "CollectionDeclaredAsConcreteClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collection.declared.by.class.display.name", new Object[0]);
        if (string == null) {
            DeclareCollectionAsInterfaceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        String string = InspectionGadgetsBundle.message("collection.declared.by.class.problem.descriptor", type);
        if (string == null) {
            DeclareCollectionAsInterfaceInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("collection.declared.by.class.ignore.locals.option", new Object[0]), "ignoreLocalVariables");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("collection.declared.by.class.ignore.private.members.option", new Object[0]), "ignorePrivateMethodsAndFields");
        return optionsPanel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeclareCollectionAsInterfaceFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DeclareCollectionAsInterfaceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class DeclareCollectionAsInterfaceVisitor
    extends BaseInspectionVisitor {
        private DeclareCollectionAsInterfaceVisitor() {
        }

        @Override
        public void visitVariable(@NotNull PsiVariable variable) {
            PsiMethod method;
            PsiParameter parameter;
            PsiElement scope;
            if (variable == null) {
                DeclareCollectionAsInterfaceVisitor.$$$reportNull$$$0(0);
            }
            if (this.isOnTheFly() && DeclarationSearchUtils.isTooExpensiveToSearch(variable, false)) {
                return;
            }
            if (DeclareCollectionAsInterfaceInspection.this.ignoreLocalVariables && variable instanceof PsiLocalVariable) {
                return;
            }
            if (DeclareCollectionAsInterfaceInspection.this.ignorePrivateMethodsAndFields && variable instanceof PsiField && variable.hasModifierProperty("private")) {
                return;
            }
            if (variable instanceof PsiParameter && ((scope = (parameter = (PsiParameter)variable).getDeclarationScope()) instanceof PsiMethod ? DeclareCollectionAsInterfaceInspection.this.ignorePrivateMethodsAndFields && (method = (PsiMethod)scope).hasModifierProperty("private") : DeclareCollectionAsInterfaceInspection.this.ignoreLocalVariables)) {
                return;
            }
            PsiType type = variable.getType();
            if (!CollectionUtils.isConcreteCollectionClass(type) || LibraryUtil.isOverrideOfLibraryMethodParameter(variable)) {
                return;
            }
            this.checkToWeaken(type, variable.getTypeElement(), variable);
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                DeclareCollectionAsInterfaceVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethod(method);
            if (DeclareCollectionAsInterfaceInspection.this.ignorePrivateMethodsAndFields && method.hasModifierProperty("private")) {
                return;
            }
            if (this.isOnTheFly() && DeclarationSearchUtils.isTooExpensiveToSearch(method, false)) {
                return;
            }
            PsiType type = method.getReturnType();
            if (!CollectionUtils.isConcreteCollectionClass(type) || LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.checkToWeaken(type, method.getReturnTypeElement(), method);
        }

        private void checkToWeaken(PsiType type, PsiTypeElement typeElement, PsiElement variable) {
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement reference = typeElement.getInnermostComponentReferenceElement();
            if (reference == null) {
                return;
            }
            PsiElement nameElement = reference.getReferenceNameElement();
            if (nameElement == null) {
                return;
            }
            Collection<PsiClass> weaklings = WeakestTypeFinder.calculateWeakestClassesNecessary(variable, false, true);
            if (weaklings.isEmpty()) {
                return;
            }
            PsiClassType javaLangObject = PsiType.getJavaLangObject(nameElement.getManager(), nameElement.getResolveScope());
            ArrayList<PsiClass> weaklingList = new ArrayList<PsiClass>(weaklings);
            PsiClass objectClass = javaLangObject.resolve();
            weaklingList.remove(objectClass);
            if (weaklingList.isEmpty()) {
                String typeText = type.getCanonicalText();
                String interfaceText = CollectionUtils.getInterfaceForClass(typeText);
                if (interfaceText == null) {
                    return;
                }
                this.registerError(nameElement, interfaceText);
            } else {
                PsiClass weakling = (PsiClass)weaklingList.get(0);
                String qualifiedName = weakling.getQualifiedName();
                this.registerError(nameElement, qualifiedName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection$DeclareCollectionAsInterfaceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DeclareCollectionAsInterfaceFix
    extends InspectionGadgetsFix {
        private final String typeString;

        DeclareCollectionAsInterfaceFix(String typeString) {
            this.typeString = typeString;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("declare.collection.as.interface.quickfix", this.typeString);
            if (string == null) {
                DeclareCollectionAsInterfaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Weaken type" == null) {
                DeclareCollectionAsInterfaceFix.$$$reportNull$$$0(1);
            }
            return "Weaken type";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement grandParent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            StringBuilder newElementText = new StringBuilder(this.typeString);
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList != null) {
                newElementText.append(parameterList.getText());
            }
            if (!((grandParent = parent.getParent()) instanceof PsiTypeElement)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(newElementText.toString(), element);
            JavaCodeStyleManager.getInstance(project).shortenClassReferences(grandParent.replace(newTypeElement));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection$DeclareCollectionAsInterfaceFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

