/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopConditionNotUpdatedInsideLoopInspection
extends BaseInspection {
    public boolean ignorePossibleNonLocalChanges = true;
    public boolean ignoreIterators = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("loop.condition.not.updated.inside.loop.display.name", new Object[0]);
        if (string == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean entireCondition = (Boolean)infos[0];
        if (entireCondition) {
            String string = InspectionGadgetsBundle.message("loop.condition.not.updated.inside.loop.problem.descriptor", new Object[0]);
            if (string == null) {
                LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("loop.variable.not.updated.inside.loop.problem.descriptor", new Object[0]);
        if (string == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(3);
        }
        this.defaultWriteSettings(node, "ignorePossibleNonLocalChanges");
        this.writeBooleanOption(node, "ignorePossibleNonLocalChanges", true);
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("loop.variable.not.updated.inside.loop.option.nonlocal", new Object[0]), this, "ignorePossibleNonLocalChanges");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopConditionNotUpdatedInsideLoopVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LoopConditionNotUpdatedInsideLoopVisitor
    extends BaseInspectionVisitor {
        private LoopConditionNotUpdatedInsideLoopVisitor() {
        }

        @Override
        public void visitWhileStatement(PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiExpression condition = statement.getCondition();
            this.check(condition, statement);
        }

        @Override
        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            PsiExpression condition = statement.getCondition();
            this.check(condition, statement);
        }

        @Override
        public void visitForStatement(PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiExpression condition = statement.getCondition();
            this.check(condition, statement);
        }

        private void check(@Nullable PsiExpression condition, @NotNull PsiLoopStatement statement) {
            if (statement == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(0);
            }
            SmartList<PsiExpression> notUpdated = new SmartList<PsiExpression>();
            PsiStatement body = statement.getBody();
            if (body == null || condition == null || SideEffectChecker.mayHaveSideEffects(condition)) {
                return;
            }
            if (LoopConditionNotUpdatedInsideLoopInspection.this.ignorePossibleNonLocalChanges && !ExpressionUtils.isLocallyDefinedExpression(condition)) {
                PsiStatement update;
                if (SideEffectChecker.mayHaveNonLocalSideEffects(body)) {
                    return;
                }
                if (statement instanceof PsiForStatement && (update = ((PsiForStatement)statement).getUpdate()) != null && SideEffectChecker.mayHaveNonLocalSideEffects(update)) {
                    return;
                }
            }
            if (this.isConditionNotUpdated(condition, statement, notUpdated)) {
                if (!ControlFlowUtils.statementMayCompleteNormally(body) && !ControlFlowUtils.statementIsContinueTarget(statement)) {
                    return;
                }
                if (notUpdated.isEmpty()) {
                    if (!BoolUtils.isBooleanLiteral(condition)) {
                        this.registerError((PsiElement)condition, Boolean.TRUE);
                    }
                } else {
                    for (PsiExpression expression : notUpdated) {
                        this.registerError((PsiElement)expression, Boolean.FALSE);
                    }
                }
            }
        }

        private boolean isConditionNotUpdated(@Nullable PsiExpression condition, @NotNull PsiStatement context, List<PsiExpression> notUpdated) {
            if (context == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(1);
            }
            if (condition == null) {
                return false;
            }
            if (PsiUtil.isConstantExpression(condition) || ExpressionUtils.isNullLiteral(condition)) {
                return true;
            }
            if (condition instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)condition;
                PsiExpression operand = instanceOfExpression.getOperand();
                return this.isConditionNotUpdated(operand, context, notUpdated);
            }
            if (condition instanceof PsiParenthesizedExpression) {
                PsiExpression expression = ((PsiParenthesizedExpression)condition).getExpression();
                return this.isConditionNotUpdated(expression, context, notUpdated);
            }
            if (condition instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (this.isConditionNotUpdated(operand, context, notUpdated)) continue;
                    return false;
                }
                return true;
            }
            if (condition instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)condition;
                PsiElement element = referenceExpression.resolve();
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    PsiType type = field.getType();
                    if (field.hasModifierProperty("final") && type.getArrayDimensions() == 0) {
                        if (field.hasModifierProperty("static")) {
                            return true;
                        }
                        PsiExpression qualifier = referenceExpression.getQualifierExpression();
                        if (qualifier == null) {
                            return true;
                        }
                        if (this.isConditionNotUpdated(qualifier, context, notUpdated)) {
                            return true;
                        }
                    }
                } else if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                    boolean arrayUpdated;
                    PsiVariable variable = (PsiVariable)element;
                    boolean isFinal = variable.hasModifierProperty("final");
                    PsiType type = variable.getType();
                    boolean bl = arrayUpdated = type instanceof PsiArrayType && VariableAccessUtils.arrayContentsAreAssigned(variable, context);
                    if (!(!isFinal && VariableAccessUtils.variableIsAssigned(variable, context) || arrayUpdated)) {
                        if (!isFinal) {
                            notUpdated.add(referenceExpression);
                        }
                        return true;
                    }
                }
            } else if (condition instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
                if (!PsiUtil.isIncrementDecrementOperation(prefixExpression)) {
                    PsiExpression operand = prefixExpression.getOperand();
                    return this.isConditionNotUpdated(operand, context, notUpdated);
                }
            } else {
                if (condition instanceof PsiArrayAccessExpression) {
                    PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)condition;
                    PsiExpression indexExpression = accessExpression.getIndexExpression();
                    return this.isConditionNotUpdated(indexExpression, context, notUpdated) && this.isConditionNotUpdated(accessExpression.getArrayExpression(), context, notUpdated);
                }
                if (condition instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)condition;
                    PsiExpression thenExpression = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression = conditionalExpression.getElseExpression();
                    if (thenExpression == null || elseExpression == null) {
                        return false;
                    }
                    return this.isConditionNotUpdated(conditionalExpression.getCondition(), context, notUpdated) && this.isConditionNotUpdated(thenExpression, context, notUpdated) && this.isConditionNotUpdated(elseExpression, context, notUpdated);
                }
                if (condition instanceof PsiMethodCallExpression) {
                    PsiExpression qualifier = ((PsiMethodCallExpression)condition).getMethodExpression().getQualifierExpression();
                    if (!this.isConditionNotUpdated(qualifier, context, notUpdated)) {
                        return false;
                    }
                    for (PsiExpression arg : ((PsiMethodCallExpression)condition).getArgumentList().getExpressions()) {
                        if (this.isConditionNotUpdated(arg, context, notUpdated)) continue;
                        return false;
                    }
                    return true;
                }
                if (condition instanceof PsiTypeCastExpression) {
                    return this.isConditionNotUpdated(((PsiTypeCastExpression)condition).getOperand(), context, notUpdated);
                }
                if (condition instanceof PsiThisExpression || condition instanceof PsiClassObjectAccessExpression) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection$LoopConditionNotUpdatedInsideLoopVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isConditionNotUpdated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

