/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryBoxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyBoxed = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.boxing.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryBoxingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.boxing.superfluous.option", new Object[0]), this, "onlyReportSuperfluouslyBoxed");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.boxing.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryBoxingInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryBoxingFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBoxingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/migration/UnnecessaryBoxingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryBoxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBoxingVisitor() {
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiType expectedType;
            if (expression == null) {
                UnnecessaryBoxingVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiType constructorType = expression.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(constructorType);
            if (unboxedType == null) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            PsiType argumentType = boxedExpression.getType();
            if (!(argumentType instanceof PsiPrimitiveType) || this.isBoxingNecessary(expression, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiType expectedType;
            super.visitMethodCallExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            if (!(boxedExpression.getType() instanceof PsiPrimitiveType)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            String canonicalText = referenceExpression.getCanonicalText();
            if (PsiTypesUtil.unboxIfPossible(canonicalText) == canonicalText || this.isBoxingNecessary(expression, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private boolean isBoxingNecessary(PsiExpression boxingExpression, PsiExpression boxedExpression) {
            PsiElement parent = boxingExpression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                boxingExpression = (PsiExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiReferenceExpression) {
                return true;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                return TypeUtils.isTypeParameter(castExpression.getType());
            }
            if (parent instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                PsiExpression thenExpression = conditionalExpression.getThenExpression();
                PsiExpression elseExpression = conditionalExpression.getElseExpression();
                if (elseExpression == null || thenExpression == null) {
                    return true;
                }
                if (PsiTreeUtil.isAncestor(thenExpression, boxingExpression, false)) {
                    PsiType type = elseExpression.getType();
                    return !(type instanceof PsiPrimitiveType);
                }
                if (PsiTreeUtil.isAncestor(elseExpression, boxingExpression, false)) {
                    PsiType type = thenExpression.getType();
                    return !(type instanceof PsiPrimitiveType);
                }
                return false;
            }
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                return this.isPossibleObjectComparison(boxingExpression, polyadicExpression);
            }
            return MethodCallUtils.isNecessaryForSurroundingMethodCall(boxingExpression, boxedExpression) || !LambdaUtil.isSafeLambdaReturnValueReplacement(boxingExpression, boxedExpression);
        }

        private boolean isPossibleObjectComparison(PsiExpression expression, PsiPolyadicExpression polyadicExpression) {
            if (!ComparisonUtils.isEqualityComparison(polyadicExpression)) {
                return false;
            }
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (operand == expression || operand.getType() instanceof PsiPrimitiveType) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor", "visitNewExpression"));
        }
    }

    private static class UnnecessaryBoxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryBoxingFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.boxing.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) {
            String replacementText;
            PsiCallExpression expression;
            PsiExpressionList argumentList;
            if (project == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(1);
            }
            if ((argumentList = (expression = (PsiCallExpression)descriptor.getPsiElement()).getArgumentList()) == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression unboxedExpression = arguments[0];
            Object value = ExpressionUtils.computeConstantExpression(unboxedExpression);
            CommentTracker commentTracker = new CommentTracker();
            if (value != null) {
                if (value == Boolean.TRUE) {
                    PsiReplacementUtil.replaceExpression(expression, "java.lang.Boolean.TRUE", commentTracker);
                    return;
                }
                if (value == Boolean.FALSE) {
                    PsiReplacementUtil.replaceExpression(expression, "java.lang.Boolean.FALSE", commentTracker);
                    return;
                }
            }
            if ((replacementText = UnnecessaryBoxingFix.getUnboxedExpressionText(unboxedExpression, expression, commentTracker)) == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression(expression, replacementText, commentTracker);
        }

        @Nullable
        private static String getUnboxedExpressionText(@NotNull PsiExpression unboxedExpression, @NotNull PsiExpression boxedExpression, CommentTracker commentTracker) {
            PsiType boxedType;
            if (unboxedExpression == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(2);
            }
            if (boxedExpression == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(3);
            }
            if ((boxedType = boxedExpression.getType()) == null) {
                return null;
            }
            PsiType expressionType = unboxedExpression.getType();
            if (expressionType == null) {
                return null;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(boxedType);
            if (unboxedType == null) {
                return null;
            }
            String text2 = commentTracker.text(unboxedExpression);
            if (expressionType.equals(unboxedType)) {
                PsiElement parent = boxedExpression.getParent();
                if (parent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(unboxedExpression, (PsiExpression)parent, false)) {
                    return '(' + text2 + ')';
                }
                return text2;
            }
            if (unboxedExpression instanceof PsiLiteralExpression) {
                if (((Object)unboxedType).equals(PsiType.LONG) && expressionType.equals(PsiType.INT)) {
                    return text2 + 'L';
                }
                if (((Object)unboxedType).equals(PsiType.FLOAT) && (expressionType.equals(PsiType.INT) || expressionType.equals(PsiType.DOUBLE) && !StringUtil.endsWithIgnoreCase(text2, "d"))) {
                    return text2 + 'f';
                }
                if (((Object)unboxedType).equals(PsiType.DOUBLE) && expressionType.equals(PsiType.INT)) {
                    return text2 + 'd';
                }
            }
            if (ParenthesesUtils.getPrecedence(unboxedExpression) > 4) {
                return '(' + ((PsiType)unboxedType).getCanonicalText() + ")(" + text2 + ')';
            }
            return '(' + ((PsiType)unboxedType).getCanonicalText() + ')' + text2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unboxedExpression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "boxedExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUnboxedExpressionText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

