/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryConstantArrayCreationExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryConstantArrayCreationExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryConstantArrayCreationExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length != 0 && infos[0] instanceof String) {
            return new UnnecessaryConstantArrayCreationExpressionFix((String)infos[0]);
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConstantArrayCreationExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryConstantArrayCreationExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryConstantArrayCreationExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConstantArrayCreationExpressionVisitor() {
        }

        @Override
        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            super.visitArrayInitializerExpression(expression);
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)grandParent;
            PsiType expressionType = expression.getType();
            if (!variable.getType().equals(expressionType)) {
                return;
            }
            if (UnnecessaryConstantArrayCreationExpressionVisitor.hasGenericTypeParameters(variable)) {
                return;
            }
            this.registerError(parent, expressionType.getPresentableText());
        }

        private static boolean hasGenericTypeParameters(PsiVariable variable) {
            PsiType[] parameterTypes;
            PsiType type = variable.getType();
            PsiType componentType = type.getDeepComponentType();
            if (!(componentType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)componentType;
            for (PsiType parameterType : parameterTypes = classType.getParameters()) {
                if (parameterType == null) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnnecessaryConstantArrayCreationExpressionFix
    extends InspectionGadgetsFix {
        private final String myType;

        private UnnecessaryConstantArrayCreationExpressionFix(String type) {
            this.myType = type;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.family.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryConstantArrayCreationExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.quickfix", this.myType);
            if (string == null) {
                UnnecessaryConstantArrayCreationExpressionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)newExpression, arrayInitializer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/UnnecessaryConstantArrayCreationExpressionInspection$UnnecessaryConstantArrayCreationExpressionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

