/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicyEx;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.ModuleStubBuildingVisitor;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.cls.ClsFormatException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClsFileImpl
extends ClsRepositoryPsiElement<PsiClassHolderFileStub>
implements PsiJavaFile,
PsiFileWithStubSupport,
PsiFileEx,
Queryable,
PsiClassOwnerEx,
PsiCompiledFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsFileImpl");
    private static final String BANNER = "\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n";
    private static final Key<Document> CLS_DOCUMENT_LINK_KEY = Key.create("cls.document.link");
    private final Object myMirrorLock;
    private final Object myStubLock;
    private final FileViewProvider myViewProvider;
    private final boolean myIsForDecompiling;
    private volatile SoftReference<StubTree> myStub;
    private volatile Reference<TreeElement> myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private boolean myIsPhysical;
    private boolean myInvalidated;
    private static final InnerClassSourceStrategy<FileContentPair> STRATEGY = new InnerClassSourceStrategy<FileContentPair>(){

        @Override
        @Nullable
        public FileContentPair findInnerClass(String innerName, FileContentPair outerClass) {
            String baseName = ((VirtualFile)outerClass.first).getNameWithoutExtension();
            VirtualFile dir = ((VirtualFile)outerClass.first).getParent();
            assert (dir != null) : outerClass;
            VirtualFile innerClass = dir.findChild(baseName + '$' + innerName + ".class");
            if (innerClass != null) {
                try {
                    byte[] bytes = innerClass.contentsToByteArray(false);
                    return new FileContentPair(innerClass, bytes);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public void accept(FileContentPair innerClass, StubBuildingVisitor<FileContentPair> visitor) {
            new ClassReader((byte[])innerClass.second).accept(visitor, EMPTY_ATTRIBUTES, 4);
        }
    };
    public static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];

    public ClsFileImpl(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            ClsFileImpl.$$$reportNull$$$0(0);
        }
        this(viewProvider, false);
    }

    private ClsFileImpl(@NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        if (viewProvider == null) {
            ClsFileImpl.$$$reportNull$$$0(1);
        }
        super(null);
        this.myMirrorLock = new Object();
        this.myStubLock = new Object();
        this.myIsPhysical = true;
        this.myViewProvider = viewProvider;
        this.myIsForDecompiling = forDecompiling;
        JavaElementType.CLASS.getIndex();
    }

    @Override
    public PsiManager getManager() {
        return this.myViewProvider.getManager();
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        if (virtualFile == null) {
            ClsFileImpl.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return !this.myInvalidated && (this.myIsForDecompiling || this.getVirtualFile().isValid());
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    boolean isForDecompiling() {
        return this.myIsForDecompiling;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getVirtualFile().getName();
        if (string == null) {
            ClsFileImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        PsiJavaModule module = this.getModuleDeclaration();
        if (module != null) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = module;
        } else {
            psiElementArray = this.getClasses();
        }
        if (psiElementArray == null) {
            ClsFileImpl.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getStub().getClasses();
        if (psiClassArray == null) {
            ClsFileImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ClsPackageStatementImpl statement = this.myPackageStatement;
        if (statement == null) {
            String packageName;
            statement = ClsPackageStatementImpl.NULL_PACKAGE;
            StubElement stub = this.getStub();
            if (!(stub instanceof PsiJavaFileStub && stub.findChildStubByType(JavaStubElementTypes.MODULE) != null || (packageName = ClsFileImpl.findPackageName(stub)) == null)) {
                statement = new ClsPackageStatementImpl(this, packageName);
            }
            this.myPackageStatement = statement;
        }
        return statement != ClsPackageStatementImpl.NULL_PACKAGE ? statement : null;
    }

    private static String findPackageName(PsiClassHolderFileStub<?> stub) {
        String packageName = null;
        if (stub instanceof PsiJavaFileStub) {
            packageName = ((PsiJavaFileStub)stub).getPackageName();
        } else {
            int index;
            String className;
            PsiClass[] psiClasses = stub.getClasses();
            if (psiClasses.length > 0 && (className = psiClasses[0].getQualifiedName()) != null && (index = className.lastIndexOf(46)) >= 0) {
                packageName = className.substring(0, index);
            }
        }
        return !StringUtil.isEmpty(packageName) ? packageName : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement = this.getPackageStatement();
        String string = statement == null ? "" : statement.getPackageName();
        if (string == null) {
            ClsFileImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    @Override
    public PsiImportList getImportList() {
        return null;
    }

    @Override
    public boolean importClass(PsiClass aClass) {
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(7);
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        if (PsiClass.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(8);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(9);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(10);
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        return null;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        StubElement stub = this.getStub();
        if (stub instanceof PsiJavaFileStub && (level = ((PsiJavaFileStub)stub).getLanguageLevel()) != null) {
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                ClsFileImpl.$$$reportNull$$$0(11);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            ClsFileImpl.$$$reportNull$$$0(12);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        StubElement stub = this.getStub();
        return stub instanceof PsiJavaFileStub ? ((PsiJavaFileStub)stub).getModule() : null;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            ClsFileImpl.$$$reportNull$$$0(13);
        }
        throw ClsFileImpl.cannotModifyException(this);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        throw ClsFileImpl.cannotModifyException(this);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsFileImpl.$$$reportNull$$$0(14);
        }
        buffer.append(BANNER);
        PsiJavaModule module = this.getModuleDeclaration();
        if (module != null) {
            ClsFileImpl.appendText(module, 0, buffer);
        } else {
            ClsFileImpl.appendText(this.getPackageStatement(), 0, buffer, "\n\n");
            PsiClass[] classes = this.getClasses();
            if (classes.length > 0) {
                ClsFileImpl.appendText(classes[0], 0, buffer);
            }
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        Object mirrorElement;
        if (element == null) {
            ClsFileImpl.$$$reportNull$$$0(15);
        }
        if (!((mirrorElement = SourceTreeToPsiMap.treeToPsiNotNull(element)) instanceof PsiJavaFile)) {
            throw new ClsElementImpl.InvalidMirrorException("Unexpected mirror file: " + mirrorElement);
        }
        PsiJavaFile mirrorFile = (PsiJavaFile)mirrorElement;
        PsiJavaModule module = this.getModuleDeclaration();
        if (module != null) {
            ClsFileImpl.setMirror(module, mirrorFile.getModuleDeclaration());
        } else {
            ClsFileImpl.setMirrorIfPresent(this.getPackageStatement(), mirrorFile.getPackageStatement());
            ClsFileImpl.setMirrors((PsiElement[])this.getClasses(), (PsiElement[])mirrorFile.getClasses());
        }
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiFile psiFile;
            if (!(customNavigationPolicy instanceof ClsCustomNavigationPolicyEx)) continue;
            try {
                PsiFile navigationElement = ((ClsCustomNavigationPolicyEx)customNavigationPolicy).getFileNavigationElement(this);
                if (navigationElement == null) continue;
                psiFile = navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (psiFile == null) {
                ClsFileImpl.$$$reportNull$$$0(16);
            }
            return psiFile;
        }
        PsiElement psiElement = (PsiElement)CachedValuesManager.getCachedValue(this, () -> {
            PsiElement target = JavaPsiImplementationHelper.getInstance(this.getProject()).getClsFileNavigationElement(this);
            ModificationTracker tracker = FileIndexFacade.getInstance(this.getProject()).getRootModificationTracker();
            return CachedValueProvider.Result.create(target, this, target.getContainingFile(), tracker);
        });
        if (psiElement == null) {
            ClsFileImpl.$$$reportNull$$$0(17);
        }
        return psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiElement getMirror() {
        TreeElement mirrorTreeElement = SoftReference.dereference(this.myMirrorFileElement);
        if (mirrorTreeElement == null) {
            Object object = this.myMirrorLock;
            synchronized (object) {
                mirrorTreeElement = SoftReference.dereference(this.myMirrorFileElement);
                if (mirrorTreeElement == null) {
                    VirtualFile file = this.getVirtualFile();
                    PsiClass[] classes = this.getClasses();
                    String fileName = (classes.length > 0 ? classes[0].getName() : file.getNameWithoutExtension()) + ".java";
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    assert (document != null) : file.getUrl();
                    CharSequence mirrorText = document.getImmutableCharSequence();
                    boolean internalDecompiler = StringUtil.startsWith(mirrorText, BANNER);
                    PsiFileFactory factory = PsiFileFactory.getInstance(this.getManager().getProject());
                    PsiFile mirror = factory.createFileFromText(fileName, JavaLanguage.INSTANCE, mirrorText, false, false);
                    mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, this.getLanguageLevel());
                    mirrorTreeElement = SourceTreeToPsiMap.psiToTreeNotNull(mirror);
                    try {
                        TreeElement finalMirrorTreeElement = mirrorTreeElement;
                        ProgressManager.getInstance().executeNonCancelableSection(() -> {
                            this.setMirror(finalMirrorTreeElement);
                            this.putUserData(CLS_DOCUMENT_LINK_KEY, document);
                        });
                    }
                    catch (ClsElementImpl.InvalidMirrorException e) {
                        LOG.error(file.getUrl(), internalDecompiler ? e : ClsFileImpl.wrapException(e, file));
                    }
                    ((PsiFileImpl)mirror).setOriginalFile(this);
                    this.myMirrorFileElement = new SoftReference<TreeElement>(mirrorTreeElement);
                }
            }
        }
        return mirrorTreeElement.getPsi();
    }

    @Override
    public String getText() {
        VirtualFile file = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        assert (document != null) : file.getUrl();
        return document.getText();
    }

    @Override
    public int getTextLength() {
        VirtualFile file = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        assert (document != null) : file.getUrl();
        return document.getTextLength();
    }

    private static Exception wrapException(ClsElementImpl.InvalidMirrorException e, VirtualFile file) {
        PluginId pluginId;
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file);
        if (decompiler instanceof ClassFileDecompilers.Light && (pluginId = PluginManagerCore.getPluginByClassName(decompiler.getClass().getName())) != null) {
            return new PluginException(e, pluginId);
        }
        return e;
    }

    @Override
    public PsiFile getDecompiledPsiFile() {
        return (PsiFile)this.getMirror();
    }

    @Override
    public long getModificationStamp() {
        return this.getVirtualFile().getModificationStamp();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ClsFileImpl.$$$reportNull$$$0(18);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile(this);
        } else {
            visitor.visitFile(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiFile:" + this.getName();
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        ClsFileImpl clsFileImpl = this;
        if (clsFileImpl == null) {
            ClsFileImpl.$$$reportNull$$$0(19);
        }
        return clsFileImpl;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        if (javaClassFileType == null) {
            ClsFileImpl.$$$reportNull$$$0(20);
        }
        return javaClassFileType;
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            ClsFileImpl.$$$reportNull$$$0(21);
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            ClsFileImpl.$$$reportNull$$$0(22);
        }
        return fileViewProvider;
    }

    @Override
    public void subtreeChanged() {
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    @NotNull
    public PsiClassHolderFileStub<?> getStub() {
        PsiClassHolderFileStub psiClassHolderFileStub = (PsiClassHolderFileStub)this.getStubTree().getRoot();
        if (psiClassHolderFileStub == null) {
            ClsFileImpl.$$$reportNull$$$0(23);
        }
        return psiClassHolderFileStub;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            ClsFileImpl.$$$reportNull$$$0(24);
        }
        if (state == null) {
            ClsFileImpl.$$$reportNull$$$0(25);
        }
        if (place == null) {
            ClsFileImpl.$$$reportNull$$$0(26);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = this.getClasses()) {
                if (processor.execute(aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            StubTree stubTree2 = stubTree;
            if (stubTree2 == null) {
                ClsFileImpl.$$$reportNull$$$0(27);
            }
            return stubTree2;
        }
        StubTree newStubTree = (StubTree)StubTreeLoader.getInstance().readOrBuild(this.getProject(), this.getVirtualFile(), this);
        if (newStubTree == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No stub for class file in index: " + this.getVirtualFile().getPresentableUrl());
            }
            newStubTree = new StubTree(new PsiJavaFileStubImpl("corrupted_class_files", true));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            stubTree = SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                StubTree stubTree3 = stubTree;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                if (stubTree3 == null) {
                    ClsFileImpl.$$$reportNull$$$0(28);
                }
                return stubTree3;
            }
            stubTree = newStubTree;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stubTree.getRoot();
            fileStub.setPsi(this);
            this.myStub = new SoftReference<StubTree>(stubTree);
        }
        StubTree stubTree4 = stubTree;
        if (stubTree4 == null) {
            ClsFileImpl.$$$reportNull$$$0(29);
        }
        return stubTree4;
    }

    @Override
    @NotNull
    public StubbedSpine getStubbedSpine() {
        StubbedSpine stubbedSpine = this.getStubTree().getSpine();
        if (stubbedSpine == null) {
            ClsFileImpl.$$$reportNull$$$0(30);
        }
        return stubbedSpine;
    }

    @Override
    public boolean isContentsLoaded() {
        return this.myStub != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object = this.myStubLock;
        synchronized (object) {
            StubTree stubTree = SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).clearPsi("cls onContentReload");
            }
        }
        object = this.myMirrorLock;
        synchronized (object) {
            this.putUserData(CLS_DOCUMENT_LINK_KEY, null);
            this.myMirrorFileElement = null;
            this.myPackageStatement = null;
        }
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
        DebugUtil.onInvalidated(this);
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            ClsFileImpl.$$$reportNull$$$0(31);
        }
        PsiFileImpl.putInfo(this, info);
    }

    @Override
    public FileASTNode getNode() {
        return null;
    }

    @Override
    public boolean isPhysical() {
        return this.myIsPhysical;
    }

    public void setPhysical(boolean isPhysical) {
        this.myIsPhysical = isPhysical;
    }

    @NotNull
    public static CharSequence decompile(@NotNull VirtualFile file) {
        if (file == null) {
            ClsFileImpl.$$$reportNull$$$0(32);
        }
        PsiManager manager = PsiManager.getInstance(DefaultProjectFactory.getInstance().getDefaultProject());
        ClsFileImpl clsFile = new ClsFileImpl(new ClassFileViewProvider(manager, file), true);
        StringBuilder buffer = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(() -> clsFile.appendMirrorText(0, buffer));
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            ClsFileImpl.$$$reportNull$$$0(33);
        }
        return stringBuilder;
    }

    @Nullable
    public static PsiJavaFileStub buildFileStub(@NotNull VirtualFile file, @NotNull byte[] bytes) throws ClsFormatException {
        if (file == null) {
            ClsFileImpl.$$$reportNull$$$0(34);
        }
        if (bytes == null) {
            ClsFileImpl.$$$reportNull$$$0(35);
        }
        try {
            block11: {
                LanguageLevel level;
                if (ClassFileViewProvider.isInnerClass(file, bytes)) {
                    return null;
                }
                ClassReader reader = new ClassReader(bytes);
                String className = file.getNameWithoutExtension();
                String internalName = reader.getClassName();
                boolean module = internalName.equals("module-info") && BitUtil.isSet(reader.getAccess(), 32768);
                JavaSdkVersion jdkVersion = ClsParsingUtil.getJdkVersionByBytecode(reader.readShort(6));
                LanguageLevel languageLevel = level = jdkVersion != null ? jdkVersion.getMaxLanguageLevel() : null;
                if (module) {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, "", level, true);
                    ModuleStubBuildingVisitor visitor = new ModuleStubBuildingVisitor(stub);
                    reader.accept((ClassVisitor)visitor, EMPTY_ATTRIBUTES, 4);
                    if (visitor.getResult() != null) {
                        return stub;
                    }
                } else {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, ClsFileImpl.getPackageName(internalName), level, true);
                    try {
                        FileContentPair source = new FileContentPair(file, bytes);
                        StubBuildingVisitor<FileContentPair> visitor = new StubBuildingVisitor<FileContentPair>(source, STRATEGY, stub, 0, className);
                        reader.accept(visitor, EMPTY_ATTRIBUTES, 4);
                        if (visitor.getResult() != null) {
                            return stub;
                        }
                    }
                    catch (OutOfOrderInnerClassException e) {
                        if (!LOG.isTraceEnabled()) break block11;
                        LOG.trace(file.getPath());
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new ClsFormatException(file.getPath() + ": " + e.getMessage(), e);
        }
    }

    private static String getPackageName(String internalName) {
        int p = internalName.lastIndexOf(47);
        return p > 0 ? internalName.substring(0, p).replace('/', '.') : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsFileImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDemandImports";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleClassImports";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackageReferences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiRoots";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubTree";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "decompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "decompile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildFileStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FileContentPair
    extends Pair<VirtualFile, byte[]> {
        public FileContentPair(@NotNull VirtualFile file, @NotNull byte[] content) {
            if (file == null) {
                FileContentPair.$$$reportNull$$$0(0);
            }
            if (content == null) {
                FileContentPair.$$$reportNull$$$0(1);
            }
            super(file, content);
        }

        @NotNull
        public byte[] getContent() {
            byte[] byArray = (byte[])this.second;
            if (byArray == null) {
                FileContentPair.$$$reportNull$$$0(2);
            }
            return byArray;
        }

        @Override
        public String toString() {
            return ((VirtualFile)this.first).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/compiled/ClsFileImpl$FileContentPair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/compiled/ClsFileImpl$FileContentPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

