/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public final class DocumentUtil {
    private DocumentUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeInBulk(@NotNull Document document, boolean executeInBulk, @NotNull Runnable task) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(0);
        }
        if (task == null) {
            DocumentUtil.$$$reportNull$$$0(1);
        }
        if (!(document instanceof DocumentEx)) {
            task.run();
            return;
        }
        DocumentEx documentEx = (DocumentEx)document;
        if (executeInBulk == documentEx.isInBulkUpdate()) {
            task.run();
            return;
        }
        documentEx.setInBulkUpdate(executeInBulk);
        try {
            task.run();
            documentEx.setInBulkUpdate(!executeInBulk);
        }
        catch (Throwable throwable) {
            documentEx.setInBulkUpdate(!executeInBulk);
            throw throwable;
        }
    }

    public static void writeInRunUndoTransparentAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            DocumentUtil.$$$reportNull$$$0(2);
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            if (runnable == null) {
                DocumentUtil.$$$reportNull$$$0(17);
            }
            ApplicationManager.getApplication().runWriteAction(runnable);
        });
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int line) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(3);
        }
        int startOffset = document.getLineStartOffset(line);
        int endOffset = document.getLineEndOffset(line);
        return DocumentUtil.getFirstNonSpaceCharOffset(document, startOffset, endOffset);
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(4);
        }
        CharSequence text = document.getImmutableCharSequence();
        for (int i = startOffset; i < endOffset; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return startOffset;
    }

    public static boolean isValidOffset(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(5);
        }
        return offset >= 0 && offset <= document.getTextLength();
    }

    public static int getLineStartOffset(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(6);
        }
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineStartOffset(lineNumber);
    }

    public static int getLineEndOffset(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(7);
        }
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    @NotNull
    public static TextRange getLineTextRange(@NotNull Document document, int line) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(8);
        }
        TextRange textRange = TextRange.create(document.getLineStartOffset(line), document.getLineEndOffset(line));
        if (textRange == null) {
            DocumentUtil.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    public static boolean isAtLineStart(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(10);
        }
        return offset >= 0 && offset <= document.getTextLength() && offset == document.getLineStartOffset(document.getLineNumber(offset));
    }

    public static boolean isAtLineEnd(int offset, @NotNull Document document) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(11);
        }
        return offset >= 0 && offset <= document.getTextLength() && offset == document.getLineEndOffset(document.getLineNumber(offset));
    }

    public static int alignToCodePointBoundary(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(12);
        }
        return DocumentUtil.isInsideSurrogatePair(document, offset) ? offset - 1 : offset;
    }

    public static boolean isSurrogatePair(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(13);
        }
        CharSequence text = document.getImmutableCharSequence();
        if (offset < 0 || offset + 1 >= text.length()) {
            return false;
        }
        return Character.isSurrogatePair(text.charAt(offset), text.charAt(offset + 1));
    }

    public static boolean isInsideSurrogatePair(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(14);
        }
        return DocumentUtil.isSurrogatePair(document, offset - 1);
    }

    public static int getPreviousCodePointOffset(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(15);
        }
        return offset - (DocumentUtil.isSurrogatePair(document, offset - 2) ? 2 : 1);
    }

    public static int getNextCodePointOffset(@NotNull Document document, int offset) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(16);
        }
        return offset + (DocumentUtil.isSurrogatePair(document, offset) ? 2 : 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/DocumentUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/DocumentUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeInBulk";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeInRunUndoTransparentAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNonSpaceCharOffset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLineStartOffset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLineEndOffset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLineTextRange";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineStart";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineEnd";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "alignToCodePointBoundary";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSurrogatePair";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSurrogatePair";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousCodePointOffset";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNextCodePointOffset";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$writeInRunUndoTransparentAction$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

