/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

abstract class ThreadLocalAnnotatorMap<K, V> {
    private volatile int version;
    private final ThreadLocal<VersionedMap<K, V>> CACHE = new ThreadLocal<VersionedMap<K, V>>(){

        @Override
        protected VersionedMap<K, V> initialValue() {
            return new VersionedMap(ThreadLocalAnnotatorMap.this.version);
        }
    };

    ThreadLocalAnnotatorMap() {
    }

    @NotNull
    public abstract Collection<V> initialValue(@NotNull K var1);

    @NotNull
    private List<V> cloneTemplates(@NotNull Collection<V> templates) {
        if (templates == null) {
            ThreadLocalAnnotatorMap.$$$reportNull$$$0(0);
        }
        ArrayList<Object> result2 = new ArrayList<Object>(templates.size());
        PicoContainer container = ApplicationManager.getApplication().getPicoContainer();
        for (V template : templates) {
            Class<?> aClass = template.getClass();
            Object clone = new CachingConstructorInjectionComponentAdapter(aClass.getName(), aClass).getComponentInstance(container);
            result2.add(clone);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            ThreadLocalAnnotatorMap.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public List<V> get(@NotNull K key) {
        List<V> cached;
        VersionedMap<K, V> map;
        if (key == null) {
            ThreadLocalAnnotatorMap.$$$reportNull$$$0(2);
        }
        if (this.version != ((VersionedMap)(map = this.CACHE.get())).version) {
            this.CACHE.remove();
            map = this.CACHE.get();
        }
        if ((cached = (List<V>)map.get(key)) == null) {
            Collection<V> templates = this.initialValue(key);
            cached = this.cloneTemplates(templates);
            map.put(key, cached);
        }
        List<V> list = cached;
        if (list == null) {
            ThreadLocalAnnotatorMap.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void clear() {
        ++this.version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneTemplates";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cloneTemplates";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VersionedMap<K, V>
    extends THashMap<K, List<V>> {
        private final int version;

        private VersionedMap(int version) {
            this.version = version;
        }
    }
}

