/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public abstract class CachedValuesManager {
    private static final NotNullLazyKey<CachedValuesManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(CachedValuesManager.class);
    private final ConcurrentMap<String, Key<CachedValue>> keyForProvider = ContainerUtil.newConcurrentMap();
    private static final ConcurrentMap<String, Key<CachedValue>> globalKeyForProvider = ContainerUtil.newConcurrentMap();

    public static CachedValuesManager getManager(@NotNull Project project) {
        if (project == null) {
            CachedValuesManager.$$$reportNull$$$0(0);
        }
        return INSTANCE_KEY.getValue(project);
    }

    @NotNull
    public abstract <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> var1, boolean var2);

    @NotNull
    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider) {
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(1);
        }
        CachedValue<T> cachedValue = this.createCachedValue(provider, true);
        if (cachedValue == null) {
            CachedValuesManager.$$$reportNull$$$0(2);
        }
        return cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, D extends UserDataHolder, P> T getParameterizedCachedValue(@NotNull D dataHolder, @NotNull Key<ParameterizedCachedValue<T, P>> key, @NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue, P parameter) {
        ParameterizedCachedValue<T, P> value;
        if (dataHolder == null) {
            CachedValuesManager.$$$reportNull$$$0(3);
        }
        if (key == null) {
            CachedValuesManager.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(5);
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = dh.getUserData(key);
            if (value == null) {
                value = this.createParameterizedCachedValue(provider, trackValue);
                value = dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = dataHolder.getUserData(key);
                if (value == null) {
                    value = this.createParameterizedCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, value);
                }
            }
        }
        return value.getValue(parameter);
    }

    public abstract <T, D extends UserDataHolder> T getCachedValue(@NotNull D var1, @NotNull Key<CachedValue<T>> var2, @NotNull CachedValueProvider<T> var3, boolean var4);

    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull CachedValueProvider<T> provider) {
        if (dataHolder == null) {
            CachedValuesManager.$$$reportNull$$$0(6);
        }
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(7);
        }
        return this.getCachedValue(dataHolder, this.getKeyForClass(provider.getClass()), provider, false);
    }

    public static <T> T getCachedValue(@NotNull PsiElement psi, @NotNull CachedValueProvider<T> provider) {
        if (psi == null) {
            CachedValuesManager.$$$reportNull$$$0(8);
        }
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(9);
        }
        return CachedValuesManager.getCachedValue(psi, CachedValuesManager.getKeyForClass(provider.getClass(), globalKeyForProvider), provider);
    }

    public static <T> T getCachedValue(@NotNull PsiElement psi, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider) {
        CachedValue<T> value;
        if (psi == null) {
            CachedValuesManager.$$$reportNull$$$0(10);
        }
        if (key == null) {
            CachedValuesManager.$$$reportNull$$$0(11);
        }
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(12);
        }
        if ((value = psi.getUserData(key)) != null) {
            return value.getValue();
        }
        return CachedValuesManager.getManager(psi.getProject()).getCachedValue(psi, key, () -> {
            PsiFile file;
            CachedValueProvider.Result result2;
            if (provider == null) {
                CachedValuesManager.$$$reportNull$$$0(17);
            }
            if (psi == null) {
                CachedValuesManager.$$$reportNull$$$0(18);
            }
            if ((result2 = provider.compute()) != null && !psi.isPhysical() && (file = psi.getContainingFile()) != null) {
                return CachedValueProvider.Result.create(result2.getValue(), ArrayUtil.append(result2.getDependencyItems(), file, ArrayUtil.OBJECT_ARRAY_FACTORY));
            }
            return result2;
        }, false);
    }

    @NotNull
    public <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass) {
        if (providerClass == null) {
            CachedValuesManager.$$$reportNull$$$0(13);
        }
        Key<CachedValue<T>> key = CachedValuesManager.getKeyForClass(providerClass, this.keyForProvider);
        if (key == null) {
            CachedValuesManager.$$$reportNull$$$0(14);
        }
        return key;
    }

    @NotNull
    private static <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass, ConcurrentMap<String, Key<CachedValue>> keyForProvider) {
        if (providerClass == null) {
            CachedValuesManager.$$$reportNull$$$0(15);
        }
        String name = providerClass.getName();
        assert (name != null) : providerClass + " doesn't have a name; can't be used for cache value provider";
        Key key = (Key)keyForProvider.get(name);
        if (key == null) {
            key = ConcurrencyUtil.cacheOrGet(keyForProvider, name, Key.create(name));
        }
        Key key2 = key;
        if (key2 == null) {
            CachedValuesManager.$$$reportNull$$$0(16);
        }
        return key2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/CachedValuesManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/CachedValuesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManager";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 2: 
            case 14: 
            case 16: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedCachedValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCachedValue$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

