/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.GroupDisplayNameUtil;
import com.siyeh.ig.InspectionGadgetsFix;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspection
extends AbstractBaseJavaLocalInspectionTool {
    private String m_shortName = null;

    @Override
    @NotNull
    public String getShortName() {
        if (this.m_shortName == null) {
            Class<?> aClass = this.getClass();
            String name = aClass.getSimpleName();
            this.m_shortName = InspectionProfileEntry.getShortName(name);
            if (this.m_shortName.equals(name)) {
                throw new AssertionError((Object)("class name must end with 'Inspection' to correctly calculate the short name: " + name));
            }
        }
        String string = this.m_shortName;
        if (string == null) {
            BaseInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public abstract String getDisplayName();

    @Override
    @Nls
    @NotNull
    public final String getGroupDisplayName() {
        String string = GroupDisplayNameUtil.getGroupDisplayName(this.getClass());
        if (string == null) {
            BaseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected abstract String buildErrorString(Object ... var1);

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return null;
    }

    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
            BaseInspection.$$$reportNull$$$0(2);
        }
        return InspectionGadgetsFix.EMPTY_ARRAY;
    }

    protected void writeBooleanOption(@NotNull Element node, @NotNull @NonNls String property2, boolean defaultValueToIgnore) {
        if (node == null) {
            BaseInspection.$$$reportNull$$$0(3);
        }
        if (property2 == null) {
            BaseInspection.$$$reportNull$$$0(4);
        }
        Boolean value = ReflectionUtil.getField(this.getClass(), this, Boolean.TYPE, property2);
        assert (value != null);
        if (defaultValueToIgnore == value) {
            return;
        }
        node.addContent(new Element("option").setAttribute("name", property2).setAttribute("value", value.toString()));
    }

    protected void defaultWriteSettings(@NotNull Element node, final String ... excludedProperties) throws WriteExternalException {
        if (node == null) {
            BaseInspection.$$$reportNull$$$0(5);
        }
        DefaultJDOMExternalizer.writeExternal(this, node, new DefaultJDOMExternalizer.JDOMFilter(){

            @Override
            public boolean isAccept(@NotNull Field field) {
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = field.getName();
                for (String property2 : excludedProperties) {
                    if (!name.equals(property2)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/BaseInspection$1", "isAccept"));
            }
        });
    }

    public abstract BaseInspectionVisitor buildVisitor();

    @Override
    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            BaseInspection.$$$reportNull$$$0(6);
        }
        PsiFile file = holder.getFile();
        assert (file.isPhysical());
        if (!this.shouldInspect(file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                BaseInspection.$$$reportNull$$$0(7);
            }
            return psiElementVisitor;
        }
        BaseInspectionVisitor visitor = this.buildVisitor();
        visitor.setProblemsHolder(holder);
        visitor.setOnTheFly(isOnTheFly);
        visitor.setInspection(this);
        BaseInspectionVisitor baseInspectionVisitor = visitor;
        if (baseInspectionVisitor == null) {
            BaseInspection.$$$reportNull$$$0(8);
        }
        return baseInspectionVisitor;
    }

    public boolean shouldInspect(PsiFile file) {
        return true;
    }

    protected JFormattedTextField prepareNumberEditor(final @NonNls String fieldName) {
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        final JFormattedTextField valueField = new JFormattedTextField(formatter);
        Object value = ReflectionUtil.getField(this.getClass(), this, null, fieldName);
        valueField.setValue(value);
        valueField.setColumns(2);
        valueField.setMinimumSize(valueField.getPreferredSize());
        UIUtil.fixFormattedField(valueField);
        Document document = valueField.getDocument();
        document.addDocumentListener(new DocumentAdapter(){

            @Override
            public void textChanged(DocumentEvent evt) {
                try {
                    valueField.commitEdit();
                    Number number = (Number)valueField.getValue();
                    ReflectionUtil.setField(BaseInspection.this.getClass(), BaseInspection.this, Integer.TYPE, fieldName, number.intValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        return valueField;
    }

    @SafeVarargs
    public static void parseString(String string, List<String> ... outs) {
        List<String> strings = StringUtil.split(string, ",");
        for (List<String> out : outs) {
            out.clear();
        }
        int iMax = strings.size();
        for (int i = 0; i < iMax; i += outs.length) {
            for (int j = 0; j < outs.length; ++j) {
                List<String> out;
                out = outs[j];
                if (i + j >= iMax) {
                    out.add("");
                    continue;
                }
                out.add(strings.get(i + j));
            }
        }
    }

    @SafeVarargs
    public static String formatString(List<String> ... strings) {
        StringBuilder buffer = new StringBuilder();
        int size = strings[0].size();
        if (size > 0) {
            BaseInspection.formatString(strings, 0, buffer);
            for (int i = 1; i < size; ++i) {
                buffer.append(',');
                BaseInspection.formatString(strings, i, buffer);
            }
        }
        return buffer.toString();
    }

    private static void formatString(List<String>[] strings, int index, StringBuilder out) {
        out.append(strings[0].get(index));
        for (int i = 1; i < strings.length; ++i) {
            out.append(',');
            out.append(strings[i].get(index));
        }
    }

    public static boolean isInspectionEnabled(@NonNls String shortName, PsiElement context) {
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(context.getProject());
        InspectionProfileImpl profile2 = profileManager.getCurrentProfile();
        return profile2.isToolEnabled(HighlightDisplayKey.find(shortName), context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/BaseInspection";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/BaseInspection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeBooleanOption";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "defaultWriteSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

