/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.NormalizeDeclarationFix;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MultipleTypedDeclarationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.typed.declaration.display.name", new Object[0]);
        if (string == null) {
            MultipleTypedDeclarationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("VariablesOfDifferentTypesInDeclaration" == null) {
            MultipleTypedDeclarationInspection.$$$reportNull$$$0(1);
        }
        return "VariablesOfDifferentTypesInDeclaration";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.typed.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            MultipleTypedDeclarationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultiplyTypedDeclarationVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new NormalizeDeclarationFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/MultipleTypedDeclarationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MultiplyTypedDeclarationVisitor
    extends BaseInspectionVisitor {
        private MultiplyTypedDeclarationVisitor() {
        }

        @Override
        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            super.visitDeclarationStatement(statement);
            PsiElement[] elements = statement.getDeclaredElements();
            if (elements.length > 1) {
                PsiLocalVariable var;
                int i;
                PsiType baseType = ((PsiVariable)elements[0]).getType();
                boolean hasMultipleTypes = false;
                for (i = 1; i < elements.length; ++i) {
                    var = (PsiLocalVariable)elements[i];
                    PsiType variableType = var.getType();
                    if (variableType.equals(baseType)) continue;
                    hasMultipleTypes = true;
                }
                if (hasMultipleTypes) {
                    for (i = 1; i < elements.length; ++i) {
                        var = (PsiLocalVariable)elements[i];
                        this.registerVariableError(var, new Object[0]);
                    }
                }
            }
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MultiplyTypedDeclarationVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!MultiplyTypedDeclarationVisitor.childrenContainTypeElement(field)) {
                return;
            }
            List<PsiField> fields = MultiplyTypedDeclarationVisitor.getSiblingFields(field);
            if (fields.size() > 1) {
                int i;
                PsiField firstField = fields.get(0);
                PsiType baseType = firstField.getType();
                boolean hasMultipleTypes = false;
                for (i = 1; i < fields.size(); ++i) {
                    PsiField variable = fields.get(i);
                    PsiType variableType = variable.getType();
                    if (variableType.equals(baseType)) continue;
                    hasMultipleTypes = true;
                }
                if (hasMultipleTypes) {
                    for (i = 1; i < fields.size(); ++i) {
                        PsiField var = fields.get(i);
                        this.registerVariableError(var, new Object[0]);
                    }
                }
            }
        }

        public static List<PsiField> getSiblingFields(PsiField field) {
            ArrayList<PsiField> out = new ArrayList<PsiField>(5);
            out.add(field);
            PsiField nextField = PsiTreeUtil.getNextSiblingOfType(field, PsiField.class);
            if (nextField != null) {
                PsiTypeElement nextTypeElement = nextField.getTypeElement();
                while (nextTypeElement != null && nextTypeElement.equals(field.getTypeElement())) {
                    out.add(nextField);
                    nextField = PsiTreeUtil.getNextSiblingOfType(nextField, PsiField.class);
                    if (nextField == null) break;
                    nextTypeElement = nextField.getTypeElement();
                }
            }
            return out;
        }

        public static boolean childrenContainTypeElement(PsiElement field) {
            PsiElement[] children;
            for (PsiElement aChildren : children = field.getChildren()) {
                if (!(aChildren instanceof PsiTypeElement)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/style/MultipleTypedDeclarationInspection$MultiplyTypedDeclarationVisitor", "visitField"));
        }
    }
}

