/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MethodThrowsFix
extends LocalQuickFixOnPsiElement {
    private static final Logger LOG = Logger.getInstance(MethodThrowsFix.class);
    private final String myThrowsCanonicalText;
    private final boolean myAddThrow;
    private final String myMethodName;

    public MethodThrowsFix(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean addThrow, boolean showClassName) {
        if (method == null) {
            MethodThrowsFix.$$$reportNull$$$0(0);
        }
        if (exceptionType == null) {
            MethodThrowsFix.$$$reportNull$$$0(1);
        }
        super(method);
        this.myThrowsCanonicalText = exceptionType.getCanonicalText();
        this.myAddThrow = addThrow;
        this.myMethodName = PsiFormatUtil.formatMethod(method, PsiSubstitutor.EMPTY, 1 | (showClassName ? 4096 : 0), 0);
    }

    @Override
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message(this.myAddThrow ? "fix.throws.list.add.exception" : "fix.throws.list.remove.exception", StringUtil.getShortName(this.myThrowsCanonicalText), this.myMethodName);
        if (string == null) {
            MethodThrowsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.throws.list.family", new Object[0]);
        if (string == null) {
            MethodThrowsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            MethodThrowsFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            MethodThrowsFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(7);
        }
        return !(((PsiMethod)startElement).getThrowsList() instanceof PsiCompiledElement);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            MethodThrowsFix.$$$reportNull$$$0(8);
        }
        if (file == null) {
            MethodThrowsFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(11);
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        PsiJavaCodeReferenceElement[] referenceElements = myMethod.getThrowsList().getReferenceElements();
        try {
            boolean alreadyThrows = false;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
                if (!referenceElement.getCanonicalText().equals(this.myThrowsCanonicalText)) continue;
                alreadyThrows = true;
                if (this.myAddThrow) continue;
                referenceElement.delete();
                break;
            }
            if (this.myAddThrow) {
                if (!alreadyThrows) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance(myMethod.getProject()).getElementFactory();
                    PsiClassType type = (PsiClassType)factory.createTypeFromText(this.myThrowsCanonicalText, myMethod);
                    PsiJavaCodeReferenceElement ref = factory.createReferenceElementByType(type);
                    ref = (PsiJavaCodeReferenceElement)JavaCodeStyleManager.getInstance(project).shortenClassReferences(ref);
                    myMethod.getThrowsList().add(ref);
                }
            } else {
                PsiDocComment comment = myMethod.getDocComment();
                if (comment != null) {
                    Arrays.stream(comment.getTags()).filter(tag -> "throws".equals(tag.getName())).filter(tag -> {
                        PsiClass tagValueClass = JavaDocUtil.resolveClassInTagValue(tag.getValueElement());
                        return tagValueClass != null && this.myThrowsCanonicalText.equals(tagValueClass.getQualifiedName());
                    }).forEach(tag -> tag.delete());
                }
            }
            UndoUtil.markPsiFileForUndo(file);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

