/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class NullabilityProblemKind<T extends PsiElement> {
    private final String myName;
    private final String myNullLiteralMessage;
    private final String myNormalMessage;
    public static final NullabilityProblemKind<PsiMethodCallExpression> callNPE = new NullabilityProblemKind("callNPE");
    public static final NullabilityProblemKind<PsiMethodReferenceExpression> callMethodRefNPE = new NullabilityProblemKind("callMethodRefNPE", "dataflow.message.npe.methodref.invocation");
    public static final NullabilityProblemKind<PsiNewExpression> innerClassNPE = new NullabilityProblemKind("innerClassNPE", "dataflow.message.npe.inner.class.construction");
    public static final NullabilityProblemKind<PsiExpression> fieldAccessNPE = new NullabilityProblemKind("fieldAccessNPE", "dataflow.message.npe.field.access.sure", "dataflow.message.npe.field.access");
    public static final NullabilityProblemKind<PsiArrayAccessExpression> arrayAccessNPE = new NullabilityProblemKind("arrayAccessNPE", "dataflow.message.npe.array.access");
    public static final NullabilityProblemKind<PsiElement> unboxingNullable = new NullabilityProblemKind("unboxingNullable", "dataflow.message.unboxing");
    public static final NullabilityProblemKind<PsiExpression> assigningToNotNull = new NullabilityProblemKind("assigningToNotNull", "dataflow.message.assigning.null", "dataflow.message.assigning.nullable");
    public static final NullabilityProblemKind<PsiExpression> storingToNotNullArray = new NullabilityProblemKind("storingToNotNullArray", "dataflow.message.storing.array.null", "dataflow.message.storing.array.nullable");
    public static final NullabilityProblemKind<PsiExpression> nullableReturn = new NullabilityProblemKind("nullableReturn");
    public static final NullabilityProblemKind<PsiExpression> nullableFunctionReturn = new NullabilityProblemKind("nullableFunctionReturn", "dataflow.message.return.nullable.from.notnull.function", "dataflow.message.return.nullable.from.notnull.function");
    public static final NullabilityProblemKind<PsiElement> passingNullableToNotNullParameter = new NullabilityProblemKind("passingNullableToNotNullParameter");
    public static final NullabilityProblemKind<PsiElement> passingNullableArgumentToNonAnnotatedParameter = new NullabilityProblemKind("passingNullableArgumentToNonAnnotatedParameter");
    public static final NullabilityProblemKind<PsiElement> assigningNullableValueToNonAnnotatedField = new NullabilityProblemKind("assigningNullableValueToNonAnnotatedField");
    public static final NullabilityProblemKind<PsiExpression> assumeNotNull = new NullabilityProblemKind("assumeNotNull");

    private NullabilityProblemKind(@NotNull String name) {
        if (name == null) {
            NullabilityProblemKind.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myNullLiteralMessage = null;
        this.myNormalMessage = null;
    }

    private NullabilityProblemKind(@NotNull String name, @NotNull @PropertyKey(resourceBundle="messages.InspectionsBundle") String message) {
        if (name == null) {
            NullabilityProblemKind.$$$reportNull$$$0(1);
        }
        if (message == null) {
            NullabilityProblemKind.$$$reportNull$$$0(2);
        }
        this(name, message, message);
    }

    private NullabilityProblemKind(@NotNull String name, @NotNull @PropertyKey(resourceBundle="messages.InspectionsBundle") String nullLiteralMessage, @NotNull @PropertyKey(resourceBundle="messages.InspectionsBundle") String normalMessage) {
        if (name == null) {
            NullabilityProblemKind.$$$reportNull$$$0(3);
        }
        if (nullLiteralMessage == null) {
            NullabilityProblemKind.$$$reportNull$$$0(4);
        }
        if (normalMessage == null) {
            NullabilityProblemKind.$$$reportNull$$$0(5);
        }
        this.myName = name;
        this.myNullLiteralMessage = InspectionsBundle.message(nullLiteralMessage, new Object[0]);
        this.myNormalMessage = InspectionsBundle.message(normalMessage, new Object[0]);
    }

    @Contract(value="null -> null; !null -> !null")
    public final NullabilityProblem<T> problem(@Nullable T anchor) {
        return anchor == null ? null : new NullabilityProblem<T>(this, anchor);
    }

    @Nullable
    public final NullabilityProblem<T> asMyProblem(NullabilityProblem<?> problem) {
        return problem != null && ((NullabilityProblem)problem).myKind == this ? problem : null;
    }

    public final boolean isMyProblem(@Nullable NullabilityProblem<?> problem) {
        return problem != null && ((NullabilityProblem)problem).myKind == this;
    }

    public void ifMyProblem(NullabilityProblem<?> problem, Consumer<T> consumer) {
        NullabilityProblem<T> myProblem = this.asMyProblem(problem);
        if (myProblem != null) {
            consumer.accept(myProblem.getAnchor());
        }
    }

    public String toString() {
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "nullLiteralMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "normalMessage";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class NullabilityProblem<T extends PsiElement> {
        @NotNull
        private final NullabilityProblemKind<T> myKind;
        @NotNull
        private final T myAnchor;

        NullabilityProblem(@NotNull NullabilityProblemKind<T> kind, @NotNull T anchor) {
            if (kind == null) {
                NullabilityProblem.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                NullabilityProblem.$$$reportNull$$$0(1);
            }
            this.myKind = kind;
            this.myAnchor = anchor;
        }

        @NotNull
        public T getAnchor() {
            T t = this.myAnchor;
            if (t == null) {
                NullabilityProblem.$$$reportNull$$$0(2);
            }
            return t;
        }

        @NotNull
        public String getMessage() {
            if (((NullabilityProblemKind)this.myKind).myNullLiteralMessage == null || ((NullabilityProblemKind)this.myKind).myNormalMessage == null) {
                throw new IllegalStateException("This problem kind has no message associated: " + this.myKind);
            }
            String string = this.myAnchor instanceof PsiExpression && ExpressionUtils.isNullLiteral((PsiExpression)this.myAnchor) ? ((NullabilityProblemKind)this.myKind).myNullLiteralMessage : ((NullabilityProblemKind)this.myKind).myNormalMessage;
            if (string == null) {
                NullabilityProblem.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NullabilityProblem)) {
                return false;
            }
            NullabilityProblem problem = (NullabilityProblem)o;
            return this.myKind.equals(problem.myKind) && this.myAnchor.equals(problem.myAnchor);
        }

        public int hashCode() {
            return Objects.hash(this.myKind, this.myAnchor);
        }

        public String toString() {
            return "[" + this.myKind + "] " + this.myAnchor.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind$NullabilityProblem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind$NullabilityProblem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnchor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

