/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolsImpl
implements Tools {
    @NonNls
    static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabled_by_default";
    @NonNls
    static final String ENABLED_ATTRIBUTE = "enabled";
    @NonNls
    static final String LEVEL_ATTRIBUTE = "level";
    private final String myShortName;
    private final ScopeToolState myDefaultState;
    private List<ScopeToolState> myTools;
    private boolean myEnabled;

    ToolsImpl(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel level, boolean enabled, boolean enabledByDefault) {
        if (toolWrapper == null) {
            ToolsImpl.$$$reportNull$$$0(0);
        }
        if (level == null) {
            ToolsImpl.$$$reportNull$$$0(1);
        }
        this.myShortName = toolWrapper.getShortName();
        this.myDefaultState = new ScopeToolState(CustomScopesProviderEx.getAllScope(), toolWrapper, enabledByDefault, level);
        this.myTools = null;
        this.myEnabled = enabled;
    }

    public ToolsImpl(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel level, boolean enabled) {
        if (toolWrapper == null) {
            ToolsImpl.$$$reportNull$$$0(2);
        }
        if (level == null) {
            ToolsImpl.$$$reportNull$$$0(3);
        }
        this(toolWrapper, level, enabled, enabled);
    }

    @NotNull
    public ScopeToolState addTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scope == null) {
            ToolsImpl.$$$reportNull$$$0(4);
        }
        if (toolWrapper == null) {
            ToolsImpl.$$$reportNull$$$0(5);
        }
        if (level == null) {
            ToolsImpl.$$$reportNull$$$0(6);
        }
        ScopeToolState scopeToolState = this.insertTool(scope, toolWrapper, enabled, level, this.myTools != null ? this.myTools.size() : 0);
        if (scopeToolState == null) {
            ToolsImpl.$$$reportNull$$$0(7);
        }
        return scopeToolState;
    }

    @NotNull
    public ScopeToolState prependTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scope == null) {
            ToolsImpl.$$$reportNull$$$0(8);
        }
        if (toolWrapper == null) {
            ToolsImpl.$$$reportNull$$$0(9);
        }
        if (level == null) {
            ToolsImpl.$$$reportNull$$$0(10);
        }
        ScopeToolState scopeToolState = this.insertTool(scope, toolWrapper, enabled, level, 0);
        if (scopeToolState == null) {
            ToolsImpl.$$$reportNull$$$0(11);
        }
        return scopeToolState;
    }

    public ScopeToolState addTool(@NotNull String scopeName, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scopeName == null) {
            ToolsImpl.$$$reportNull$$$0(12);
        }
        if (toolWrapper == null) {
            ToolsImpl.$$$reportNull$$$0(13);
        }
        if (level == null) {
            ToolsImpl.$$$reportNull$$$0(14);
        }
        return this.insertTool(new ScopeToolState(scopeName, toolWrapper, enabled, level), this.myTools != null ? this.myTools.size() : 0);
    }

    @NotNull
    private ScopeToolState insertTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level, int idx) {
        if (scope == null) {
            ToolsImpl.$$$reportNull$$$0(15);
        }
        if (toolWrapper == null) {
            ToolsImpl.$$$reportNull$$$0(16);
        }
        if (level == null) {
            ToolsImpl.$$$reportNull$$$0(17);
        }
        ScopeToolState scopeToolState = this.insertTool(new ScopeToolState(scope, toolWrapper, enabled, level), idx);
        if (scopeToolState == null) {
            ToolsImpl.$$$reportNull$$$0(18);
        }
        return scopeToolState;
    }

    @NotNull
    private ScopeToolState insertTool(@NotNull ScopeToolState scopeToolState, int idx) {
        if (scopeToolState == null) {
            ToolsImpl.$$$reportNull$$$0(19);
        }
        if (this.myTools == null) {
            this.myTools = new ArrayList<ScopeToolState>();
            if (scopeToolState.isEnabled()) {
                this.setEnabled(true);
            }
        }
        this.myTools.add(idx, scopeToolState);
        ScopeToolState scopeToolState2 = scopeToolState;
        if (scopeToolState2 == null) {
            ToolsImpl.$$$reportNull$$$0(20);
        }
        return scopeToolState2;
    }

    @Override
    @NotNull
    public InspectionToolWrapper getInspectionTool(@Nullable PsiElement element) {
        if (this.myTools != null) {
            Project project = element == null ? null : element.getProject();
            PsiFile containingFile = element == null ? null : InjectedLanguageManager.getInstance(project).getTopLevelFile(element);
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                if (element == null) {
                    InspectionToolWrapper inspectionToolWrapper = state.getTool();
                    if (inspectionToolWrapper == null) {
                        ToolsImpl.$$$reportNull$$$0(21);
                    }
                    return inspectionToolWrapper;
                }
                NamedScope scope = state.getScope(project);
                if (scope == null || (packageSet = scope.getValue()) == null || containingFile == null || !packageSet.contains(containingFile, DependencyValidationManager.getInstance(project))) continue;
                InspectionToolWrapper inspectionToolWrapper = state.getTool();
                if (inspectionToolWrapper == null) {
                    ToolsImpl.$$$reportNull$$$0(22);
                }
                return inspectionToolWrapper;
            }
        }
        InspectionToolWrapper inspectionToolWrapper = this.myDefaultState.getTool();
        if (inspectionToolWrapper == null) {
            ToolsImpl.$$$reportNull$$$0(23);
        }
        return inspectionToolWrapper;
    }

    @Override
    @NotNull
    public String getShortName() {
        String string = this.myShortName;
        if (string == null) {
            ToolsImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    public void cleanupTools(@NotNull Project project) {
        if (project == null) {
            ToolsImpl.$$$reportNull$$$0(25);
        }
        for (ScopeToolState state : this.getTools()) {
            state.getTool().cleanup(project);
        }
    }

    public void scopesChanged() {
        if (this.myTools != null) {
            for (ScopeToolState tool : this.myTools) {
                tool.scopesChanged();
            }
        }
        this.myDefaultState.scopesChanged();
    }

    public void writeExternal(@NotNull Element inspectionElement) {
        if (inspectionElement == null) {
            ToolsImpl.$$$reportNull$$$0(26);
        }
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                Element scopeElement = new Element("scope");
                scopeElement.setAttribute("name", state.getScopeName());
                scopeElement.setAttribute(LEVEL_ATTRIBUTE, state.getLevel().getName());
                scopeElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(state.isEnabled()));
                InspectionToolWrapper toolWrapper = state.getTool();
                if (toolWrapper.isInitialized()) {
                    ((InspectionProfileEntry)toolWrapper.getTool()).writeSettings(scopeElement);
                }
                inspectionElement.addContent(scopeElement);
            }
        }
        inspectionElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(this.isEnabled()));
        inspectionElement.setAttribute(LEVEL_ATTRIBUTE, this.getLevel().getName());
        inspectionElement.setAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE, Boolean.toString(this.myDefaultState.isEnabled()));
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        if (toolWrapper.isInitialized()) {
            ((InspectionProfileEntry)toolWrapper.getTool()).writeSettings(inspectionElement);
        }
    }

    void readExternal(@NotNull Element toolElement, @NotNull InspectionProfileManager profileManager, Map<String, List<String>> dependencies) {
        HighlightDisplayLevel level;
        if (toolElement == null) {
            ToolsImpl.$$$reportNull$$$0(27);
        }
        if (profileManager == null) {
            ToolsImpl.$$$reportNull$$$0(28);
        }
        String levelName = toolElement.getAttributeValue(LEVEL_ATTRIBUTE);
        SeverityRegistrar registrar = profileManager.getOwnSeverityRegistrar();
        HighlightDisplayLevel highlightDisplayLevel = level = levelName != null ? HighlightDisplayLevel.find(registrar.getSeverity(levelName)) : null;
        if (level == null) {
            level = HighlightDisplayLevel.WARNING;
        }
        this.myDefaultState.setLevel(level);
        String enabled = toolElement.getAttributeValue(ENABLED_ATTRIBUTE);
        boolean isEnabled = Boolean.parseBoolean(enabled);
        String enabledTool = toolElement.getAttributeValue(ENABLED_BY_DEFAULT_ATTRIBUTE);
        this.myDefaultState.setEnabled(enabledTool != null ? Boolean.parseBoolean(enabledTool) : isEnabled);
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        List scopeElements = toolElement.getChildren("scope");
        if (!scopeElements.isEmpty()) {
            SmartList<String> scopeNames = new SmartList<String>();
            for (Element scopeElement : scopeElements) {
                HighlightDisplayLevel scopeLevel;
                String scopeName = scopeElement.getAttributeValue("name");
                if (scopeName == null) continue;
                NamedScopesHolder scopesHolder = profileManager.getScopesManager();
                NamedScope namedScope = null;
                if (scopesHolder != null) {
                    namedScope = scopesHolder.getScope(scopeName);
                }
                String errorLevel = scopeElement.getAttributeValue(LEVEL_ATTRIBUTE);
                String enabledInScope = scopeElement.getAttributeValue(ENABLED_ATTRIBUTE);
                InspectionToolWrapper copyToolWrapper = toolWrapper.createCopy();
                if (scopeElement.getAttributes().size() > 3 || !scopeElement.getChildren().isEmpty()) {
                    ((InspectionProfileEntry)copyToolWrapper.getTool()).readSettings(scopeElement);
                }
                HighlightDisplayLevel highlightDisplayLevel2 = scopeLevel = errorLevel != null ? HighlightDisplayLevel.find(registrar.getSeverity(errorLevel)) : null;
                if (scopeLevel == null) {
                    scopeLevel = level;
                }
                if (namedScope != null) {
                    this.addTool(namedScope, copyToolWrapper, Boolean.parseBoolean(enabledInScope), scopeLevel);
                } else {
                    this.addTool(scopeName, copyToolWrapper, Boolean.parseBoolean(enabledInScope), scopeLevel);
                }
                scopeNames.add(scopeName);
            }
            for (int i = 0; i < scopeNames.size(); ++i) {
                String scopeName = (String)scopeNames.get(i);
                List order = dependencies.computeIfAbsent(scopeName, __ -> new ArrayList());
                for (int j = i + 1; j < scopeNames.size(); ++j) {
                    order.add(scopeNames.get(j));
                }
            }
        }
        if (toolElement.getAttributes().size() > 4 || toolElement.getChildren().size() > scopeElements.size()) {
            ((InspectionProfileEntry)toolWrapper.getTool()).readSettings(toolElement);
        }
        this.myEnabled = isEnabled;
    }

    @Override
    @NotNull
    public InspectionToolWrapper getTool() {
        if (this.myTools == null) {
            InspectionToolWrapper inspectionToolWrapper = this.myDefaultState.getTool();
            if (inspectionToolWrapper == null) {
                ToolsImpl.$$$reportNull$$$0(29);
            }
            return inspectionToolWrapper;
        }
        InspectionToolWrapper inspectionToolWrapper = this.myTools.iterator().next().getTool();
        if (inspectionToolWrapper == null) {
            ToolsImpl.$$$reportNull$$$0(30);
        }
        return inspectionToolWrapper;
    }

    @Override
    @NotNull
    public List<ScopeToolState> getTools() {
        if (this.myTools == null) {
            List<ScopeToolState> list = Collections.singletonList(this.myDefaultState);
            if (list == null) {
                ToolsImpl.$$$reportNull$$$0(31);
            }
            return list;
        }
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>(this.myTools);
        result2.add(this.myDefaultState);
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            ToolsImpl.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @Override
    public void collectTools(@NotNull List<ScopeToolState> result2) {
        if (result2 == null) {
            ToolsImpl.$$$reportNull$$$0(33);
        }
        if (this.myTools != null) {
            result2.addAll(this.myTools);
        }
        result2.add(this.myDefaultState);
    }

    @Override
    @NotNull
    public ScopeToolState getDefaultState() {
        ScopeToolState scopeToolState = this.myDefaultState;
        if (scopeToolState == null) {
            ToolsImpl.$$$reportNull$$$0(34);
        }
        return scopeToolState;
    }

    public void setDefaultEnabled(boolean isEnabled) {
        this.getDefaultState().setEnabled(isEnabled);
        if (isEnabled) {
            this.setEnabled(true);
        } else {
            this.disableWholeToolIfCan();
        }
    }

    public void removeScope(@NotNull String scopeName) {
        if (scopeName == null) {
            ToolsImpl.$$$reportNull$$$0(35);
        }
        if (this.myTools != null) {
            for (ScopeToolState tool : this.myTools) {
                if (!scopeName.equals(tool.getScopeName())) continue;
                this.myTools.remove(tool);
                break;
            }
            this.checkToolsIsEmpty();
        }
    }

    private void checkToolsIsEmpty() {
        if (this.myTools.isEmpty()) {
            this.myTools = null;
            this.setEnabled(this.myDefaultState.isEnabled());
        }
    }

    public void removeAllScopes() {
        this.myTools = null;
    }

    public void setScope(int idx, NamedScope namedScope) {
        if (this.myTools != null && this.myTools.size() > idx && idx >= 0) {
            ScopeToolState scopeToolState = this.myTools.get(idx);
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            this.myTools.remove(idx);
            this.myTools.add(idx, new ScopeToolState(namedScope, toolWrapper, scopeToolState.isEnabled(), scopeToolState.getLevel()));
        }
    }

    public boolean isEnabled(NamedScope namedScope, Project project) {
        if (!this.myEnabled) {
            return false;
        }
        if (namedScope != null && this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal(namedScope, state.getScope(project))) continue;
                return state.isEnabled();
            }
        }
        return this.myDefaultState.isEnabled();
    }

    public HighlightDisplayLevel getLevel(PsiElement element) {
        if (this.myTools == null || element == null) {
            return this.myDefaultState.getLevel();
        }
        Project project = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance(project);
        for (ScopeToolState state : this.myTools) {
            NamedScope scope = state.getScope(project);
            PackageSet set = scope != null ? scope.getValue() : null;
            if (set == null || !set.contains(element.getContainingFile(), manager)) continue;
            return state.getLevel();
        }
        return this.myDefaultState.getLevel();
    }

    public HighlightDisplayLevel getLevel() {
        return this.myDefaultState.getLevel();
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public boolean isEnabled(PsiElement element) {
        if (!this.myEnabled) {
            return false;
        }
        if (this.myTools == null || element == null) {
            return this.myDefaultState.isEnabled();
        }
        Project project = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance(project);
        for (ScopeToolState state : this.myTools) {
            PackageSet set;
            NamedScope scope = state.getScope(project);
            if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), manager)) continue;
            return state.isEnabled();
        }
        return this.myDefaultState.isEnabled();
    }

    @Override
    @Nullable
    public InspectionToolWrapper getEnabledTool(@Nullable PsiElement element, boolean includeDoNotShow) {
        if (!this.myEnabled) {
            return null;
        }
        if (this.myTools != null && element != null) {
            Project project = element.getProject();
            DependencyValidationManager manager = DependencyValidationManager.getInstance(project);
            for (ScopeToolState state : this.myTools) {
                PackageSet set;
                NamedScope scope = state.getScope(project);
                if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), manager)) continue;
                return state.isEnabled() && (includeDoNotShow || !HighlightDisplayLevel.DO_NOT_SHOW.equals(state.getLevel())) ? state.getTool() : null;
            }
        }
        return this.myDefaultState.isEnabled() && (includeDoNotShow || !HighlightDisplayLevel.DO_NOT_SHOW.equals(this.myDefaultState.getLevel())) ? this.myDefaultState.getTool() : null;
    }

    @Override
    @Nullable
    public InspectionToolWrapper getEnabledTool(@Nullable PsiElement element) {
        return this.getEnabledTool(element, true);
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void enableTool(@NotNull NamedScope namedScope, Project project) {
        if (namedScope == null) {
            ToolsImpl.$$$reportNull$$$0(36);
        }
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!namedScope.equals(state.getScope(project))) continue;
                state.setEnabled(true);
            }
        }
        this.setEnabled(true);
    }

    public void disableTool(NamedScope namedScope, Project project) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal(state.getScope(project), namedScope)) continue;
                state.setEnabled(false);
            }
            this.disableWholeToolIfCan();
        }
    }

    public void disableTool(@NotNull PsiElement element) {
        if (element == null) {
            ToolsImpl.$$$reportNull$$$0(37);
        }
        Project project = element.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance(project);
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                NamedScope scope = state.getScope(project);
                if (scope == null || (packageSet = scope.getValue()) == null) continue;
                PsiFile file = element.getContainingFile();
                if (file != null) {
                    if (!packageSet.contains(file, validationManager)) continue;
                    state.setEnabled(false);
                    return;
                }
                if (!(packageSet instanceof PackageSetBase) || !((PackageSetBase)packageSet).contains(PsiUtilCore.getVirtualFile(element), project, validationManager)) continue;
                state.setEnabled(false);
                return;
            }
            this.myDefaultState.setEnabled(false);
        } else {
            this.myDefaultState.setEnabled(false);
            this.setEnabled(false);
        }
    }

    @NotNull
    public HighlightDisplayLevel getLevel(NamedScope scope, Project project) {
        if (this.myTools != null && scope != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal(state.getScope(project), scope)) continue;
                HighlightDisplayLevel highlightDisplayLevel = state.getLevel();
                if (highlightDisplayLevel == null) {
                    ToolsImpl.$$$reportNull$$$0(38);
                }
                return highlightDisplayLevel;
            }
        }
        HighlightDisplayLevel highlightDisplayLevel = this.myDefaultState.getLevel();
        if (highlightDisplayLevel == null) {
            ToolsImpl.$$$reportNull$$$0(39);
        }
        return highlightDisplayLevel;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ToolsImpl)) {
            return false;
        }
        ToolsImpl tools = (ToolsImpl)o;
        if (this.myEnabled != tools.myEnabled) {
            return false;
        }
        if (this.getTools().size() != tools.getTools().size()) {
            return false;
        }
        for (int i = 0; i < this.getTools().size(); ++i) {
            ScopeToolState toolState;
            ScopeToolState state = this.getTools().get(i);
            if (state.equalTo(toolState = tools.getTools().get(i))) continue;
            return false;
        }
        return true;
    }

    public void setLevel(@NotNull HighlightDisplayLevel level, @Nullable String scopeName, Project project) {
        if (level == null) {
            ToolsImpl.$$$reportNull$$$0(40);
        }
        if (scopeName == null) {
            this.myDefaultState.setLevel(level);
        } else {
            if (this.myTools == null) {
                return;
            }
            ScopeToolState scopeToolState = null;
            int index = -1;
            for (int i = 0; i < this.myTools.size(); ++i) {
                ScopeToolState tool = this.myTools.get(i);
                if (!scopeName.equals(tool.getScopeName())) continue;
                scopeToolState = tool;
                this.myTools.remove(tool);
                index = i;
                break;
            }
            if (index < 0) {
                throw new IllegalStateException("Scope " + scopeName + " not found");
            }
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            NamedScope scope = scopeToolState.getScope(project);
            if (scope != null) {
                this.myTools.add(index, new ScopeToolState(scope, toolWrapper, scopeToolState.isEnabled(), level));
            } else {
                this.myTools.add(index, new ScopeToolState(scopeToolState.getScopeName(), toolWrapper, scopeToolState.isEnabled(), level));
            }
        }
    }

    public void setDefaultState(@NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (toolWrapper == null) {
            ToolsImpl.$$$reportNull$$$0(41);
        }
        if (level == null) {
            ToolsImpl.$$$reportNull$$$0(42);
        }
        this.myDefaultState.setTool(toolWrapper);
        this.myDefaultState.setLevel(level);
        this.myDefaultState.setEnabled(enabled);
    }

    public void setLevel(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            ToolsImpl.$$$reportNull$$$0(43);
        }
        this.myDefaultState.setLevel(level);
    }

    @Nullable
    public List<ScopeToolState> getNonDefaultTools() {
        return this.myTools;
    }

    private void disableWholeToolIfCan() {
        if (this.myDefaultState.isEnabled()) {
            return;
        }
        if (this.myTools != null) {
            for (ScopeToolState tool : this.myTools) {
                if (!tool.isEnabled()) continue;
                return;
            }
        }
        this.setEnabled(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = LEVEL_ATTRIBUTE;
                break;
            }
            case 4: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/ToolsImpl";
                break;
            }
            case 12: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeToolState";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionElement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolElement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileManager";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedScope";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/ToolsImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addTool";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "prependTool";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "insertTool";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTool";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTool";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTools";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTool";
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 39: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prependTool";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insertTool";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "cleanupTools";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectTools";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeScope";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "enableTool";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "disableTool";
                break;
            }
            case 40: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

