/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl.events;

import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlTagNameChanged;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;

public class XmlTagNameChangedImpl
implements XmlTagNameChanged {
    private final String myOldName;
    private final XmlTag myTag;

    public XmlTagNameChangedImpl(XmlTag tag, String oldName) {
        this.myOldName = oldName;
        this.myTag = tag;
    }

    @Override
    public String getOldName() {
        return this.myOldName;
    }

    @Override
    public XmlTag getTag() {
        return this.myTag;
    }

    public static PomModelEvent createXmlTagNameChanged(PomModel model, XmlTag tag, String oldName) {
        PomModelEvent event = new PomModelEvent(model);
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(model, PsiTreeUtil.getParentOfType((PsiElement)tag, XmlFile.class));
        xmlAspectChangeSet.add(new XmlTagNameChangedImpl(tag, oldName));
        event.registerChangeSet(model.getModelAspect(XmlAspect.class), xmlAspectChangeSet);
        return event;
    }

    public String toString() {
        return "tag name changed to " + this.getTag().getName() + " was: " + this.getOldName();
    }
}

