/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import org.jetbrains.annotations.NotNull;

public class PsiSearchRequest {
    @NotNull
    public final SearchScope searchScope;
    @NotNull
    public final String word;
    public final short searchContext;
    public final boolean caseSensitive;
    public final RequestResultProcessor processor;
    public final String containerName;

    public PsiSearchRequest(@NotNull SearchScope searchScope, @NotNull String word, short searchContext, boolean caseSensitive, @NotNull RequestResultProcessor processor) {
        if (searchScope == null) {
            PsiSearchRequest.$$$reportNull$$$0(0);
        }
        if (word == null) {
            PsiSearchRequest.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            PsiSearchRequest.$$$reportNull$$$0(2);
        }
        this(searchScope, word, searchContext, caseSensitive, null, processor);
    }

    public PsiSearchRequest(@NotNull SearchScope searchScope, @NotNull String word, short searchContext, boolean caseSensitive, String containerName, @NotNull RequestResultProcessor processor) {
        if (searchScope == null) {
            PsiSearchRequest.$$$reportNull$$$0(3);
        }
        if (word == null) {
            PsiSearchRequest.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            PsiSearchRequest.$$$reportNull$$$0(5);
        }
        this.containerName = containerName;
        if (word.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        this.searchScope = searchScope;
        this.word = word;
        this.searchContext = searchContext;
        this.caseSensitive = caseSensitive;
        this.processor = processor;
        if (searchScope instanceof GlobalSearchScope && ((GlobalSearchScope)searchScope).getProject() == null) {
            throw new AssertionError((Object)("Every search scope must be associated with a project: " + searchScope));
        }
    }

    public String toString() {
        return this.word + " -> " + this.processor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiSearchRequest)) {
            return false;
        }
        PsiSearchRequest that = (PsiSearchRequest)o;
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        if (this.searchContext != that.searchContext) {
            return false;
        }
        if (!this.processor.equals(that.processor)) {
            return false;
        }
        if (!this.searchScope.equals(that.searchScope)) {
            return false;
        }
        return this.word.equals(that.word);
    }

    public int hashCode() {
        int result2 = this.searchScope.hashCode();
        result2 = 31 * result2 + this.word.hashCode();
        result2 = 31 * result2 + this.searchContext;
        result2 = 31 * result2 + (this.caseSensitive ? 1 : 0);
        result2 = 31 * result2 + this.processor.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "searchScope";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "word";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/search/PsiSearchRequest";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

