/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SuspiciousArrayCastInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.array.cast.display.name", new Object[0]);
        if (string == null) {
            SuspiciousArrayCastInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("suspicious.array.cast.problem.descriptor", new Object[0]);
        if (string == null) {
            SuspiciousArrayCastInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousArrayCastVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/SuspiciousArrayCastInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SuspiciousArrayCastVisitor
    extends BaseInspectionVisitor {
        private SuspiciousArrayCastVisitor() {
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castType = typeElement.getType();
            if (!(castType instanceof PsiArrayType)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType type = operand.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            PsiClass castClass = PsiUtil.resolveClassInClassTypeOnly(castType.getDeepComponentType());
            if (castClass == null) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(type.getDeepComponentType());
            if (aClass == null || !castClass.isInheritor(aClass, true) || SuspiciousArrayCastVisitor.isCollectionToArrayCall(operand)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        private static boolean isCollectionToArrayCall(PsiExpression expression) {
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressionCount() != 1) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if (!"toArray".equals(methodExpression.getReferenceName())) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor(containingClass, "java.util.Collection");
        }
    }
}

