/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.GridBag;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ConstructorCountInspection
extends ClassMetricInspection {
    private static final int CONSTRUCTOR_COUNT_LIMIT = 5;
    public boolean ignoreDeprecatedConstructors = false;

    @Override
    @NotNull
    public String getID() {
        if ("ClassWithTooManyConstructors" == null) {
            ConstructorCountInspection.$$$reportNull$$$0(0);
        }
        return "ClassWithTooManyConstructors";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.many.constructors.display.name", new Object[0]);
        if (string == null) {
            ConstructorCountInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("too.many.constructors.count.limit.option", new Object[0]);
    }

    @Override
    public JComponent createOptionsPanel() {
        JLabel label = new JLabel(this.getConfigurationLabel());
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        CheckBox includeCheckBox = new CheckBox(InspectionGadgetsBundle.message("too.many.constructors.ignore.deprecated.option", new Object[0]), this, "ignoreDeprecatedConstructors");
        GridBag bag = new GridBag();
        bag.setDefaultInsets(0, 0, 0, 10);
        bag.setDefaultAnchor(17);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, bag.nextLine().next());
        panel.add((Component)valueField, bag.next().weightx(1.0));
        panel.add((Component)includeCheckBox, bag.nextLine().next().coverLine().weighty(1.0).anchor(18));
        return panel;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("too.many.constructors.problem.descriptor", count);
        if (string == null) {
            ConstructorCountInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstructorCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/ConstructorCountInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ConstructorCountVisitor
    extends BaseInspectionVisitor {
        private ConstructorCountVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            int constructorCount;
            if (aClass == null) {
                ConstructorCountVisitor.$$$reportNull$$$0(0);
            }
            if ((constructorCount = this.calculateTotalConstructorCount(aClass)) <= ConstructorCountInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, constructorCount);
        }

        private int calculateTotalConstructorCount(PsiClass aClass) {
            PsiMethod[] constructors = aClass.getConstructors();
            if (!ConstructorCountInspection.this.ignoreDeprecatedConstructors) {
                return constructors.length;
            }
            int count = 0;
            for (PsiMethod constructor : constructors) {
                if (constructor.isDeprecated()) continue;
                ++count;
            }
            return count;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ConstructorCountInspection$ConstructorCountVisitor", "visitClass"));
        }
    }
}

