/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.MakePublicStaticFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitRuleInspection
extends BaseInspection {
    public static final String RULE_FQN = "org.junit.Rule";
    public static final String CLASS_RULE_FQN = "org.junit.ClassRule";
    public boolean REPORT_RULE_PROBLEMS = true;
    public boolean REPORT_CLASS_RULE_PROBLEMS = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit.rule.display.name", new Object[0]);
        if (string == null) {
            JUnitRuleInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox("Report @Rule problems", "REPORT_RULE_PROBLEMS");
        panel.addCheckbox("Report @ClassRule problems", "REPORT_CLASS_RULE_PROBLEMS");
        return panel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            JUnitRuleInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return infos.length > 1 ? new MakePublicStaticFix((String)infos[1], infos[2].equals(CLASS_RULE_FQN)) : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitField(PsiField field) {
                boolean classRuleAnnotated;
                boolean ruleAnnotated = JUnitRuleInspection.this.REPORT_RULE_PROBLEMS && AnnotationUtil.isAnnotated((PsiModifierListOwner)field, JUnitRuleInspection.RULE_FQN, 0);
                boolean bl = classRuleAnnotated = JUnitRuleInspection.this.REPORT_CLASS_RULE_PROBLEMS && AnnotationUtil.isAnnotated((PsiModifierListOwner)field, JUnitRuleInspection.CLASS_RULE_FQN, 0);
                if (ruleAnnotated || classRuleAnnotated) {
                    PsiClass aClass;
                    String annotation = ruleAnnotated ? JUnitRuleInspection.RULE_FQN : JUnitRuleInspection.CLASS_RULE_FQN;
                    String errorMessage = JUnitRuleInspection.getPublicStaticErrorMessage(field, ruleAnnotated, classRuleAnnotated);
                    if (errorMessage != null) {
                        this.registerError((PsiElement)field.getNameIdentifier(), InspectionGadgetsBundle.message("junit.rule.problem.descriptor", annotation, errorMessage), "Make field " + errorMessage, annotation);
                    }
                    if (!InheritanceUtil.isInheritor(aClass = PsiUtil.resolveClassInClassTypeOnly(field.getType()), false, "org.junit.rules.TestRule") && !InheritanceUtil.isInheritor(aClass, false, "org.junit.rules.MethodRule")) {
                        this.registerError((PsiElement)field.getNameIdentifier(), InspectionGadgetsBundle.message("junit.rule.type.problem.descriptor", new Object[0]));
                    }
                }
            }
        };
    }

    static String getPublicStaticErrorMessage(PsiModifierListOwner field, boolean shouldBeNonStatic, boolean shouldBeStatic) {
        String errorMessage = null;
        boolean hasStatic = field.hasModifierProperty("static");
        boolean hasPublic = field.hasModifierProperty("public");
        if (!hasPublic) {
            errorMessage = shouldBeStatic ? (!hasStatic ? "'public' and 'static'" : "'public'") : (!hasStatic ? "'public'" : "'public' and non-static");
        } else if (!hasStatic) {
            if (shouldBeStatic) {
                errorMessage = "'static'";
            }
        } else if (shouldBeNonStatic) {
            errorMessage = "non-static";
        }
        return errorMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/JUnitRuleInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

