/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NCSSVisitor;
import org.jetbrains.annotations.NotNull;

public class NonCommentSourceStatementsInspection
extends MethodMetricInspection {
    private static final int DEFAULT_LIMIT = 30;

    @Override
    @NotNull
    public String getID() {
        if ("OverlyLongMethod" == null) {
            NonCommentSourceStatementsInspection.$$$reportNull$$$0(0);
        }
        return "OverlyLongMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.comment.source.statements.display.name", new Object[0]);
        if (string == null) {
            NonCommentSourceStatementsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 30;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("non.comment.source.statements.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer statementCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("non.comment.source.statements.problem.descriptor", statementCount);
        if (string == null) {
            NonCommentSourceStatementsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonCommentSourceStatementsMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NonCommentSourceStatementsMethodVisitor
    extends BaseInspectionVisitor {
        private NonCommentSourceStatementsMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NonCommentSourceStatementsMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            NCSSVisitor visitor = new NCSSVisitor();
            method.accept(visitor);
            int count = visitor.getStatementCount();
            if (count <= NonCommentSourceStatementsInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, count);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection$NonCommentSourceStatementsMethodVisitor", "visitMethod"));
        }
    }
}

