/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class LengthOneStringInIndexOfInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("length.one.string.in.indexof.display.name", new Object[0]);
        if (string == null) {
            LengthOneStringInIndexOfInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("SingleCharacterStringConcatenation" == null) {
            LengthOneStringInIndexOfInspection.$$$reportNull$$$0(1);
        }
        return "SingleCharacterStringConcatenation";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        String escapedString = StringUtil.escapeStringCharacters(string);
        String string2 = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", escapedString);
        if (string2 == null) {
            LengthOneStringInIndexOfInspection.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LengthOneStringsInIndexOfVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceStringsWithCharsFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/LengthOneStringInIndexOfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class LengthOneStringsInIndexOfVisitor
    extends BaseInspectionVisitor {
        private LengthOneStringsInIndexOfVisitor() {
        }

        @Override
        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                LengthOneStringsInIndexOfVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            String value = (String)expression.getValue();
            if (value == null || value.length() != 1) {
                return;
            }
            if (!LengthOneStringsInIndexOfVisitor.isArgumentOfIndexOf(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, value);
        }

        static boolean isArgumentOfIndexOf(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent == null) {
                return false;
            }
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandparent = parent.getParent();
            if (!(grandparent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)grandparent;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"indexOf".equals(name) && !"lastIndexOf".equals(name)) {
                return false;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            String className = methodClass.getQualifiedName();
            return "java.lang.String".equals(className);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/LengthOneStringInIndexOfInspection$LengthOneStringsInIndexOfVisitor", "visitLiteralExpression"));
        }
    }

    private static class ReplaceStringsWithCharsFix
    extends InspectionGadgetsFix {
        private ReplaceStringsWithCharsFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("length.one.strings.in.concatenation.replace.quickfix", new Object[0]);
            if (string == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            int length;
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            String text2 = expression.getText();
            String character = text2.substring(1, (length = text2.length()) - 1);
            String charLiteral = "'".equals(character) ? "'\\''" : '\'' + character + '\'';
            PsiReplacementUtil.replaceExpression(expression, charLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/LengthOneStringInIndexOfInspection$ReplaceStringsWithCharsFix", "getFamilyName"));
        }
    }
}

