/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptorUtil {
    public static final int NONE = 0;
    static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_TREE_END = 4;
    public static final Couple<String> XML_CODE_MARKER = Couple.of("<xml-code>", "</xml-code>");

    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement psiElement) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(0);
        }
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        String ref = psiElement.getText();
        if (descriptor instanceof ProblemDescriptorBase) {
            TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
            TextRange elementRange = psiElement.getTextRange();
            if (textRange != null && elementRange != null && (textRange = textRange.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && textRange.getEndOffset() <= elementRange.getLength()) {
                ref = textRange.substring(ref);
            }
        }
        ref = ref.replace('\n', ' ').trim();
        ref = StringUtil.first(ref, 100, true);
        return ref.trim().replaceAll("\\s+", " ");
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element, boolean appendLineNumber) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(1);
        }
        String string = ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, appendLineNumber ? 1 : 0);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element, @FlagConstant int flags) {
        int endIndex;
        int lineNumber;
        String message;
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(3);
        }
        if ((message = descriptor.getDescriptionTemplate()) == null) {
            if ("" == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(4);
            }
            return "";
        }
        if ((flags & 1) != 0 && descriptor instanceof ProblemDescriptor && !message.contains("#ref") && message.contains("#loc") && (lineNumber = ((ProblemDescriptor)descriptor).getLineNumber()) >= 0) {
            message = StringUtil.replace(message, "#loc", "(" + InspectionsBundle.message("inspection.export.results.at.line", new Object[0]) + " " + (lineNumber + 1) + ")");
        }
        message = ProblemDescriptorUtil.unescapeTags(message);
        message = StringUtil.replace(message, "#loc ", "");
        message = StringUtil.replace(message, " #loc", "");
        if ((message = StringUtil.replace(message, "#loc", "")).contains("#ref")) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor, element);
            message = StringUtil.replace(message, "#ref", ref);
        }
        int n = endIndex = (flags & 4) != 0 ? message.indexOf("#treeend") : -1;
        if (endIndex > 0) {
            message = message.substring(0, endIndex);
        }
        message = StringUtil.replace(message, "#end", "");
        message = StringUtil.replace(message, "#treeend", "");
        String string = message.trim();
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static String unescapeTags(String message) {
        message = StringUtil.replace(message, "<code>", "'");
        message = (message = StringUtil.replace(message, "</code>", "'")).contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message) : StringUtil.unescapeXml(message);
        return message;
    }

    private static String unescapeXmlCode(String message) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : StringUtil.split(message, (String)ProblemDescriptorUtil.XML_CODE_MARKER.first)) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings.addAll(StringUtil.split(string, (String)ProblemDescriptorUtil.XML_CODE_MARKER.second, false));
                continue;
            }
            strings.add(string);
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder.append(string.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder.append(StringUtil.unescapeXml(string));
        }
        return builder.toString();
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, PsiElement element) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(6);
        }
        String string = ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, false);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        TextAttributesKey attributes;
        ProblemHighlightType highlightType;
        HighlightInfoType highlightInfoType;
        if (problemDescriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(8);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(9);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(10);
        }
        if ((highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType(highlightType = problemDescriptor.getHighlightType(), severity, severityRegistrar)) == HighlightSeverity.INFORMATION && (attributes = ((ProblemDescriptorBase)problemDescriptor).getEnforcedTextAttributes()) != null) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, attributes);
            if (highlightInfoTypeImpl == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(11);
            }
            return highlightInfoTypeImpl;
        }
        HighlightInfoType highlightInfoType2 = highlightInfoType;
        if (highlightInfoType2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(12);
        }
        return highlightInfoType2;
    }

    public static HighlightInfoType getHighlightInfoType(@NotNull ProblemHighlightType highlightType, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (highlightType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(13);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(14);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(15);
        }
        switch (highlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_DEPRECATED: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
            }
            case LIKE_MARKED_FOR_REMOVAL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.MARKED_FOR_REMOVAL.getAttributesKey());
            }
            case LIKE_UNKNOWN_SYMBOL: {
                if (severity == HighlightSeverity.ERROR) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                }
                if (severity == HighlightSeverity.WARNING) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                }
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_UNUSED_SYMBOL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
            }
            case INFO: {
                return HighlightInfoType.INFO;
            }
            case WEAK_WARNING: {
                return HighlightInfoType.WEAK_WARNING;
            }
            case ERROR: {
                return HighlightInfoType.WRONG_REF;
            }
            case GENERIC_ERROR: {
                return HighlightInfoType.ERROR;
            }
            case INFORMATION: {
                return HighlightInfoType.INFORMATION;
            }
        }
        throw new RuntimeException("Cannot map " + (Object)((Object)highlightType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDescriptionMessage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightTypeFromDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractHighlightedText";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptionMessage";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "highlightTypeFromDescriptor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static @interface FlagConstant {
    }
}

