/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.duplicates.ExpressionReturnValue;
import com.intellij.refactoring.util.duplicates.ExtractableExpressionPart;
import com.intellij.refactoring.util.duplicates.ExtractedParameter;
import com.intellij.refactoring.util.duplicates.FieldReturnValue;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Match {
    private static final Logger LOG = Logger.getInstance("#com.intellij.refactoring.util.duplicates.Match");
    private final PsiElement myMatchStart;
    private final PsiElement myMatchEnd;
    private final Map<PsiVariable, List<PsiElement>> myParameterValues = new HashMap<PsiVariable, List<PsiElement>>();
    private final Map<PsiVariable, ArrayList<PsiElement>> myParameterOccurrences = new HashMap<PsiVariable, ArrayList<PsiElement>>();
    private final Map<PsiElement, PsiElement> myDeclarationCorrespondence = new HashMap<PsiElement, PsiElement>();
    private ReturnValue myReturnValue;
    private Ref<PsiExpression> myInstanceExpression;
    final Map<PsiVariable, PsiType> myChangedParams = new HashMap<PsiVariable, PsiType>();
    private final boolean myIgnoreParameterTypes;
    private final List<ExtractedParameter> myExtractedParameters = new ArrayList<ExtractedParameter>();

    Match(PsiElement start, PsiElement end, boolean ignoreParameterTypes) {
        LOG.assertTrue(start.getParent() == end.getParent());
        this.myMatchStart = start;
        this.myMatchEnd = end;
        this.myIgnoreParameterTypes = ignoreParameterTypes;
    }

    public PsiElement getMatchStart() {
        return this.myMatchStart;
    }

    public PsiElement getMatchEnd() {
        return this.myMatchEnd;
    }

    @Nullable
    public List<PsiElement> getParameterValues(PsiVariable parameter) {
        return this.myParameterValues.get(parameter);
    }

    public ReturnValue getOutputVariableValue(PsiVariable outputParameter) {
        PsiElement decl = this.myDeclarationCorrespondence.get(outputParameter);
        if (decl instanceof PsiVariable) {
            return new VariableReturnValue((PsiVariable)decl);
        }
        List<PsiElement> parameterValue = this.getParameterValues(outputParameter);
        if (parameterValue != null && parameterValue.size() == 1 && parameterValue.get(0) instanceof PsiExpression) {
            return new ExpressionReturnValue((PsiExpression)parameterValue.get(0));
        }
        return null;
    }

    public boolean putParameter(Pair<PsiVariable, PsiType> parameter, PsiElement value) {
        boolean isVararg;
        PsiVariable psiVariable = (PsiVariable)parameter.first;
        if (this.myDeclarationCorrespondence.get(psiVariable) == null) {
            final boolean[] valueDependsOnReplacedScope = new boolean[1];
            value.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    PsiElement resolved = expression.resolve();
                    if (resolved != null && Comparing.equal(resolved.getContainingFile(), Match.this.getMatchEnd().getContainingFile())) {
                        TextRange range = Match.checkRange(resolved);
                        TextRange startRange = Match.checkRange(Match.this.getMatchStart());
                        TextRange endRange = Match.checkRange(Match.this.getMatchEnd());
                        if (startRange.getStartOffset() <= range.getStartOffset() && range.getEndOffset() <= endRange.getEndOffset()) {
                            valueDependsOnReplacedScope[0] = true;
                        }
                    }
                }
            });
            if (valueDependsOnReplacedScope[0]) {
                return false;
            }
        }
        List<PsiElement> currentValue = this.myParameterValues.get(psiVariable);
        boolean bl = isVararg = psiVariable instanceof PsiParameter && ((PsiParameter)psiVariable).isVarArgs();
        if (!(value instanceof PsiExpression)) {
            return false;
        }
        PsiType type = ((PsiExpression)value).getType();
        PsiType parameterType = (PsiType)parameter.second;
        if (type == null) {
            return false;
        }
        if (currentValue == null) {
            if (parameterType instanceof PsiClassType && ((PsiClassType)parameterType).resolve() instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)((PsiClassType)parameterType).resolve();
                LOG.assertTrue(typeParameter != null);
                for (PsiClassType classType : typeParameter.getExtendsListTypes()) {
                    if (classType.isAssignableFrom(type)) continue;
                    return false;
                }
            } else if (isVararg) {
                if (!((PsiEllipsisType)psiVariable.getType()).getComponentType().isAssignableFrom(type) && !((PsiEllipsisType)psiVariable.getType()).toArrayType().equals(type)) {
                    this.myChangedParams.put(psiVariable, new PsiEllipsisType(parameterType));
                }
            } else if (!this.myIgnoreParameterTypes && !parameterType.isAssignableFrom(type)) {
                return false;
            }
            ArrayList<PsiElement> values = new ArrayList<PsiElement>();
            values.add(value);
            this.myParameterValues.put(psiVariable, values);
            ArrayList elements = new ArrayList();
            this.myParameterOccurrences.put(psiVariable, elements);
            return true;
        }
        for (PsiElement val : currentValue) {
            if (isVararg || PsiEquivalenceUtil.areElementsEquivalent(val, value)) continue;
            return false;
        }
        if (isVararg) {
            if (!parameterType.isAssignableFrom(type)) {
                return false;
            }
            if (!((PsiEllipsisType)psiVariable.getType()).toArrayType().equals(type)) {
                currentValue.add(value);
            }
        }
        this.myParameterOccurrences.get(psiVariable).add(value);
        return true;
    }

    public ReturnValue getReturnValue() {
        return this.myReturnValue;
    }

    boolean registerReturnValue(ReturnValue returnValue) {
        if (this.myReturnValue == null) {
            this.myReturnValue = returnValue;
            return true;
        }
        return this.myReturnValue.isEquivalent(returnValue);
    }

    boolean registerInstanceExpression(PsiExpression instanceExpression, PsiClass contextClass) {
        if (this.myInstanceExpression == null) {
            if (instanceExpression != null) {
                PsiType type = instanceExpression.getType();
                if (!(type instanceof PsiClassType)) {
                    return false;
                }
                PsiClass hisClass = ((PsiClassType)type).resolve();
                if (hisClass == null || !InheritanceUtil.isInheritorOrSelf(hisClass, contextClass, true)) {
                    return false;
                }
            }
            this.myInstanceExpression = Ref.create(instanceExpression);
            return true;
        }
        if (this.myInstanceExpression.get() == null) {
            this.myInstanceExpression.set(instanceExpression);
            return instanceExpression == null;
        }
        if (instanceExpression != null) {
            return PsiEquivalenceUtil.areElementsEquivalent(instanceExpression, this.myInstanceExpression.get());
        }
        return this.myInstanceExpression.get() == null || this.myInstanceExpression.get() instanceof PsiThisExpression;
    }

    boolean putDeclarationCorrespondence(PsiElement patternDeclaration, @NotNull PsiElement matchDeclaration) {
        PsiElement originalValue;
        if (matchDeclaration == null) {
            Match.$$$reportNull$$$0(0);
        }
        if ((originalValue = this.myDeclarationCorrespondence.get(patternDeclaration)) == null) {
            this.myDeclarationCorrespondence.put(patternDeclaration, matchDeclaration);
            return true;
        }
        return originalValue == matchDeclaration;
    }

    boolean areCorrespond(PsiElement patternDeclaration, PsiElement matchDeclaration) {
        if (matchDeclaration == null || patternDeclaration == null) {
            return false;
        }
        PsiElement originalValue = this.myDeclarationCorrespondence.get(patternDeclaration);
        return originalValue == null || originalValue == matchDeclaration;
    }

    private PsiElement replaceWith(PsiStatement statement) throws IncorrectOperationException {
        PsiElement matchStart = this.getMatchStart();
        PsiElement matchEnd = this.getMatchEnd();
        PsiElement element = matchStart.getParent().addBefore(statement, matchStart);
        matchStart.getParent().deleteChildRange(matchStart, matchEnd);
        return element;
    }

    public PsiElement replaceByStatement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression, PsiVariable outputVariable) throws IncorrectOperationException {
        PsiStatement statement = null;
        if (outputVariable != null) {
            ReturnValue returnValue = this.getOutputVariableValue(outputVariable);
            if (returnValue == null && outputVariable instanceof PsiField) {
                returnValue = new FieldReturnValue((PsiField)outputVariable);
            }
            if (returnValue == null) {
                return null;
            }
            statement = returnValue.createReplacement(extractedMethod, methodCallExpression);
        } else if (this.getReturnValue() != null) {
            statement = this.getReturnValue().createReplacement(extractedMethod, methodCallExpression);
        }
        if (statement == null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance(methodCallExpression.getProject()).getElementFactory();
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)elementFactory.createStatementFromText("x();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance(methodCallExpression.getManager());
            expressionStatement = (PsiExpressionStatement)styleManager.reformat(expressionStatement);
            expressionStatement.getExpression().replace(methodCallExpression);
            statement = expressionStatement;
        }
        return this.replaceWith(statement);
    }

    public PsiExpression getInstanceExpression() {
        if (this.myInstanceExpression == null) {
            return null;
        }
        return this.myInstanceExpression.get();
    }

    public PsiElement replace(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression, PsiVariable outputVariable) throws IncorrectOperationException {
        this.declareLocalVariables();
        if (this.getMatchStart() == this.getMatchEnd() && this.getMatchStart() instanceof PsiExpression) {
            return this.replaceWithExpression(methodCallExpression);
        }
        return this.replaceByStatement(extractedMethod, methodCallExpression, outputVariable);
    }

    private void declareLocalVariables() throws IncorrectOperationException {
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment(this.getMatchStart());
        try {
            Project project = this.getMatchStart().getProject();
            ControlFlow controlFlow = ControlFlowFactory.getInstance(project).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment), false, false);
            int endOffset = controlFlow.getEndOffset(this.getMatchEnd());
            int startOffset = controlFlow.getStartOffset(this.getMatchStart());
            List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(controlFlow, endOffset, controlFlow.getSize());
            Collection<ControlFlowUtil.VariableInfo> reassigned = ControlFlowUtil.getInitializedTwice(controlFlow, endOffset, controlFlow.getSize());
            Collection<PsiVariable> outVariables = ControlFlowUtil.getWrittenVariables(controlFlow, startOffset, endOffset, false);
            for (PsiVariable variable : usedVariables) {
                PsiIdentifier identifier;
                if (outVariables.contains(variable) || (identifier = variable.getNameIdentifier()) == null) continue;
                TextRange textRange = Match.checkRange(identifier);
                TextRange startRange = Match.checkRange(this.getMatchStart());
                TextRange endRange = Match.checkRange(this.getMatchEnd());
                if (textRange.getStartOffset() < startRange.getStartOffset() || textRange.getEndOffset() > endRange.getEndOffset()) continue;
                String name = variable.getName();
                LOG.assertTrue(name != null);
                PsiDeclarationStatement statement = JavaPsiFacade.getInstance(project).getElementFactory().createVariableDeclarationStatement(name, variable.getType(), null);
                if (reassigned.contains(new ControlFlowUtil.VariableInfo(variable, null))) {
                    PsiElement[] psiElements = statement.getDeclaredElements();
                    PsiModifierList modifierList = ((PsiVariable)psiElements[0]).getModifierList();
                    LOG.assertTrue(modifierList != null);
                    modifierList.setModifierProperty("final", false);
                }
                this.getMatchStart().getParent().addBefore(statement, this.getMatchStart());
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
    }

    private static TextRange checkRange(PsiElement element) {
        TextRange endRange = element.getTextRange();
        LOG.assertTrue(endRange != null, element);
        return endRange;
    }

    public PsiElement replaceWithExpression(PsiExpression psiExpression) throws IncorrectOperationException {
        PsiElement matchStart = this.getMatchStart();
        LOG.assertTrue(matchStart == this.getMatchEnd());
        if (psiExpression instanceof PsiMethodCallExpression && matchStart instanceof PsiReferenceExpression && matchStart.getParent() instanceof PsiMethodCallExpression) {
            return JavaCodeStyleManager.getInstance(matchStart.getProject()).shortenClassReferences(matchStart.replace(((PsiMethodCallExpression)psiExpression).getMethodExpression()));
        }
        return JavaCodeStyleManager.getInstance(matchStart.getProject()).shortenClassReferences(matchStart.replace(psiExpression));
    }

    TextRange getTextRange() {
        TextRange startRange = Match.checkRange(this.getMatchStart());
        TextRange endRange = Match.checkRange(this.getMatchEnd());
        return new TextRange(startRange.getStartOffset(), endRange.getEndOffset());
    }

    @Nullable
    public PsiType getChangedReturnType(PsiMethod psiMethod) {
        PsiType returnType = psiMethod.getReturnType();
        if (returnType != null) {
            PsiElement parent = this.getMatchEnd().getParent();
            if (parent instanceof PsiExpression) {
                JavaPsiFacade facade;
                PsiClassType expressionType;
                PsiClass psiClass;
                JavaResolveResult result2;
                PsiElement element;
                if (parent instanceof PsiMethodCallExpression) {
                    PsiType type;
                    JavaResolveResult result3 = ((PsiMethodCallExpression)parent).resolveMethodGenerics();
                    PsiMethod method = (PsiMethod)result3.getElement();
                    if (method != null && (type = method.getReturnType()) != null && Match.weakerType(psiMethod, returnType, type = result3.getSubstitutor().substitute(type))) {
                        return type;
                    }
                } else if (parent instanceof PsiReferenceExpression && (element = (result2 = ((PsiReferenceExpression)parent).advancedResolve(false)).getElement()) instanceof PsiMember && (psiClass = ((PsiMember)element).getContainingClass()) != null && psiClass.isPhysical() && Match.weakerType(psiMethod, returnType, expressionType = (facade = JavaPsiFacade.getInstance(parent.getProject())).getElementFactory().createType(psiClass, result2.getSubstitutor()))) {
                    return expressionType;
                }
            } else if (parent instanceof PsiExpressionList) {
                JavaResolveResult result4;
                PsiMethod method;
                PsiExpression[] expressions = ((PsiExpressionList)parent).getExpressions();
                PsiElement call = parent.getParent();
                if (call instanceof PsiMethodCallExpression && (method = (PsiMethod)(result4 = ((PsiMethodCallExpression)call).resolveMethodGenerics()).getElement()) != null) {
                    int idx = ArrayUtil.find(expressions, this.getMatchEnd());
                    PsiParameter[] psiParameters = method.getParameterList().getParameters();
                    if (idx >= 0 && idx < psiParameters.length) {
                        PsiType type = result4.getSubstitutor().substitute(psiParameters[idx].getType());
                        if (type instanceof PsiEllipsisType) {
                            type = ((PsiEllipsisType)type).getComponentType();
                        }
                        if (Match.weakerType(psiMethod, returnType, type)) {
                            return type;
                        }
                    }
                }
            } else if (parent instanceof PsiLocalVariable) {
                PsiType localVariableType = ((PsiLocalVariable)parent).getType();
                if (Match.weakerType(psiMethod, returnType, localVariableType)) {
                    return localVariableType;
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiMethod replacedMethod = PsiTreeUtil.getParentOfType(parent, PsiMethod.class);
                LOG.assertTrue(replacedMethod != null);
                PsiType replacedMethodReturnType = replacedMethod.getReturnType();
                if (replacedMethodReturnType != null && Match.weakerType(psiMethod, returnType, replacedMethodReturnType)) {
                    return replacedMethodReturnType;
                }
            }
        }
        return null;
    }

    private static boolean weakerType(PsiMethod psiMethod, PsiType returnType, @NotNull PsiType currentType) {
        if (currentType == null) {
            Match.$$$reportNull$$$0(1);
        }
        PsiTypeParameter[] typeParameters = psiMethod.getTypeParameters();
        PsiSubstitutor substitutor = JavaPsiFacade.getInstance(psiMethod.getProject()).getResolveHelper().inferTypeArguments(typeParameters, new PsiType[]{returnType}, new PsiType[]{currentType}, PsiUtil.getLanguageLevel(psiMethod));
        return !TypeConversionUtil.isAssignable(currentType, substitutor.substitute(returnType));
    }

    public PsiFile getFile() {
        return this.getMatchStart().getContainingFile();
    }

    public boolean putExtractedParameter(@NotNull ExtractableExpressionPart patternPart, @NotNull ExtractableExpressionPart candidatePart) {
        if (patternPart == null) {
            Match.$$$reportNull$$$0(2);
        }
        if (candidatePart == null) {
            Match.$$$reportNull$$$0(3);
        }
        return ExtractedParameter.match(patternPart, candidatePart, this.myExtractedParameters);
    }

    @NotNull
    public List<ExtractedParameter> getExtractedParameters() {
        List<ExtractedParameter> list = this.myExtractedParameters;
        if (list == null) {
            Match.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchDeclaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternPart";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidatePart";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/Match";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/Match";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractedParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putDeclarationCorrespondence";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "weakerType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putExtractedParameter";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

