/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EqualsToEqualityFix
extends InspectionGadgetsFix {
    private final boolean myNegated;

    public EqualsToEqualityFix(boolean negated) {
        this.myNegated = negated;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.myNegated ? InspectionGadgetsBundle.message("not.equals.to.equality.quickfix", new Object[0]) : InspectionGadgetsBundle.message("equals.to.equality.quickfix", new Object[0]);
        if (string == null) {
            EqualsToEqualityFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)descriptor.getPsiElement().getParent().getParent();
        if (call == null) {
            return;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression lhs = PsiUtil.deparenthesizeExpression(methodExpression.getQualifierExpression());
        if (lhs == null) {
            return;
        }
        PsiExpression rhs = PsiUtil.deparenthesizeExpression(call.getArgumentList().getExpressions()[0]);
        if (rhs == null) {
            return;
        }
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses(call);
        CommentTracker commentTracker = new CommentTracker();
        String lhsText = commentTracker.text(lhs, 9);
        String rhsText = commentTracker.text(rhs, 9);
        if (parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)parent, lhsText + "!=" + rhsText, commentTracker);
        } else {
            PsiReplacementUtil.replaceExpression(call, lhsText + "==" + rhsText, commentTracker);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/EqualsToEqualityFix", "getFamilyName"));
    }
}

