/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.migration.ForCanBeForeachInspectionBase;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileCanBeForeachInspectionBase
extends BaseInspection {
    @Nullable
    static PsiStatement getPreviousStatement(PsiElement context) {
        PsiElement prevStatement = PsiTreeUtil.skipWhitespacesAndCommentsBackward(context);
        if (!(prevStatement instanceof PsiStatement)) {
            return null;
        }
        return (PsiStatement)prevStatement;
    }

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("WhileLoopReplaceableByForEach" == null) {
            WhileCanBeForeachInspectionBase.$$$reportNull$$$0(0);
        }
        return "WhileLoopReplaceableByForEach";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("while.can.be.foreach.display.name", new Object[0]);
        if (string == null) {
            WhileCanBeForeachInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("while.can.be.foreach.problem.descriptor", new Object[0]);
        if (string == null) {
            WhileCanBeForeachInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileCanBeForeachVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class IteratorHasNextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasNextCalled;
        private final PsiVariable iterator;

        private IteratorHasNextVisitor(@NotNull PsiVariable iterator) {
            if (iterator == null) {
                IteratorHasNextVisitor.$$$reportNull$$$0(0);
            }
            this.iterator = iterator;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                IteratorHasNextVisitor.$$$reportNull$$$0(1);
            }
            if (!this.hasNextCalled) {
                super.visitElement(element);
            }
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                IteratorHasNextVisitor.$$$reportNull$$$0(2);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"hasNext".equals(name)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (this.iterator.equals(target)) {
                this.hasNextCalled = true;
            }
        }

        boolean isHasNextCalled() {
            return this.hasNextCalled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$IteratorHasNextVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NumberCallsToIteratorNextVisitor
    extends JavaRecursiveElementVisitor {
        private int numCallsToIteratorNext;
        private final PsiVariable iterator;

        private NumberCallsToIteratorNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
            if (callExpression == null) {
                NumberCallsToIteratorNextVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(callExpression);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"next".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!this.iterator.equals(target)) {
                return;
            }
            ++this.numCallsToIteratorNext;
        }

        int getNumCallsToIteratorNext() {
            return this.numCallsToIteratorNext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$NumberCallsToIteratorNextVisitor", "visitMethodCallExpression"));
        }
    }

    private static class WhileCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private WhileCanBeForeachVisitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            if (whileStatement == null) {
                WhileCanBeForeachVisitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(whileStatement);
            if (!WhileCanBeForeachVisitor.isCollectionLoopStatement(whileStatement)) {
                return;
            }
            this.registerStatementError(whileStatement, new Object[0]);
        }

        private static boolean isCollectionLoopStatement(PsiWhileStatement whileStatement) {
            PsiStatement initialization = WhileCanBeForeachInspectionBase.getPreviousStatement(whileStatement);
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator", "java.util.ListIterator")) {
                return false;
            }
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return false;
            }
            if (!(initialValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
            PsiExpressionList argumentList = initialCall.getArgumentList();
            PsiExpression[] argument = argumentList.getExpressions();
            if (argument.length != 0) {
                return false;
            }
            PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
            String initialCallName = initialMethodExpression.getReferenceName();
            if (!"iterator".equals(initialCallName) && !"listIterator".equals(initialCallName)) {
                return false;
            }
            PsiExpression qualifier = ExpressionUtils.getQualifierOrThis(initialMethodExpression);
            if (qualifier instanceof PsiSuperExpression) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiClassType)) {
                return false;
            }
            PsiClass qualifierClass = ((PsiClassType)qualifierType).resolve();
            if (!InheritanceUtil.isInheritor(qualifierClass, "java.lang.Iterable")) {
                return false;
            }
            PsiExpression condition = whileStatement.getCondition();
            if (!ForCanBeForeachInspectionBase.isHasNext(condition, variable)) {
                return false;
            }
            PsiStatement body = whileStatement.getBody();
            if (body == null) {
                return false;
            }
            if (WhileCanBeForeachVisitor.calculateCallsToIteratorNext(variable, body) != 1) {
                return false;
            }
            if (ForCanBeForeachInspectionBase.isIteratorMethodCalled(variable, body)) {
                return false;
            }
            if (WhileCanBeForeachVisitor.isIteratorHasNextCalled(variable, body)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, body)) {
                return false;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, body)) {
                return false;
            }
            for (PsiElement nextSibling = whileStatement.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                if (!VariableAccessUtils.variableValueIsUsed(variable, nextSibling)) continue;
                return false;
            }
            return true;
        }

        private static int calculateCallsToIteratorNext(PsiVariable iterator, PsiElement context) {
            NumberCallsToIteratorNextVisitor visitor = new NumberCallsToIteratorNextVisitor(iterator);
            context.accept(visitor);
            return visitor.getNumCallsToIteratorNext();
        }

        private static boolean isIteratorHasNextCalled(PsiVariable iterator, PsiElement context) {
            IteratorHasNextVisitor visitor = new IteratorHasNextVisitor(iterator);
            context.accept(visitor);
            return visitor.isHasNextCalled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$WhileCanBeForeachVisitor", "visitWhileStatement"));
        }
    }
}

