/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SerializableHasSerializationMethodsInspectionBase
extends SerializableInspectionBase {
    protected boolean ignoreClassWithoutFields = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.display.name", new Object[0]);
        if (string == null) {
            SerializableHasSerializationMethodsInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        if (!hasReadObject && !hasWriteObject) {
            String string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor", new Object[0]);
            if (string == null) {
                SerializableHasSerializationMethodsInspectionBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (hasReadObject) {
            String string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor1", new Object[0]);
            if (string == null) {
                SerializableHasSerializationMethodsInspectionBase.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor2", new Object[0]);
        if (string == null) {
            SerializableHasSerializationMethodsInspectionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected JComponent[] createAdditionalOptions() {
        JComponent[] jComponentArray = new JComponent[]{new CheckBox(InspectionGadgetsBundle.message("serializable.has.serialization.methods.ignore.option", new Object[0]), this, "ignoreClassWithoutFields")};
        if (jComponentArray == null) {
            SerializableHasSerializationMethodsInspectionBase.$$$reportNull$$$0(4);
        }
        return jComponentArray;
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            SerializableHasSerializationMethodsInspectionBase.$$$reportNull$$$0(5);
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            if (!"ignoreClassWithoutFields".equals(option.getAttributeValue("name"))) continue;
            this.ignoreClassWithoutFields = Boolean.valueOf(option.getAttributeValue("value"));
        }
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SerializableHasSerializationMethodsInspectionBase.$$$reportNull$$$0(6);
        }
        super.writeSettings(node);
        if (this.ignoreClassWithoutFields) {
            node.addContent(new Element("option").setAttribute("name", "ignoreClassWithoutFields").setAttribute("value", String.valueOf(this.ignoreClassWithoutFields)));
        }
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableHasSerializationMethodsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalOptions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SerializableHasSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private SerializableHasSerializationMethodsVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                SerializableHasSerializationMethodsVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            if (SerializableHasSerializationMethodsInspectionBase.this.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (hasWriteObject && hasReadObject) {
                return;
            }
            if (SerializableHasSerializationMethodsInspectionBase.this.isIgnoredSubclass(aClass)) {
                return;
            }
            if (SerializableHasSerializationMethodsInspectionBase.this.ignoreClassWithoutFields) {
                PsiField[] fields = aClass.getFields();
                boolean hasField = false;
                for (PsiField field : fields) {
                    if (field.hasModifierProperty("static")) continue;
                    hasField = true;
                    break;
                }
                if (!hasField) {
                    return;
                }
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspectionBase$SerializableHasSerializationMethodsVisitor", "visitClass"));
        }
    }
}

