/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallToStringConcatCanBeReplacedByOperatorInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.string.concat.can.be.replaced.by.operator.display.name", new Object[0]);
        if (string == null) {
            CallToStringConcatCanBeReplacedByOperatorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.string.concat.can.be.replaced.by.operator.problem.descriptor", new Object[0]);
        if (string == null) {
            CallToStringConcatCanBeReplacedByOperatorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new CallToStringConcatCanBeReplacedByOperatorFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToStringConcatCanBeReplacedByOperatorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/CallToStringConcatCanBeReplacedByOperatorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CallToStringConcatCanBeReplacedByOperatorVisitor
    extends BaseInspectionVisitor {
        private CallToStringConcatCanBeReplacedByOperatorVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            Project project = expression.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiClass stringClass = psiFacade.findClass("java.lang.String", expression.getResolveScope());
            if (stringClass == null) {
                return;
            }
            PsiClassType stringType = psiFacade.getElementFactory().createType(stringClass);
            if (!MethodCallUtils.isCallToMethod(expression, "java.lang.String", (PsiType)stringType, "concat", stringType)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionStatement) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }

    private static class CallToStringConcatCanBeReplacedByOperatorFix
    extends InspectionGadgetsFix {
        private CallToStringConcatCanBeReplacedByOperatorFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("call.to.string.concat.can.be.replaced.by.operator.quickfix", new Object[0]);
            if (string == null) {
                CallToStringConcatCanBeReplacedByOperatorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiElement grandParent = referenceExpression.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            CommentTracker tracker = new CommentTracker();
            String newExpression = tracker.text(qualifier) + '+' + tracker.text(argument);
            PsiReplacementUtil.replaceExpression(methodCallExpression, newExpression, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/CallToStringConcatCanBeReplacedByOperatorInspection$CallToStringConcatCanBeReplacedByOperatorFix", "getFamilyName"));
        }
    }
}

