/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.MemberImplementorExplorer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class OverrideImplementExploreUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.generation.OverrideImplementExploreUtil");
    private static final NullableLazyValue<MemberImplementorExplorersProvider> ourExplorersProvider = new VolatileNullableLazyValue<MemberImplementorExplorersProvider>(){

        @Override
        protected MemberImplementorExplorersProvider compute() {
            return ServiceManager.getService(MemberImplementorExplorersProvider.class);
        }
    };

    @NotNull
    public static Collection<CandidateInfo> getMethodsToOverrideImplement(PsiClass aClass, boolean toImplement) {
        Collection<CandidateInfo> collection = OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, toImplement).values();
        if (collection == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToImplement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(1);
        }
        Set<MethodSignature> set = OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, true).keySet();
        if (set == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToOverride(@NotNull PsiClass aClass) {
        if (aClass == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(3);
        }
        if (aClass.isAnnotationType()) {
            Set<MethodSignature> set = Collections.emptySet();
            if (set == null) {
                OverrideImplementExploreUtil.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<MethodSignature> set = OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, false).keySet();
        if (set == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(PsiClass aClass, boolean toImplement) {
        Map<MethodSignature, CandidateInfo> map = OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, toImplement, true);
        if (map == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(PsiClass aClass, boolean toImplement, boolean skipImplemented) {
        LinkedHashMap<MethodSignature, PsiMethod> abstracts = new LinkedHashMap<MethodSignature, PsiMethod>();
        LinkedHashMap<MethodSignature, PsiMethod> finals = new LinkedHashMap<MethodSignature, PsiMethod>();
        LinkedHashMap<MethodSignature, PsiMethod> concretes = new LinkedHashMap<MethodSignature, PsiMethod>();
        if (aClass.isAnnotationType() || aClass instanceof PsiTypeParameter) {
            Map<MethodSignature, CandidateInfo> map = Collections.emptyMap();
            if (map == null) {
                OverrideImplementExploreUtil.$$$reportNull$$$0(7);
            }
            return map;
        }
        PsiUtilCore.ensureValid(aClass);
        Collection<HierarchicalMethodSignature> allMethodSigs = aClass.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(aClass.getProject()).getResolveHelper();
        for (HierarchicalMethodSignature signature : allMethodSigs) {
            PsiClass hisClass;
            PsiMethod method = signature.getMethod();
            PsiUtilCore.ensureValid(method);
            if (method.hasModifierProperty("static") || !resolveHelper.isAccessible(method, aClass, aClass) || method.isConstructor() && method.hasModifierProperty("abstract")) continue;
            for (HierarchicalMethodSignature superMethodSignature : signature.getSuperSignatures()) {
                PsiMethod superMethod = superMethodSignature.getMethod();
                if (PsiUtil.getAccessLevel(superMethod.getModifierList()) <= PsiUtil.getAccessLevel(method.getModifierList())) continue;
                method = superMethod;
                break;
            }
            if ((hisClass = method.getContainingClass()) == null || method.isConstructor() && (!aClass.isInheritor(hisClass, false) || aClass instanceof PsiAnonymousClass || aClass.isEnum()) || skipImplemented && MethodSignatureUtil.findMethodBySignature(aClass, signature, false) != null) continue;
            if (method.hasModifierProperty("final")) {
                finals.put(signature, method);
                continue;
            }
            LinkedHashMap<MethodSignature, PsiMethod> map = hisClass.isInterface() || method.hasModifierProperty("abstract") ? abstracts : concretes;
            OverrideImplementExploreUtil.fillMap(signature, method, map);
            if (!OverrideImplementExploreUtil.isDefaultMethod(aClass, method)) continue;
            OverrideImplementExploreUtil.fillMap(signature, method, concretes);
        }
        TreeMap<MethodSignature, CandidateInfo> result = new TreeMap<MethodSignature, CandidateInfo>(new MethodSignatureComparator());
        if (toImplement || aClass.isInterface()) {
            OverrideImplementExploreUtil.collectMethodsToImplement(aClass, abstracts, finals, concretes, result);
        } else {
            for (Map.Entry entry : concretes.entrySet()) {
                PsiMethod abstractOne;
                MethodSignature signature = (MethodSignature)entry.getKey();
                PsiMethod concrete = (PsiMethod)entry.getValue();
                if (finals.get(signature) != null || (abstractOne = (PsiMethod)abstracts.get(signature)) != null && abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true) && !"java.lang.Object".equals(concrete.getContainingClass().getQualifiedName())) continue;
                PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor(concrete, signature.getSubstitutor());
                CandidateInfo info = new CandidateInfo(concrete, subst);
                result.put(signature, info);
            }
        }
        TreeMap<MethodSignature, CandidateInfo> treeMap = result;
        if (treeMap == null) {
            OverrideImplementExploreUtil.$$$reportNull$$$0(8);
        }
        return treeMap;
    }

    private static boolean isDefaultMethod(PsiClass aClass, PsiMethod method) {
        return method.hasModifierProperty("default") && PsiUtil.getLanguageLevel(aClass).isAtLeast(LanguageLevel.JDK_1_8);
    }

    private static void fillMap(HierarchicalMethodSignature signature, PsiMethod method, Map<MethodSignature, PsiMethod> map) {
        PsiMethod other = map.get(signature);
        if (other == null || OverrideImplementExploreUtil.preferLeftForImplement(method, other)) {
            map.put(signature, method);
        }
    }

    public static void collectMethodsToImplement(PsiClass aClass, Map<MethodSignature, PsiMethod> abstracts, Map<MethodSignature, PsiMethod> finals, Map<MethodSignature, PsiMethod> concretes, Map<MethodSignature, CandidateInfo> result) {
        for (Map.Entry<MethodSignature, PsiMethod> entry : abstracts.entrySet()) {
            MethodSignature signature = entry.getKey();
            PsiMethod abstractOne = entry.getValue();
            PsiMethod concrete = concretes.get(signature);
            if (concrete != null && PsiUtil.getAccessLevel(concrete.getModifierList()) >= PsiUtil.getAccessLevel(abstractOne.getModifierList()) && (abstractOne.getContainingClass().isInterface() || !abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true)) && !OverrideImplementExploreUtil.isDefaultMethod(aClass, abstractOne) || finals.get(signature) != null) continue;
            PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor(abstractOne, signature.getSubstitutor());
            CandidateInfo info = new CandidateInfo(abstractOne, subst);
            result.put(signature, info);
        }
        MemberImplementorExplorersProvider explorersProvider = ourExplorersProvider.getValue();
        if (explorersProvider != null) {
            for (MemberImplementorExplorer implementor : explorersProvider.getExplorers()) {
                for (PsiMethod method : implementor.getMethodsToImplement(aClass)) {
                    MethodSignature signature = MethodSignatureUtil.createMethodSignature(method.getName(), method.getParameterList(), method.getTypeParameterList(), PsiSubstitutor.EMPTY, method.isConstructor());
                    CandidateInfo info = new CandidateInfo(method, PsiSubstitutor.EMPTY);
                    result.put(signature, info);
                }
            }
        }
    }

    private static boolean preferLeftForImplement(PsiMethod left, PsiMethod right) {
        PsiAnnotation[] rightAnnotations;
        if (PsiUtil.getAccessLevel(left.getModifierList()) > PsiUtil.getAccessLevel(right.getModifierList())) {
            return true;
        }
        if (!left.getContainingClass().isInterface()) {
            return true;
        }
        if (!right.getContainingClass().isInterface()) {
            return false;
        }
        PsiAnnotation[] leftAnnotations = left.getModifierList().getAnnotations();
        return leftAnnotations.length > (rightAnnotations = right.getModifierList().getAnnotations()).length;
    }

    public static PsiSubstitutor correctSubstitutor(PsiMethod method, PsiSubstitutor substitutor) {
        PsiClass hisClass = method.getContainingClass();
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (typeParameters.length > 0 && PsiUtil.isRawSubstitutor(hisClass, substitutor)) {
            substitutor = JavaPsiFacade.getInstance(method.getProject()).getElementFactory().createRawSubstitutor(substitutor, typeParameters);
        }
        return substitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/OverrideImplementExploreUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsToOverrideImplement";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/OverrideImplementExploreUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignaturesToImplement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignaturesToOverride";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapToOverrideImplement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignaturesToImplement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignaturesToOverride";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MethodSignatureComparator
    implements Comparator<MethodSignature> {
        @Override
        public int compare(MethodSignature o1, MethodSignature o2) {
            if (o1 instanceof MethodSignatureBackedByPsiMethod && o2 instanceof MethodSignatureBackedByPsiMethod) {
                PsiMethod m1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod();
                PsiMethod m2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod();
                PsiClass c1 = m1.getContainingClass();
                PsiClass c2 = m2.getContainingClass();
                if (c1 != null && c2 != null) {
                    if (c1 == c2) {
                        List<PsiMethod> methods = Arrays.asList(c1.getMethods());
                        return methods.indexOf(m1) - methods.indexOf(m2);
                    }
                    if (c1.isInheritor(c2, true)) {
                        return -1;
                    }
                    if (c2.isInheritor(c1, true)) {
                        return 1;
                    }
                    return StringUtil.notNullize(c1.getQualifiedName()).compareTo(StringUtil.notNullize(c2.getQualifiedName()));
                }
                return m1.getTextOffset() - m2.getTextOffset();
            }
            return 0;
        }
    }

    public static interface MemberImplementorExplorersProvider {
        public MemberImplementorExplorer[] getExplorers();
    }
}

