/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsTypeElementImpl
extends ClsElementImpl
implements PsiTypeElement {
    static final char VARIANCE_NONE = '\u0000';
    static final char VARIANCE_EXTENDS = '+';
    static final char VARIANCE_SUPER = '-';
    static final char VARIANCE_INVARIANT = '*';
    private final PsiElement myParent;
    private final String myTypeText;
    private final char myVariance;
    private final NullableLazyValue<ClsElementImpl> myChild;
    private final NotNullLazyValue<PsiType> myCachedType;

    public ClsTypeElementImpl(@NotNull PsiElement parent, @NotNull String typeText, char variance) {
        if (parent == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(0);
        }
        if (typeText == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(1);
        }
        this.myParent = parent;
        this.myTypeText = TypeInfo.internFrequentType(typeText);
        this.myVariance = variance;
        this.myChild = new AtomicNullableLazyValue<ClsElementImpl>(){

            @Override
            protected ClsElementImpl compute() {
                return ClsTypeElementImpl.this.calculateChild();
            }
        };
        this.myCachedType = new AtomicNotNullLazyValue<PsiType>(){

            @Override
            @NotNull
            protected PsiType compute() {
                PsiType psiType = ClsTypeElementImpl.this.calculateType();
                if (psiType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsTypeElementImpl$2", "compute"));
            }
        };
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        ClsElementImpl child = this.myChild.getValue();
        if (child != null) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = child;
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        String shortClassName = PsiNameHelper.getShortClassName(this.myTypeText);
        return this.decorateTypeText(shortClassName);
    }

    private String decorateTypeText(String shortClassName) {
        switch (this.myVariance) {
            case '\u0000': {
                return shortClassName;
            }
            case '+': {
                return "? extends " + shortClassName;
            }
            case '-': {
                return "? super " + shortClassName;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : this.myVariance;
        return null;
    }

    public String getCanonicalText() {
        return this.decorateTypeText(this.myTypeText);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(3);
        }
        buffer.append(this.decorateTypeText(this.myTypeText));
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(4);
        }
        this.setMirrorCheckingType(element, JavaElementType.TYPE);
        ClsElementImpl child = this.myChild.getValue();
        if (child != null) {
            child.setMirror(element.getFirstChildNode());
        }
    }

    private boolean isArray() {
        return this.myTypeText.endsWith("[]");
    }

    private boolean isVarArgs() {
        return this.myTypeText.endsWith("...");
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myCachedType.getValue();
        if (psiType == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(5);
        }
        return psiType;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        return null;
    }

    private ClsElementImpl calculateChild() {
        if (PsiJavaParserFacadeImpl.getPrimitiveType(this.myTypeText) != null) {
            return null;
        }
        if (this.isArray()) {
            return this.myVariance == '\u0000' ? new ClsTypeElementImpl(this, this.myTypeText.substring(0, this.myTypeText.length() - 2), this.myVariance) : new ClsTypeElementImpl(this, this.myTypeText, '\u0000');
        }
        if (this.isVarArgs()) {
            return new ClsTypeElementImpl(this, this.myTypeText.substring(0, this.myTypeText.length() - 3), this.myVariance);
        }
        return this.myVariance == '*' ? null : new ClsJavaCodeReferenceElementImpl(this, this.myTypeText);
    }

    @NotNull
    private PsiType calculateType() {
        PsiModifierList modifierList = this.myParent instanceof PsiModifierListOwner ? ((PsiModifierListOwner)this.myParent).getModifierList() : null;
        PsiType psiType = JavaSharedImplUtil.applyAnnotations(this.calculateBaseType(), modifierList);
        if (psiType == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(6);
        }
        return psiType;
    }

    @NotNull
    private PsiType calculateBaseType() {
        PsiPrimitiveType result = PsiJavaParserFacadeImpl.getPrimitiveType(this.myTypeText);
        if (result != null) {
            PsiPrimitiveType psiPrimitiveType = result;
            if (psiPrimitiveType == null) {
                ClsTypeElementImpl.$$$reportNull$$$0(7);
            }
            return psiPrimitiveType;
        }
        ClsElementImpl childElement = this.myChild.getValue();
        if (childElement instanceof ClsTypeElementImpl) {
            if (this.isArray()) {
                switch (this.myVariance) {
                    case '\u0000': {
                        PsiArrayType psiArrayType = ((PsiTypeElement)((Object)childElement)).getType().createArrayType();
                        if (psiArrayType == null) {
                            ClsTypeElementImpl.$$$reportNull$$$0(8);
                        }
                        return psiArrayType;
                    }
                    case '+': {
                        PsiWildcardType psiWildcardType = PsiWildcardType.createExtends(this.getManager(), ((PsiTypeElement)((Object)childElement)).getType());
                        if (psiWildcardType == null) {
                            ClsTypeElementImpl.$$$reportNull$$$0(9);
                        }
                        return psiWildcardType;
                    }
                    case '-': {
                        PsiWildcardType psiWildcardType = PsiWildcardType.createSuper(this.getManager(), ((PsiTypeElement)((Object)childElement)).getType());
                        if (psiWildcardType == null) {
                            ClsTypeElementImpl.$$$reportNull$$$0(10);
                        }
                        return psiWildcardType;
                    }
                }
                assert (false) : this.myVariance;
                if (null == null) {
                    ClsTypeElementImpl.$$$reportNull$$$0(11);
                }
                return null;
            }
            assert (this.isVarArgs()) : this;
            PsiEllipsisType psiEllipsisType = new PsiEllipsisType(((PsiTypeElement)((Object)childElement)).getType());
            if (psiEllipsisType == null) {
                ClsTypeElementImpl.$$$reportNull$$$0(12);
            }
            return psiEllipsisType;
        }
        if (childElement instanceof ClsJavaCodeReferenceElementImpl) {
            PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType((PsiJavaCodeReferenceElement)((Object)childElement), null);
            switch (this.myVariance) {
                case '\u0000': {
                    PsiClassReferenceType psiClassReferenceType2 = psiClassReferenceType;
                    if (psiClassReferenceType2 == null) {
                        ClsTypeElementImpl.$$$reportNull$$$0(13);
                    }
                    return psiClassReferenceType2;
                }
                case '+': {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createExtends(this.getManager(), psiClassReferenceType);
                    if (psiWildcardType == null) {
                        ClsTypeElementImpl.$$$reportNull$$$0(14);
                    }
                    return psiWildcardType;
                }
                case '-': {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createSuper(this.getManager(), psiClassReferenceType);
                    if (psiWildcardType == null) {
                        ClsTypeElementImpl.$$$reportNull$$$0(15);
                    }
                    return psiWildcardType;
                }
                case '*': {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded(this.getManager());
                    if (psiWildcardType == null) {
                        ClsTypeElementImpl.$$$reportNull$$$0(16);
                    }
                    return psiWildcardType;
                }
            }
            assert (false) : this.myVariance;
            if (null == null) {
                ClsTypeElementImpl.$$$reportNull$$$0(17);
            }
            return null;
        }
        assert (childElement == null) : this;
        PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded(this.getManager());
        if (psiWildcardType == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(18);
        }
        return psiWildcardType;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(19);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(20);
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(22);
        }
        return psiAnnotationArray;
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsTypeElementImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsTypeElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBaseType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

