/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import com.intellij.util.CharTable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PsiDocCommentImpl
extends LazyParseablePsiElement
implements PsiDocComment,
JavaTokenType,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.javadoc.PsiDocCommentImpl");
    private static final TokenSet TAG_BIT_SET = TokenSet.create(DOC_TAG);
    private static final ArrayFactory<PsiDocTag> ARRAY_FACTORY = count -> count == 0 ? PsiDocTag.EMPTY_ARRAY : new PsiDocTag[count];
    private static final Pattern WS_PATTERN = Pattern.compile("\\s*");

    public PsiDocCommentImpl(CharSequence text) {
        super(JavaDocElementType.DOC_COMMENT, text);
    }

    @Override
    public PsiJavaDocumentedElement getOwner() {
        return PsiImplUtil.findDocCommentOwner(this);
    }

    @Override
    @NotNull
    public PsiElement[] getDescriptionElements() {
        IElementType i;
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (ASTNode child = this.getFirstChildNode(); child != null && (i = child.getElementType()) != DOC_TAG; child = child.getTreeNext()) {
            if (i == DOC_COMMENT_START || i == DOC_COMMENT_END || i == DOC_COMMENT_LEADING_ASTERISKS) continue;
            array.add(child.getPsi());
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiDocTag[] getTags() {
        PsiDocTag[] psiDocTagArray = (PsiDocTag[])this.getChildrenAsPsiElements(TAG_BIT_SET, ARRAY_FACTORY);
        if (psiDocTagArray == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(1);
        }
        return psiDocTagArray;
    }

    @Override
    public PsiDocTag findTagByName(String name) {
        if (this.getFirstChildNode().getElementType() == JavaDocElementType.DOC_COMMENT && !this.getFirstChildNode().getText().contains(name)) {
            return null;
        }
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiDocTag tag;
            CharSequence nameText;
            if (child.getElementType() != DOC_TAG || (nameText = ((LeafElement)((Object)(tag = (PsiDocTag)SourceTreeToPsiMap.treeToPsiNotNull(child)).getNameElement())).getChars()).length() <= 0 || nameText.charAt(0) != '@' || !CharArrayUtil.regionMatches(nameText, 1, name)) continue;
            return tag;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiDocTag[] findTagsByName(String name) {
        ArrayList<PsiDocTag> array = new ArrayList<PsiDocTag>();
        name = "@" + name;
        for (PsiDocTag tag : this.getTags()) {
            if (!tag.getNameElement().getText().equals(name)) continue;
            array.add(tag);
        }
        PsiDocTag[] psiDocTagArray = array.toArray(PsiDocTag.EMPTY_ARRAY);
        if (psiDocTagArray == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(2);
        }
        return psiDocTagArray;
    }

    @Override
    public IElementType getTokenType() {
        return this.getElementType();
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 110: {
                return this.getFirstChildNode();
            }
            case 111: {
                TreeElement lastNode = this.getLastChildNode();
                return lastNode.getElementType() == DOC_COMMENT_END ? lastNode : null;
            }
        }
        return null;
    }

    private static boolean isWhitespaceCommentData(ASTNode docCommentData) {
        return WS_PATTERN.matcher(docCommentData.getText()).matches();
    }

    private static void addNewLineToTag(CompositeElement tag, Project project, PsiManager manager) {
        ASTNode current;
        LOG.assertTrue(tag != null && tag.getElementType() == DOC_TAG);
        for (current = tag.getLastChildNode(); current != null && current.getElementType() == DOC_COMMENT_DATA && PsiDocCommentImpl.isWhitespaceCommentData(current); current = current.getTreePrev()) {
        }
        if (current != null && current.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
            return;
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree(tag);
        if (JavaCodeStyleSettingsFacade.getInstance(project).isJavaDocLeadingAsterisksEnabled()) {
            tag.addChild(Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n ", charTable, manager));
            tag.addChild(Factory.createSingleLeafElement(DOC_COMMENT_LEADING_ASTERISKS, "*", charTable, manager));
            tag.addChild(Factory.createSingleLeafElement(DOC_COMMENT_DATA, " ", charTable, manager));
        } else {
            tag.addChild(Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n ", charTable, manager));
        }
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        boolean needToAddNewline = false;
        if (first == last && first.getElementType() == DOC_TAG) {
            if (anchor == null) {
                anchor = this.getLastChildNode();
                ASTNode prevBeforeWS = TreeUtil.skipElementsBack(anchor.getTreePrev(), ElementType.JAVA_WHITESPACE_BIT_SET);
                if (prevBeforeWS != null) {
                    anchor = prevBeforeWS;
                    before = Boolean.FALSE;
                } else {
                    before = Boolean.TRUE;
                }
                needToAddNewline = true;
            }
            if (anchor.getElementType() != DOC_TAG) {
                if (PsiDocCommentImpl.nodeOnSameLineWithCommentStartBlock(anchor) || !PsiDocCommentImpl.nodeIsNextAfterAsterisks(anchor) || !PsiDocCommentImpl.docTagEndsWithLineFeedAndAsterisks(first)) {
                    CharTable charTable = SharedImplUtil.findCharTableByTree(this);
                    PsiManager psiManager = this.getManager();
                    if (JavaCodeStyleSettingsFacade.getInstance(this.getProject()).isJavaDocLeadingAsterisksEnabled()) {
                        LeafElement newLine = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n ", charTable, psiManager);
                        LeafElement leadingAsterisk = Factory.createSingleLeafElement(DOC_COMMENT_LEADING_ASTERISKS, "*", charTable, psiManager);
                        LeafElement commentData = Factory.createSingleLeafElement(DOC_COMMENT_DATA, " ", charTable, psiManager);
                        newLine.getTreeParent().addChild(leadingAsterisk);
                        newLine.getTreeParent().addChild(commentData);
                        super.addInternal(newLine, commentData, anchor, Boolean.FALSE);
                        anchor = commentData;
                    } else {
                        LeafElement newLine = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n ", charTable, psiManager);
                        anchor = super.addInternal(newLine, newLine, anchor, Boolean.FALSE);
                    }
                    before = Boolean.FALSE;
                }
            } else {
                needToAddNewline = true;
            }
        }
        if (before.booleanValue()) {
            anchor.getTreeParent().addChildren(first, last.getTreeNext(), anchor);
        } else {
            anchor.getTreeParent().addChildren(first, last.getTreeNext(), anchor.getTreeNext());
        }
        if (needToAddNewline) {
            if (first.getTreePrev() != null && first.getTreePrev().getElementType() == DOC_TAG) {
                PsiDocCommentImpl.addNewLineToTag((CompositeElement)first.getTreePrev(), this.getProject(), this.getManager());
            }
            if (first.getTreeNext() != null && first.getTreeNext().getElementType() == DOC_TAG) {
                PsiDocCommentImpl.addNewLineToTag((CompositeElement)first, this.getProject(), this.getManager());
            } else {
                PsiDocCommentImpl.removeEndingAsterisksFromTag((CompositeElement)first);
            }
        }
        return first;
    }

    private static void removeEndingAsterisksFromTag(CompositeElement tag) {
        ASTNode current;
        for (current = tag.getLastChildNode(); current != null && current.getElementType() == DOC_COMMENT_DATA; current = current.getTreePrev()) {
        }
        if (current != null && current.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
            ASTNode prevWhiteSpace = TreeUtil.skipElementsBack(current.getTreePrev(), ElementType.JAVA_WHITESPACE_BIT_SET);
            assert (prevWhiteSpace != null);
            ASTNode toBeDeleted = prevWhiteSpace.getTreeNext();
            while (toBeDeleted != null) {
                ASTNode next = toBeDeleted.getTreeNext();
                tag.deleteChildInternal(toBeDeleted);
                toBeDeleted = next;
            }
        }
    }

    private static boolean nodeIsNextAfterAsterisks(@NotNull ASTNode node) {
        ASTNode current;
        if (node == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(3);
        }
        if ((current = TreeUtil.findSiblingBackward(node, DOC_COMMENT_LEADING_ASTERISKS)) == null || current == node) {
            return false;
        }
        while (current.getTreeNext() != node) {
            CharSequence currentText = (current = current.getTreeNext()).getChars();
            if (CharArrayUtil.shiftForward(currentText, 0, " \t") == currentText.length()) continue;
            return false;
        }
        return true;
    }

    private static boolean docTagEndsWithLineFeedAndAsterisks(@NotNull ASTNode node) {
        if (node == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(4);
        }
        assert (node.getElementType() == DOC_TAG);
        ASTNode lastAsterisks = TreeUtil.findChildBackward(node, DOC_COMMENT_LEADING_ASTERISKS);
        if (lastAsterisks == null || !lastAsterisks.getTreePrev().textContains('\n')) {
            return false;
        }
        ASTNode last = node.getLastChildNode();
        ASTNode current = lastAsterisks;
        while (current != last) {
            CharSequence currentText = (current = current.getTreeNext()).getChars();
            if (CharArrayUtil.shiftForward(currentText, 0, " \t") == currentText.length()) continue;
            return false;
        }
        return true;
    }

    private static boolean nodeOnSameLineWithCommentStartBlock(@NotNull ASTNode node) {
        ASTNode current;
        if (node == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(5);
        }
        if ((current = TreeUtil.findSiblingBackward(node, DOC_COMMENT_START)) == null) {
            return false;
        }
        if (current == node) {
            return true;
        }
        while (current.getTreeNext() != node) {
            if (!(current = current.getTreeNext()).textContains('\n')) continue;
            return false;
        }
        return true;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(6);
        }
        if (child.getElementType() == DOC_TAG && (child.getTreeNext() == null || child.getTreeNext().getElementType() != DOC_TAG)) {
            ASTNode next;
            ASTNode prev;
            for (prev = child.getTreePrev(); prev != null && prev.getElementType() == DOC_COMMENT_DATA; prev = prev.getTreePrev()) {
            }
            for (next = child.getTreeNext(); next != null && (next.getElementType() == DOC_COMMENT_DATA || next.getElementType() == WHITE_SPACE); next = next.getTreeNext()) {
            }
            if (prev != null && prev.getElementType() == DOC_COMMENT_LEADING_ASTERISKS && !(next instanceof PsiDocTag)) {
                if (prev.getTreePrev() != null) {
                    super.deleteChildInternal(prev.getTreePrev());
                    super.deleteChildInternal(prev);
                }
            } else if (prev != null && prev.getElementType() == DOC_TAG) {
                ASTNode prevChild;
                CompositeElement compositePrev = (CompositeElement)prev;
                for (prevChild = compositePrev.getLastChildNode(); prevChild != null && prevChild.getElementType() == DOC_COMMENT_DATA; prevChild = prevChild.getTreePrev()) {
                }
                if (prevChild != null && prevChild.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
                    ASTNode current = prevChild;
                    while (current != null) {
                        ASTNode nextChild = current.getTreeNext();
                        compositePrev.deleteChildInternal(current);
                        current = nextChild;
                    }
                }
            } else {
                next = child.getTreeNext();
                if (next != null && next.getElementType() == WHITE_SPACE) {
                    next.getTreeParent().removeChild(next);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == DOC_TAG) {
            return 104;
        }
        if (i == JavaDocElementType.DOC_COMMENT || i == DOC_INLINE_TAG) {
            return 106;
        }
        if (i == DOC_COMMENT_LEADING_ASTERISKS) {
            return 107;
        }
        if (i == DOC_COMMENT_START) {
            return 110;
        }
        if (i == DOC_COMMENT_END) {
            return 111;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(7);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocComment(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiDocComment";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findTagsByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nodeIsNextAfterAsterisks";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "docTagEndsWithLineFeedAndAsterisks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nodeOnSameLineWithCommentStartBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

