/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StateMerger {
    public static final int MAX_RANGE_STATES = 100;
    private static final int COMPLEXITY_LIMIT = 250000;
    private final Map<DfaMemoryStateImpl, Set<Fact>> myFacts = ContainerUtil.newIdentityHashMap();
    private final Map<DfaMemoryState, Map<DfaVariableValue, DfaMemoryStateImpl>> myCopyCache = ContainerUtil.newIdentityHashMap();

    StateMerger() {
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByFacts(@NotNull List<DfaMemoryStateImpl> states) {
        if (states == null) {
            StateMerger.$$$reportNull$$$0(0);
        }
        MultiMap<Fact, DfaMemoryStateImpl> statesByFact = this.createFactToStateMap(states);
        Set<Fact> facts = statesByFact.keySet();
        int complexity = 0;
        for (Fact fact : facts) {
            Collection<DfaMemoryStateImpl> positiveStates;
            Collection<DfaMemoryStateImpl> negativeStates;
            if (fact.myPositive || (negativeStates = statesByFact.get(fact)).size() == states.size() || (positiveStates = statesByFact.get(fact.getPositiveCounterpart())).isEmpty()) continue;
            ProgressManager.checkCanceled();
            MultiMap<CompactFactSet, DfaMemoryStateImpl> statesByUnrelatedFacts1 = this.mapByUnrelatedFacts(fact, negativeStates, facts);
            MultiMap<CompactFactSet, DfaMemoryStateImpl> statesByUnrelatedFacts2 = this.mapByUnrelatedFacts(fact, positiveStates, facts);
            if ((complexity += StreamEx.of((Object[])new MultiMap[]{statesByUnrelatedFacts1, statesByUnrelatedFacts2}).flatCollection(MultiMap::keySet).mapToInt(CompactFactSet::size).sum()) > 250000) {
                return null;
            }
            Replacements replacements = new Replacements(states);
            for (Map.Entry<CompactFactSet, Collection<DfaMemoryStateImpl>> entry : statesByUnrelatedFacts1.entrySet()) {
                Collection<DfaMemoryStateImpl> group1 = entry.getValue();
                Collection<DfaMemoryStateImpl> group2 = statesByUnrelatedFacts2.get(entry.getKey());
                if (group1.isEmpty() || group2.isEmpty()) continue;
                ArrayList<DfaMemoryStateImpl> group = ContainerUtil.newArrayList(ContainerUtil.concat(group1, group2));
                Set<DfaVariableValue> unknowns = StateMerger.getAllUnknownVariables(group);
                replacements.stripAndMerge(group, original -> {
                    DfaMemoryStateImpl copy = StateMerger.withUnknownVariables(original, unknowns);
                    fact.removeFromState(copy);
                    if (fact instanceof EqualityFact) {
                        this.restoreOtherInequalities((EqualityFact)fact, group, copy);
                    }
                    return copy;
                });
            }
            if (!replacements.hasMerges()) continue;
            return replacements.getMergeResult();
        }
        return null;
    }

    @NotNull
    private MultiMap<Fact, DfaMemoryStateImpl> createFactToStateMap(@NotNull List<DfaMemoryStateImpl> states) {
        if (states == null) {
            StateMerger.$$$reportNull$$$0(1);
        }
        MultiMap<Fact, DfaMemoryStateImpl> statesByFact = MultiMap.createLinked();
        HashMap<DfaConstValue, Map<DfaVariableValue, Set<DfaMemoryStateImpl>>> constantVars = new HashMap<DfaConstValue, Map<DfaVariableValue, Set<DfaMemoryStateImpl>>>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            for (Fact fact : this.getFacts(state)) {
                statesByFact.putValue(fact, state);
                DfaConstValue value = fact.comparedToConstant();
                if (value == null) continue;
                constantVars.computeIfAbsent(value, k -> new HashMap()).computeIfAbsent(fact.myVar, k -> ContainerUtil.newIdentityTroveSet()).add(state);
            }
        }
        for (Fact fact : new ArrayList(statesByFact.keySet())) {
            if (fact.myPositive) continue;
            Collection<DfaMemoryStateImpl> negativeStates = statesByFact.get(fact);
            Collection<DfaMemoryStateImpl> positiveStates = statesByFact.get(fact.getPositiveCounterpart());
            if (!StateMerger.isComparisonOfVariablesComparedWithConstant(fact, constantVars, positiveStates, negativeStates)) continue;
            statesByFact.remove(fact);
            statesByFact.remove(fact.getPositiveCounterpart());
        }
        MultiMap<Fact, DfaMemoryStateImpl> multiMap = statesByFact;
        if (multiMap == null) {
            StateMerger.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    private static boolean isComparisonOfVariablesComparedWithConstant(Fact fact, Map<DfaConstValue, Map<DfaVariableValue, Set<DfaMemoryStateImpl>>> constantVars, Collection<DfaMemoryStateImpl> positiveStates, Collection<DfaMemoryStateImpl> negativeStates) {
        if (!(fact instanceof EqualityFact) || !(((EqualityFact)fact).myArg instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var1 = fact.myVar;
        DfaVariableValue var2 = (DfaVariableValue)((EqualityFact)fact).myArg;
        for (Map<DfaVariableValue, Set<DfaMemoryStateImpl>> map : constantVars.values()) {
            Set<DfaMemoryStateImpl> states1 = map.get(var1);
            Set<DfaMemoryStateImpl> states2 = map.get(var2);
            if (states1 == null || states2 == null || !states1.containsAll(negativeStates) || !states1.containsAll(positiveStates) || !states2.containsAll(negativeStates) || !states2.containsAll(positiveStates)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private MultiMap<CompactFactSet, DfaMemoryStateImpl> mapByUnrelatedFacts(@NotNull Fact fact, @NotNull Collection<DfaMemoryStateImpl> states, @NotNull Set<Fact> interestingFacts) {
        if (fact == null) {
            StateMerger.$$$reportNull$$$0(3);
        }
        if (states == null) {
            StateMerger.$$$reportNull$$$0(4);
        }
        if (interestingFacts == null) {
            StateMerger.$$$reportNull$$$0(5);
        }
        MultiMap<CompactFactSet, DfaMemoryStateImpl> statesByUnrelatedFacts = MultiMap.createLinked();
        for (DfaMemoryStateImpl state : states) {
            statesByUnrelatedFacts.putValue(this.getUnrelatedFacts(fact, state, interestingFacts), state);
        }
        MultiMap<CompactFactSet, DfaMemoryStateImpl> multiMap = statesByUnrelatedFacts;
        if (multiMap == null) {
            StateMerger.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    @NotNull
    private CompactFactSet getUnrelatedFacts(@NotNull Fact fact, @NotNull DfaMemoryStateImpl state, @NotNull Set<Fact> interestingFacts) {
        if (fact == null) {
            StateMerger.$$$reportNull$$$0(7);
        }
        if (state == null) {
            StateMerger.$$$reportNull$$$0(8);
        }
        if (interestingFacts == null) {
            StateMerger.$$$reportNull$$$0(9);
        }
        ArrayList<Fact> result2 = new ArrayList<Fact>();
        for (Fact other : this.getFacts(state)) {
            if (fact.invalidatesFact(other) || !interestingFacts.contains(other)) continue;
            result2.add(other);
        }
        CompactFactSet compactFactSet = new CompactFactSet(state.getFactory(), result2);
        if (compactFactSet == null) {
            StateMerger.$$$reportNull$$$0(10);
        }
        return compactFactSet;
    }

    private void restoreOtherInequalities(@NotNull EqualityFact removedFact, @NotNull Collection<DfaMemoryStateImpl> mergedGroup, @NotNull DfaMemoryStateImpl state) {
        if (removedFact == null) {
            StateMerger.$$$reportNull$$$0(11);
        }
        if (mergedGroup == null) {
            StateMerger.$$$reportNull$$$0(12);
        }
        if (state == null) {
            StateMerger.$$$reportNull$$$0(13);
        }
        Set<DfaConstValue> inequalitiesToRestore = null;
        for (DfaMemoryStateImpl member : mergedGroup) {
            Set<Fact> memberFacts = this.getFacts(member);
            if (!memberFacts.contains(removedFact)) continue;
            Set<DfaConstValue> otherInequalities = StateMerger.getOtherInequalities(removedFact, memberFacts, member);
            if (inequalitiesToRestore == null) {
                inequalitiesToRestore = otherInequalities;
                continue;
            }
            inequalitiesToRestore.retainAll(otherInequalities);
        }
        if (inequalitiesToRestore != null) {
            DfaRelationValue.Factory relationFactory = state.getFactory().getRelationFactory();
            for (DfaConstValue toRestore : inequalitiesToRestore) {
                state.applyCondition(relationFactory.createRelation(removedFact.myVar, DfaRelationValue.RelationType.NE, toRestore));
            }
        }
    }

    @NotNull
    private static Set<DfaConstValue> getOtherInequalities(@NotNull EqualityFact removedFact, @NotNull Set<Fact> memberFacts, @NotNull DfaMemoryStateImpl state) {
        if (removedFact == null) {
            StateMerger.$$$reportNull$$$0(14);
        }
        if (memberFacts == null) {
            StateMerger.$$$reportNull$$$0(15);
        }
        if (state == null) {
            StateMerger.$$$reportNull$$$0(16);
        }
        LinkedHashSet<DfaConstValue> otherInequalities = ContainerUtil.newLinkedHashSet();
        HashSet<DfaValue> eqValues = ContainerUtil.newHashSet(state.getEquivalentValues(removedFact.myArg));
        for (Fact candidate : memberFacts) {
            if (!(candidate instanceof EqualityFact)) continue;
            EqualityFact equality = (EqualityFact)candidate;
            if (equality.myPositive || equality.myVar != removedFact.myVar || !(equality.myArg instanceof DfaConstValue) || eqValues.contains(equality.myArg)) continue;
            otherInequalities.add((DfaConstValue)equality.myArg);
        }
        LinkedHashSet<DfaConstValue> linkedHashSet = otherInequalities;
        if (linkedHashSet == null) {
            StateMerger.$$$reportNull$$$0(17);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<DfaVariableValue> getAllUnknownVariables(@NotNull Collection<DfaMemoryStateImpl> complementary) {
        if (complementary == null) {
            StateMerger.$$$reportNull$$$0(18);
        }
        LinkedHashSet<DfaVariableValue> toFlush = ContainerUtil.newLinkedHashSet();
        for (DfaMemoryStateImpl removedState : complementary) {
            toFlush.addAll(removedState.getUnknownVariables());
        }
        LinkedHashSet<DfaVariableValue> linkedHashSet = toFlush;
        if (linkedHashSet == null) {
            StateMerger.$$$reportNull$$$0(19);
        }
        return linkedHashSet;
    }

    @NotNull
    private static DfaMemoryStateImpl withUnknownVariables(@NotNull DfaMemoryStateImpl original, @NotNull Set<DfaVariableValue> toFlush) {
        if (original == null) {
            StateMerger.$$$reportNull$$$0(20);
        }
        if (toFlush == null) {
            StateMerger.$$$reportNull$$$0(21);
        }
        DfaMemoryStateImpl copy = original.createCopy();
        for (DfaVariableValue value : toFlush) {
            copy.doFlush(value, true);
        }
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            StateMerger.$$$reportNull$$$0(22);
        }
        return dfaMemoryStateImpl;
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByUnknowns(@NotNull List<DfaMemoryStateImpl> states) {
        if (states == null) {
            StateMerger.$$$reportNull$$$0(23);
        }
        MultiMap<Integer, DfaMemoryStateImpl> byHash = new MultiMap<Integer, DfaMemoryStateImpl>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            byHash.putValue(state.getPartialHashCode(false, true), state);
        }
        Replacements replacements = new Replacements(states);
        block1: for (Integer key : byHash.keySet()) {
            Collection similarStates = byHash.get(key);
            if (similarStates.size() < 2) continue;
            for (DfaMemoryStateImpl state1 : similarStates) {
                ProgressManager.checkCanceled();
                List<DfaMemoryStateImpl> complementary = ContainerUtil.filter(similarStates, state2 -> state1.equalsByRelations((DfaMemoryStateImpl)state2) && state1.equalsByVariableStates((DfaMemoryStateImpl)state2));
                if (!StateMerger.mergeUnknowns(replacements, complementary)) continue;
                continue block1;
            }
        }
        return replacements.getMergeResult();
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByNullability(List<DfaMemoryStateImpl> states) {
        MultiMap<Integer, DfaMemoryStateImpl> byHash = new MultiMap<Integer, DfaMemoryStateImpl>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            byHash.putValue(state.getPartialHashCode(false, false), state);
        }
        Replacements replacements = new Replacements(states);
        block1: for (Integer key : byHash.keySet()) {
            Collection similarStates = byHash.get(key);
            if (similarStates.size() < 2) continue;
            for (DfaMemoryStateImpl state1 : similarStates) {
                ProgressManager.checkCanceled();
                for (DfaVariableValue var : state1.getChangedVariables()) {
                    List<DfaMemoryStateImpl> complementary;
                    if (state1.getVariableState(var).getNullability() != Nullness.NULLABLE || !StateMerger.mergeUnknowns(replacements, complementary = ContainerUtil.filter(similarStates, state2 -> state1.equalsByRelations((DfaMemoryStateImpl)state2) && this.areEquivalentModuloVar(state1, (DfaMemoryStateImpl)state2, var) && StateMerger.areVarStatesEqualModuloNullability(state1, state2, var)))) continue;
                    continue block1;
                }
            }
        }
        return replacements.getMergeResult();
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByRanges(List<DfaMemoryStateImpl> states) {
        List<DfaMemoryStateImpl> merged;
        Map<DfaVariableValue, Map<LongRangeSet, LongRangeSet>> ranges = StateMerger.createRangeMap(states);
        boolean changed = false;
        for (Map<LongRangeSet, LongRangeSet> map : ranges.values()) {
            for (Map.Entry<LongRangeSet, LongRangeSet> entry : map.entrySet()) {
                for (LongRangeSet candidate : map.values()) {
                    if (entry.getValue().equals(candidate) || !candidate.contains(entry.getValue())) continue;
                    entry.setValue(candidate);
                    changed = true;
                }
            }
        }
        if (changed) {
            changed = false;
            for (DfaMemoryStateImpl state : states) {
                for (Map.Entry<Object, Object> entry : ranges.entrySet()) {
                    LongRangeSet boundingRange;
                    DfaVariableState variableState = state.getVariableState((DfaVariableValue)entry.getKey());
                    LongRangeSet range = variableState.getFact(DfaFactType.RANGE);
                    if (range != null && !range.isEmpty() && range.max() == range.min() || (boundingRange = (LongRangeSet)((Map)entry.getValue()).get(range)) == null || boundingRange.equals(range)) continue;
                    state.setFact((DfaValue)entry.getKey(), DfaFactType.RANGE, boundingRange);
                    changed = true;
                }
            }
            if (changed) {
                return new ArrayList<DfaMemoryStateImpl>(new LinkedHashSet<DfaMemoryStateImpl>(states));
            }
        }
        if ((merged = this.mergeIndependentRanges(states, ranges)) != null) {
            return merged;
        }
        return StateMerger.dropExcessRangeInfo(states, ranges.keySet());
    }

    @NotNull
    private static Map<DfaVariableValue, Map<LongRangeSet, LongRangeSet>> createRangeMap(List<DfaMemoryStateImpl> states) {
        LinkedHashMap<DfaVariableValue, Map<LongRangeSet, LongRangeSet>> ranges = new LinkedHashMap<DfaVariableValue, Map<LongRangeSet, LongRangeSet>>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            state.forVariableStates((varValue, varState) -> {
                LongRangeSet range = varState.getFact(DfaFactType.RANGE);
                if (range != null) {
                    ranges.computeIfAbsent((DfaVariableValue)varValue, k -> new HashMap()).put(range, range);
                }
            });
        }
        LinkedHashMap<DfaVariableValue, Map<LongRangeSet, LongRangeSet>> linkedHashMap = ranges;
        if (linkedHashMap == null) {
            StateMerger.$$$reportNull$$$0(24);
        }
        return linkedHashMap;
    }

    @Nullable
    private List<DfaMemoryStateImpl> mergeIndependentRanges(List<DfaMemoryStateImpl> states, Map<DfaVariableValue, Map<LongRangeSet, LongRangeSet>> ranges) {
        boolean changed = false;
        for (Map.Entry<DfaVariableValue, Map<LongRangeSet, LongRangeSet>> entry : ranges.entrySet()) {
            List<DfaMemoryStateImpl> updated;
            if (entry.getValue().size() <= 1 || (updated = this.mergeIndependentRanges(states, entry.getKey())) == null) continue;
            states = updated;
            changed = true;
        }
        return changed ? states : null;
    }

    @Nullable
    private List<DfaMemoryStateImpl> mergeIndependentRanges(List<DfaMemoryStateImpl> states, DfaVariableValue var) {
        ProgressManager.checkCanceled();
        class Record {
            final DfaMemoryStateImpl myState;
            final LongRangeSet myRange;
            final Set<EqualityFact> myCommonEqualities;
            final /* synthetic */ DfaVariableValue val$var;
            final /* synthetic */ StateMerger this$0;

            Record(DfaMemoryStateImpl state, LongRangeSet range, Set<EqualityFact> commonEqualities) {
                this.this$0 = this$0;
                this.val$var = var5_5;
                this.myState = state;
                this.myRange = range;
                this.myCommonEqualities = commonEqualities;
            }

            Set<EqualityFact> getEqualityFacts() {
                return ((StreamEx)StreamEx.of((Collection)this.this$0.getFacts(this.myState)).select(EqualityFact.class).filter(fact -> fact.myVar == this.val$var || ((EqualityFact)fact).myArg == this.val$var)).toSet();
            }

            Record union(Record other) {
                Set<EqualityFact> equalities = this.myCommonEqualities == null ? this.getEqualityFacts() : this.myCommonEqualities;
                equalities.retainAll(other.getEqualityFacts());
                return new Record(this.this$0, this.myState, this.myRange.union(other.myRange), equalities, this.val$var);
            }

            DfaMemoryStateImpl getState() {
                if (this.myCommonEqualities != null) {
                    this.myState.flushVariable(this.val$var);
                    this.myState.setFact(this.val$var, DfaFactType.RANGE, this.myRange);
                    for (EqualityFact equality : this.myCommonEqualities) {
                        equality.applyTo(this.myState);
                    }
                }
                return this.myState;
            }
        }
        LinkedHashMap<DfaMemoryStateImpl, Record> merged = new LinkedHashMap<DfaMemoryStateImpl, Record>();
        for (DfaMemoryStateImpl state : states) {
            DfaVariableState variableState = state.getVariableState(var);
            LongRangeSet range = variableState.getFact(DfaFactType.RANGE);
            if (range == null && (range = LongRangeSet.fromType(var.getVariableType())) == null) {
                return null;
            }
            merged.merge(this.copyWithoutVar(state, var), new Record(this, state, range, null, var), Record::union);
        }
        return merged.size() == states.size() ? null : StreamEx.ofValues(merged).map(Record::getState).toList();
    }

    @Nullable
    private static List<DfaMemoryStateImpl> dropExcessRangeInfo(List<DfaMemoryStateImpl> states, Set<DfaVariableValue> rangeVariables) {
        if (states.size() <= 100 || rangeVariables.isEmpty()) {
            return null;
        }
        DfaVariableValue lastVar = Collections.max(rangeVariables, Comparator.comparingInt(DfaValue::getID));
        for (DfaMemoryStateImpl state : states) {
            state.setFact(lastVar, DfaFactType.RANGE, null);
        }
        return new ArrayList<DfaMemoryStateImpl>(new HashSet<DfaMemoryStateImpl>(states));
    }

    private static boolean mergeUnknowns(@NotNull Replacements replacements, @NotNull List<DfaMemoryStateImpl> complementary) {
        if (replacements == null) {
            StateMerger.$$$reportNull$$$0(25);
        }
        if (complementary == null) {
            StateMerger.$$$reportNull$$$0(26);
        }
        if (complementary.size() < 2) {
            return false;
        }
        Set<DfaVariableValue> toFlush = StateMerger.getAllUnknownVariables(complementary);
        if (toFlush.isEmpty()) {
            return false;
        }
        return replacements.stripAndMerge(complementary, original -> StateMerger.withUnknownVariables(original, toFlush));
    }

    private boolean areEquivalentModuloVar(@NotNull DfaMemoryStateImpl state1, @NotNull DfaMemoryStateImpl state2, @NotNull DfaVariableValue var) {
        if (state1 == null) {
            StateMerger.$$$reportNull$$$0(27);
        }
        if (state2 == null) {
            StateMerger.$$$reportNull$$$0(28);
        }
        if (var == null) {
            StateMerger.$$$reportNull$$$0(29);
        }
        DfaMemoryStateImpl copy1 = this.copyWithoutVar(state1, var);
        DfaMemoryStateImpl copy2 = this.copyWithoutVar(state2, var);
        return copy2.equalsByRelations(copy1) && copy2.equalsByVariableStates(copy1);
    }

    @NotNull
    private DfaMemoryStateImpl copyWithoutVar(@NotNull DfaMemoryStateImpl state, @NotNull DfaVariableValue var) {
        Map map;
        DfaMemoryStateImpl copy;
        if (state == null) {
            StateMerger.$$$reportNull$$$0(30);
        }
        if (var == null) {
            StateMerger.$$$reportNull$$$0(31);
        }
        if ((copy = (DfaMemoryStateImpl)(map = this.myCopyCache.computeIfAbsent(state, k -> ContainerUtil.newIdentityHashMap())).get(var)) == null) {
            copy = state.createCopy();
            copy.flushVariable(var);
            map.put(var, copy);
        }
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            StateMerger.$$$reportNull$$$0(32);
        }
        return dfaMemoryStateImpl;
    }

    private static boolean areVarStatesEqualModuloNullability(@NotNull DfaMemoryStateImpl state1, @NotNull DfaMemoryStateImpl state2, @NotNull DfaVariableValue var) {
        if (state1 == null) {
            StateMerger.$$$reportNull$$$0(33);
        }
        if (state2 == null) {
            StateMerger.$$$reportNull$$$0(34);
        }
        if (var == null) {
            StateMerger.$$$reportNull$$$0(35);
        }
        return state1.getVariableState(var).withoutFact(DfaFactType.CAN_BE_NULL).equals(state2.getVariableState(var).withoutFact(DfaFactType.CAN_BE_NULL));
    }

    @NotNull
    private Set<Fact> getFacts(@NotNull DfaMemoryStateImpl state) {
        if (state == null) {
            StateMerger.$$$reportNull$$$0(36);
        }
        Set set = this.myFacts.computeIfAbsent(state, StateMerger::doGetFacts);
        if (set == null) {
            StateMerger.$$$reportNull$$$0(37);
        }
        return set;
    }

    @NotNull
    private static Set<Fact> doGetFacts(DfaMemoryStateImpl state) {
        LinkedHashSet<Fact> result2 = ContainerUtil.newLinkedHashSet();
        IdentityHashMap<EqClass, EqClassInfo> classInfo = new IdentityHashMap<EqClass, EqClassInfo>();
        for (EqClass eqClass : state.getNonTrivialEqClasses()) {
            EqClassInfo info = classInfo.computeIfAbsent(eqClass, EqClassInfo::new);
            DfaValue constant = info.constant;
            List<DfaVariableValue> vars = info.vars;
            int size = vars.size();
            for (int i = 0; i < size; ++i) {
                DfaVariableValue var2 = vars.get(i);
                if (constant != null) {
                    result2.add(Fact.createEqualityFact(var2, constant));
                }
                for (int j = i + 1; j < size; ++j) {
                    DfaVariableValue eqVar = vars.get(j);
                    result2.add(Fact.createEqualityFact(var2, eqVar));
                }
            }
        }
        for (DistinctPairSet.DistinctPair classPair : state.getDistinctClassPairs()) {
            EqClassInfo info1 = classInfo.computeIfAbsent(classPair.getFirst(), EqClassInfo::new);
            EqClassInfo info2 = classInfo.computeIfAbsent(classPair.getSecond(), EqClassInfo::new);
            for (DfaVariableValue var1 : info1.vars) {
                for (DfaVariableValue var2 : info2.vars) {
                    result2.add(new EqualityFact(var1, false, var2));
                    result2.add(new EqualityFact(var2, false, var1));
                }
            }
            if (info1.constant != null) {
                for (DfaVariableValue var2 : info2.vars) {
                    result2.add(new EqualityFact(var2, false, info1.constant));
                }
            }
            if (info2.constant == null) continue;
            for (DfaVariableValue var1 : info1.vars) {
                result2.add(new EqualityFact(var1, false, info2.constant));
            }
        }
        state.forVariableStates((var, variableState) -> {
            TypeConstraint typeConstraint = variableState.getTypeConstraint();
            for (DfaPsiType type : typeConstraint.getInstanceofValues()) {
                result2.add(new InstanceofFact((DfaVariableValue)var, true, type));
            }
            for (DfaPsiType type : typeConstraint.getNotInstanceofValues()) {
                result2.add(new InstanceofFact((DfaVariableValue)var, false, type));
            }
        });
        LinkedHashSet<Fact> linkedHashSet = result2;
        if (linkedHashSet == null) {
            StateMerger.$$$reportNull$$$0(38);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 32: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 32: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 32: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StateMerger";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fact";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interestingFacts";
                break;
            }
            case 8: 
            case 13: 
            case 16: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedFact";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedGroup";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberFacts";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "complementary";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFlush";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state1";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state2";
                break;
            }
            case 29: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFactToStateMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "mapByUnrelatedFacts";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnrelatedFacts";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherInequalities";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUnknownVariables";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "withUnknownVariables";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMap";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithoutVar";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacts";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeByFacts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFactToStateMap";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 32: 
            case 37: 
            case 38: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mapByUnrelatedFacts";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnrelatedFacts";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "restoreOtherInequalities";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOtherInequalities";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllUnknownVariables";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withUnknownVariables";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mergeByUnknowns";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mergeUnknowns";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "areEquivalentModuloVar";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "copyWithoutVar";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "areVarStatesEqualModuloNullability";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 32: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class EqClassInfo {
        final List<DfaVariableValue> vars;
        final DfaValue constant;

        EqClassInfo(EqClass eqClass) {
            this.vars = eqClass.getVariables(false);
            this.constant = eqClass.findConstant(true);
        }
    }

    private static class Replacements {
        @NotNull
        private final List<DfaMemoryStateImpl> myAllStates;
        private final Set<DfaMemoryStateImpl> myRemovedStates;
        private final List<DfaMemoryStateImpl> myMerged;

        private Replacements(@NotNull List<DfaMemoryStateImpl> allStates) {
            if (allStates == null) {
                Replacements.$$$reportNull$$$0(0);
            }
            this.myRemovedStates = ContainerUtil.newIdentityTroveSet();
            this.myMerged = ContainerUtil.newArrayList();
            this.myAllStates = allStates;
        }

        private boolean hasMerges() {
            return !this.myMerged.isEmpty();
        }

        @Nullable
        private List<DfaMemoryStateImpl> getMergeResult() {
            if (this.hasMerges()) {
                ArrayList<DfaMemoryStateImpl> result2 = ContainerUtil.newArrayList(this.myMerged);
                for (DfaMemoryStateImpl state : this.myAllStates) {
                    if (this.myRemovedStates.contains(state)) continue;
                    result2.add(state);
                }
                return result2;
            }
            return null;
        }

        private boolean stripAndMerge(@NotNull Collection<DfaMemoryStateImpl> group, @NotNull Function<DfaMemoryStateImpl, DfaMemoryStateImpl> stripper) {
            if (group == null) {
                Replacements.$$$reportNull$$$0(1);
            }
            if (stripper == null) {
                Replacements.$$$reportNull$$$0(2);
            }
            if (group.size() <= 1) {
                return false;
            }
            MultiMap<DfaMemoryStateImpl, DfaMemoryStateImpl> strippedToOriginals = MultiMap.create();
            for (DfaMemoryStateImpl original : group) {
                strippedToOriginals.putValue(stripper.fun(original), original);
            }
            boolean hasMerges = false;
            for (Map.Entry entry : strippedToOriginals.entrySet()) {
                Collection merged = entry.getValue();
                if (merged.size() <= 1) continue;
                this.myRemovedStates.addAll(merged);
                this.myMerged.add((DfaMemoryStateImpl)entry.getKey());
                hasMerges = true;
            }
            return hasMerges;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allStates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stripper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger$Replacements";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stripAndMerge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class InstanceofFact
    extends Fact {
        @NotNull
        private final DfaPsiType myType;

        private InstanceofFact(@NotNull DfaVariableValue var, boolean positive, @NotNull DfaPsiType type) {
            if (var == null) {
                InstanceofFact.$$$reportNull$$$0(0);
            }
            if (type == null) {
                InstanceofFact.$$$reportNull$$$0(1);
            }
            super(positive, var, (var.hashCode() * 31 + type.hashCode()) * 31 + (positive ? 1 : 0));
            this.myType = type;
        }

        @Override
        int packHigh() {
            return -this.myType.getID();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InstanceofFact)) {
                return false;
            }
            InstanceofFact fact = (InstanceofFact)o;
            return this.myPositive == fact.myPositive && this.myType == fact.myType && this.myVar == fact.myVar;
        }

        public String toString() {
            return this.myVar + (this.myPositive ? " IS " : " IS NOT ") + this.myType;
        }

        @Override
        @NotNull
        Fact getPositiveCounterpart() {
            InstanceofFact instanceofFact = new InstanceofFact(this.myVar, true, this.myType);
            if (instanceofFact == null) {
                InstanceofFact.$$$reportNull$$$0(2);
            }
            return instanceofFact;
        }

        @Override
        boolean invalidatesFact(@NotNull Fact another) {
            if (another == null) {
                InstanceofFact.$$$reportNull$$$0(3);
            }
            return another instanceof InstanceofFact && this.myType == ((InstanceofFact)another).myType && InstanceofFact.normalize(this.myVar) == InstanceofFact.normalize(another.myVar);
        }

        @Override
        void removeFromState(@NotNull DfaMemoryStateImpl state) {
            if (state == null) {
                InstanceofFact.$$$reportNull$$$0(4);
            }
            DfaVariableState varState = state.getVariableState(this.myVar);
            state.setVariableState(this.myVar, varState.withoutType(this.myType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/StateMerger$InstanceofFact";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger$InstanceofFact";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPositiveCounterpart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invalidatesFact";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFromState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class EqualityFact
    extends Fact {
        @NotNull
        private final DfaValue myArg;

        private EqualityFact(@NotNull DfaVariableValue var, boolean positive, @NotNull DfaValue arg) {
            if (var == null) {
                EqualityFact.$$$reportNull$$$0(0);
            }
            if (arg == null) {
                EqualityFact.$$$reportNull$$$0(1);
            }
            super(positive, var, (var.hashCode() * 31 + arg.hashCode()) * 31 + (positive ? 1 : 0));
            this.myArg = arg;
        }

        @Override
        int packHigh() {
            return this.myArg.getID();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EqualityFact)) {
                return false;
            }
            EqualityFact fact = (EqualityFact)o;
            return this.myArg == fact.myArg && this.myVar == fact.myVar && this.myPositive == fact.myPositive;
        }

        public String toString() {
            return this.myVar + (this.myPositive ? " EQ " : " NE ") + this.myArg;
        }

        @Override
        DfaConstValue comparedToConstant() {
            return this.myArg instanceof DfaConstValue ? (DfaConstValue)this.myArg : null;
        }

        @Override
        @NotNull
        EqualityFact getPositiveCounterpart() {
            EqualityFact equalityFact = new EqualityFact(this.myVar, true, this.myArg);
            if (equalityFact == null) {
                EqualityFact.$$$reportNull$$$0(2);
            }
            return equalityFact;
        }

        void applyTo(DfaMemoryStateImpl state) {
            state.applyCondition(state.getFactory().createCondition(this.myVar, this.myPositive ? DfaRelationValue.RelationType.EQ : DfaRelationValue.RelationType.NE, this.myArg));
        }

        @Override
        boolean invalidatesFact(@NotNull Fact another) {
            if (another == null) {
                EqualityFact.$$$reportNull$$$0(3);
            }
            if (!(another instanceof EqualityFact)) {
                return false;
            }
            DfaValue normalizedVar = EqualityFact.normalize(this.myVar);
            return normalizedVar == EqualityFact.normalize(another.myVar) || normalizedVar == EqualityFact.normalize(((EqualityFact)another).myArg);
        }

        @Override
        void removeFromState(@NotNull DfaMemoryStateImpl state) {
            if (state == null) {
                EqualityFact.$$$reportNull$$$0(4);
            }
            state.removeEquivalenceRelations(this.myVar);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arg";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/StateMerger$EqualityFact";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger$EqualityFact";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPositiveCounterpart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invalidatesFact";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFromState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class Fact {
        final boolean myPositive;
        @NotNull
        final DfaVariableValue myVar;
        private final int myHash;

        protected Fact(boolean positive, @NotNull DfaVariableValue var, int hash) {
            if (var == null) {
                Fact.$$$reportNull$$$0(0);
            }
            this.myPositive = positive;
            this.myVar = var;
            this.myHash = hash;
        }

        private int packLow() {
            return this.myPositive ? this.myVar.getID() : -this.myVar.getID();
        }

        abstract int packHigh();

        long pack() {
            int lo = this.packLow();
            int hi = this.packHigh();
            return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
        }

        public final int hashCode() {
            return this.myHash;
        }

        @NotNull
        abstract Fact getPositiveCounterpart();

        DfaConstValue comparedToConstant() {
            return null;
        }

        abstract boolean invalidatesFact(@NotNull Fact var1);

        abstract void removeFromState(@NotNull DfaMemoryStateImpl var1);

        @NotNull
        static EqualityFact createEqualityFact(@NotNull DfaVariableValue var, @NotNull DfaValue val) {
            if (var == null) {
                Fact.$$$reportNull$$$0(1);
            }
            if (val == null) {
                Fact.$$$reportNull$$$0(2);
            }
            if (val instanceof DfaVariableValue && val.getID() < var.getID()) {
                EqualityFact equalityFact = new EqualityFact((DfaVariableValue)val, true, var);
                if (equalityFact == null) {
                    Fact.$$$reportNull$$$0(3);
                }
                return equalityFact;
            }
            EqualityFact equalityFact = new EqualityFact(var, true, val);
            if (equalityFact == null) {
                Fact.$$$reportNull$$$0(4);
            }
            return equalityFact;
        }

        static DfaValue normalize(DfaValue value) {
            if (value instanceof DfaVariableValue && ((DfaVariableValue)value).isNegated()) {
                return ((DfaVariableValue)value).createNegated();
            }
            return value;
        }

        static Fact unpack(DfaValueFactory factory, long packed) {
            int lo = (int)(packed & 0xFFFFFFFFL);
            int hi = (int)(packed >> 32);
            boolean positive = lo >= 0;
            DfaVariableValue var = (DfaVariableValue)factory.getValue(Math.abs(lo));
            if (hi >= 0) {
                return new EqualityFact(var, positive, factory.getValue(hi));
            }
            return new InstanceofFact(var, positive, factory.getType(-hi));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/StateMerger$Fact";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger$Fact";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEqualityFact";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createEqualityFact";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class CompactFactSet {
        private final long[] myData;
        private final int myHashCode;
        private final DfaValueFactory myFactory;

        CompactFactSet(DfaValueFactory factory, Collection<Fact> facts) {
            this.myData = facts.stream().mapToLong(Fact::pack).toArray();
            Arrays.sort(this.myData);
            this.myHashCode = Arrays.hashCode(this.myData);
            this.myFactory = factory;
        }

        public int size() {
            return this.myData.length;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CompactFactSet)) {
                return false;
            }
            CompactFactSet other = (CompactFactSet)obj;
            return this.myHashCode == other.myHashCode && Arrays.equals(this.myData, other.myData);
        }

        public String toString() {
            return LongStreamEx.of((long[])this.myData).mapToObj(f -> Fact.unpack(this.myFactory, f)).joining((CharSequence)", ", (CharSequence)"{", (CharSequence)"}");
        }
    }
}

