/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.StringFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.JDOMInterner;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class JDOMUtil {
    private static final ThreadLocal<java.lang.ref.SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    private static final Condition<Attribute> NOT_EMPTY_VALUE_CONDITION = new Condition<Attribute>(){

        @Override
        public boolean value(Attribute attribute) {
            return !StringUtil.isEmpty(attribute.getValue());
        }
    };
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();
    private static final JDOMInterner ourJDOMInterner = new JDOMInterner();

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        List list = parent == null ? Collections.emptyList() : parent.getChildren();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (name == null) {
            JDOMUtil.$$$reportNull$$$0(1);
        }
        if (parent != null) {
            List list = parent.getChildren(name);
            if (list == null) {
                JDOMUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<Element> list = Collections.emptyList();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Comparing.equal(e1.getName(), e2.getName()) && JDOMUtil.isAttributesEqual(e1.getAttributes(), e2.getAttributes(), ignoreEmptyAttrValues) && JDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER), ignoreEmptyAttrValues);
    }

    public static int getTreeHash(@NotNull Element root) {
        if (root == null) {
            JDOMUtil.$$$reportNull$$$0(4);
        }
        return JDOMUtil.addToHash(0, root, true);
    }

    private static int addToHash(int i, @NotNull Element element, boolean skipEmptyText) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(5);
        }
        i = JDOMUtil.addToHash(i, element.getName());
        for (Attribute attribute : element.getAttributes()) {
            i = JDOMUtil.addToHash(i, attribute.getName());
            i = JDOMUtil.addToHash(i, attribute.getValue());
        }
        for (Content child : element.getContent()) {
            if (child instanceof Element) {
                i = JDOMUtil.addToHash(i, (Element)child, skipEmptyText);
                continue;
            }
            if (!(child instanceof Text)) continue;
            String text2 = ((Text)child).getText();
            if (skipEmptyText && StringUtil.isEmptyOrSpaces(text2)) continue;
            i = JDOMUtil.addToHash(i, text2);
        }
        return i;
    }

    private static int addToHash(int i, @NotNull String s) {
        if (s == null) {
            JDOMUtil.$$$reportNull$$$0(6);
        }
        return i * 31 + s.hashCode();
    }

    @Deprecated
    @NotNull
    public static Element[] getElements(@NotNull Element m) {
        if (m == null) {
            JDOMUtil.$$$reportNull$$$0(7);
        }
        List list = m.getChildren();
        Element[] elementArray = list.toArray(new Element[0]);
        if (elementArray == null) {
            JDOMUtil.$$$reportNull$$$0(8);
        }
        return elementArray;
    }

    public static void internStringsInElement(@NotNull Element element, @NotNull StringInterner interner) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(9);
        }
        if (interner == null) {
            JDOMUtil.$$$reportNull$$$0(10);
        }
        element.setName(interner.intern(element.getName()));
        for (Attribute attr : element.getAttributes()) {
            attr.setName(interner.intern(attr.getName()));
            attr.setValue(interner.intern(attr.getValue()));
        }
        for (Content o : element.getContent()) {
            if (o instanceof Element) {
                JDOMUtil.internStringsInElement((Element)o, interner);
                continue;
            }
            if (!(o instanceof Text)) continue;
            ((Text)o).setText(interner.intern(o.getValue()));
        }
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(11);
        }
        String string = JDOMUtil.legalizeChars(str).toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(13);
        }
        StringBuilder result2 = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result2, str.charAt(i));
        }
        StringBuilder stringBuilder = result2;
        if (stringBuilder == null) {
            JDOMUtil.$$$reportNull$$$0(14);
        }
        return stringBuilder;
    }

    private static void appendLegalized(@NotNull StringBuilder sb, char each) {
        if (sb == null) {
            JDOMUtil.$$$reportNull$$$0(15);
        }
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter((int)each)) {
            sb.append("0x").append(StringUtil.toUpperCase(Long.toHexString(each)));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(List c1, List c2, boolean ignoreEmptyAttrValues) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator l1 = c1.listIterator();
        ListIterator l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean isAttributesEqual(@NotNull List<Attribute> l1, @NotNull List<Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (l1 == null) {
            JDOMUtil.$$$reportNull$$$0(16);
        }
        if (l2 == null) {
            JDOMUtil.$$$reportNull$$$0(17);
        }
        if (ignoreEmptyAttrValues) {
            l1 = ContainerUtil.filter(l1, NOT_EMPTY_VALUE_CONDITION);
            l2 = ContainerUtil.filter(l2, NOT_EMPTY_VALUE_CONDITION);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (JDOMUtil.attEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        if (a1 == null) {
            JDOMUtil.$$$reportNull$$$0(18);
        }
        if (a2 == null) {
            JDOMUtil.$$$reportNull$$$0(19);
        }
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    private static SAXBuilder getSaxBuilder() {
        java.lang.ref.SoftReference<SAXBuilder> reference = ourSaxBuilder.get();
        SAXBuilder saxBuilder = SoftReference.dereference(reference);
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder(){

                protected void configureParser(XMLReader parser, SAXHandler contentHandler) throws JDOMException {
                    super.configureParser(parser, contentHandler);
                    try {
                        parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                @NotNull
                public InputSource resolveEntity(String publicId, String systemId) {
                    InputSource inputSource = new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                    if (inputSource == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return inputSource;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil$3", "resolveEntity"));
                }
            });
            ourSaxBuilder.set(new java.lang.ref.SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            JDOMUtil.$$$reportNull$$$0(20);
        }
        Document document = JDOMUtil.loadDocument(new CharSequenceReader(seq));
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(21);
        }
        return document;
    }

    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            JDOMUtil.$$$reportNull$$$0(22);
        }
        return JDOMUtil.load(new CharSequenceReader(seq));
    }

    @NotNull
    private static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(23);
        }
        Document document = JDOMUtil.getSaxBuilder().build(reader);
        Document document2 = document;
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(24);
        }
        return document2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static Document loadDocument(File file) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(new BufferedInputStream(new FileInputStream(file)));
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(25);
        }
        return document;
    }

    @NotNull
    public static Element load(@NotNull File file) throws JDOMException, IOException {
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(26);
        }
        Element element = JDOMUtil.load(new BufferedInputStream(new FileInputStream(file)));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(27);
        }
        return element;
    }

    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(28);
        }
        Document document = JDOMUtil.loadDocument(new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET));
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(29);
        }
        return document;
    }

    public static Element load(Reader reader) throws JDOMException, IOException {
        return reader == null ? null : JDOMUtil.loadDocument(reader).detachRootElement();
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.loadDocument(stream).detachRootElement();
    }

    @NotNull
    public static Document loadDocument(@NotNull Class clazz, String resource) throws JDOMException, IOException {
        InputStream stream;
        if (clazz == null) {
            JDOMUtil.$$$reportNull$$$0(30);
        }
        if ((stream = clazz.getResourceAsStream(resource)) == null) {
            throw new FileNotFoundException(resource);
        }
        Document document = JDOMUtil.loadDocument(stream);
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(31);
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(32);
        }
        Document document = JDOMUtil.loadDocument(URLUtil.openStream(url));
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(33);
        }
        return document;
    }

    @NotNull
    public static Document loadResourceDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(34);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(@NotNull Document document, @NotNull String filePath, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(35);
        }
        if (filePath == null) {
            JDOMUtil.$$$reportNull$$$0(36);
        }
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));
        try {
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull File file, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(37);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(38);
        }
        JDOMUtil.write((Parent)document, file, lineSeparator);
    }

    public static void write(@NotNull Parent element, @NotNull File file) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(39);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(40);
        }
        JDOMUtil.write(element, file, "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(@NotNull Parent element, @NotNull File file, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(41);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(42);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(43);
        }
        FileUtil.createParentDirs(file);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            JDOMUtil.write(element, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(44);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(45);
        }
        JDOMUtil.write((Parent)document, stream, lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(@NotNull Parent element, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(46);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(47);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(48);
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, CharsetToolkit.UTF8_CHARSET);
        try {
            if (element instanceof Document) {
                JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element, (Writer)writer, lineSeparator);
            }
        }
        finally {
            writer.close();
        }
    }

    @Deprecated
    @NotNull
    public static byte[] printDocument(@NotNull Document document, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(49);
        }
        CharArrayWriter writer = new CharArrayWriter();
        JDOMUtil.writeDocument(document, writer, lineSeparator);
        byte[] byArray = StringFactory.createShared(writer.toCharArray()).getBytes(CharsetToolkit.UTF8_CHARSET);
        if (byArray == null) {
            JDOMUtil.$$$reportNull$$$0(50);
        }
        return byArray;
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        String string;
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(51);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException ignored) {
            if ("" == null) {
                JDOMUtil.$$$reportNull$$$0(53);
            }
            return "";
        }
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    public static String write(Parent element, String lineSeparator) {
        String string;
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(54);
        }
        return string;
    }

    public static void write(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof Element) {
            JDOMUtil.writeElement((Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(55);
        }
        JDOMUtil.writeElement(element, writer, JDOMUtil.createOutputter(lineSeparator));
    }

    public static void writeElement(@NotNull Element element, @NotNull Writer writer, @NotNull XMLOutputter xmlOutputter) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(56);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(57);
        }
        if (xmlOutputter == null) {
            JDOMUtil.$$$reportNull$$$0(58);
        }
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(59);
        }
        String string = JDOMUtil.writeElement(element, "\n");
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        String string;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(61);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, (Writer)writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    public static String writeChildren(@NotNull Element element, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(63);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(64);
        }
        StringWriter writer = new StringWriter();
        for (Element child : element.getChildren()) {
            JDOMUtil.writeElement(child, (Writer)writer, lineSeparator);
            writer.append(lineSeparator);
        }
        String string = writer.toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(65);
        }
        return string;
    }

    public static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(66);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(67);
        }
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        XMLOutputter xMLOutputter = JDOMUtil.createOutputter(lineSeparator, null);
        if (xMLOutputter == null) {
            JDOMUtil.$$$reportNull$$$0(68);
        }
        return xMLOutputter;
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator, @Nullable ElementOutputFilter elementOutputFilter) {
        MyXMLOutputter xmlOutputter = new MyXMLOutputter(elementOutputFilter);
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        xmlOutputter.setFormat(format);
        MyXMLOutputter myXMLOutputter = xmlOutputter;
        if (myXMLOutputter == null) {
            JDOMUtil.$$$reportNull$$$0(69);
        }
        return myXMLOutputter;
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(@NotNull String text2) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(70);
        }
        String string = JDOMUtil.escapeText(text2, false, false);
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(71);
        }
        return string;
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(72);
        }
        String string = JDOMUtil.escapeText(text2, false, escapeSpaces, escapeLineEnds);
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(74);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < text2.length(); ++i) {
            char ch = text2.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            if (buffer == null) {
                if (quotation == null) continue;
                buffer = new StringBuilder(text2.length() + 20);
                buffer.append(text2, 0, i);
                buffer.append(quotation);
                continue;
            }
            if (quotation == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(quotation);
        }
        String string = buffer == null ? text2 : buffer.toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(76);
        }
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        int length;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(77);
        }
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element.getName());
        List attributes = element.getAttributes();
        if (attributes != null && (length = attributes.size()) > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = (Attribute)attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        ElementInfo elementInfo = new ElementInfo(buf, hasNullAttributes);
        if (elementInfo == null) {
            JDOMUtil.$$$reportNull$$$0(78);
        }
        return elementInfo;
    }

    public static void updateFileSet(@NotNull File[] oldFiles, @NotNull String[] newFilePaths, @NotNull Document[] newFileDocuments, String lineSeparator) throws IOException {
        if (oldFiles == null) {
            JDOMUtil.$$$reportNull$$$0(79);
        }
        if (newFilePaths == null) {
            JDOMUtil.$$$reportNull$$$0(80);
        }
        if (newFileDocuments == null) {
            JDOMUtil.$$$reportNull$$$0(81);
        }
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        for (String newFilePath : newFilePaths) {
            File file = new File(newFilePath);
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file : oldFiles) {
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not writeable");
        }
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result2 = oldFile.delete();
            if (result2) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || element.getAttributes().isEmpty() && element.getContent().isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element, int attributeCount) {
        return element == null || element.getAttributes().size() == attributeCount && element.getContent().isEmpty();
    }

    @Nullable
    public static Element merge(@Nullable Element to, @Nullable Element from) {
        if (from == null) {
            return to;
        }
        if (to == null) {
            return from;
        }
        Iterator iterator = from.getChildren().iterator();
        while (iterator.hasNext()) {
            Element configuration = (Element)iterator.next();
            iterator.remove();
            to.addContent(configuration);
        }
        iterator = from.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            iterator.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @NotNull
    public static Element deepMerge(@NotNull Element to, @NotNull Element from) {
        if (to == null) {
            JDOMUtil.$$$reportNull$$$0(82);
        }
        if (from == null) {
            JDOMUtil.$$$reportNull$$$0(83);
        }
        Iterator iterator = from.getChildren().iterator();
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            iterator.remove();
            Element existingChild = to.getChild(child.getName());
            if (existingChild != null && JDOMUtil.isEmpty(existingChild)) {
                to.removeChild(child.getName());
                existingChild = null;
            }
            if (existingChild == null || existingChild.getChildren().isEmpty() || !JDOMUtil.isAttributesEqual(existingChild.getAttributes(), child.getAttributes(), false)) {
                to.addContent(child);
                continue;
            }
            JDOMUtil.deepMerge(existingChild, child);
        }
        iterator = from.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            iterator.remove();
            to.setAttribute(attribute);
        }
        Element element = to;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(84);
        }
        return element;
    }

    @NotNull
    public static Element internElement(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(85);
        }
        Element element2 = ourJDOMInterner.internElement(element);
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(86);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 70: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 70: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 9: 
            case 39: 
            case 41: 
            case 46: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 76: 
            case 77: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 26: 
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 35: 
            case 37: 
            case 44: 
            case 49: 
            case 51: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 43: 
            case 48: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 57: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlOutputter";
                break;
            }
            case 70: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFiles";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePaths";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileDocuments";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 70: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeChars";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocument";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResourceDocument";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "printDocument";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "writeDocument";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 60: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "writeElement";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChildren";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputter";
                break;
            }
            case 71: 
            case 73: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "deepMerge";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTreeHash";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addToHash";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "internStringsInElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "legalizeText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "legalizeChars";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendLegalized";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAttributesEqual";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "attEqual";
                break;
            }
            case 20: 
            case 23: 
            case 28: 
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadDocument";
                break;
            }
            case 22: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 45: 
            case 51: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "writeDocument";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "printDocument";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "writeChildren";
                break;
            }
            case 70: 
            case 72: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "printDiagnostics";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "updateFileSet";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "deepMerge";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 70: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementInfo {
        @NotNull
        final CharSequence name;
        final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name, boolean attributes) {
            if (name == null) {
                ElementInfo.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.hasNullAttributes = attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/JDOMUtil$ElementInfo", "<init>"));
        }
    }

    public static interface ElementOutputFilter {
        public boolean accept(@NotNull Element var1, int var2);
    }

    public static class MyXMLOutputter
    extends XMLOutputter {
        private final ElementOutputFilter myElementOutputFilter;

        public MyXMLOutputter(@Nullable ElementOutputFilter filter) {
            this.myElementOutputFilter = filter;
        }

        public MyXMLOutputter() {
            this(null);
        }

        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(0);
            }
            String string = JDOMUtil.escapeText(str, false, true);
            if (string == null) {
                MyXMLOutputter.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(2);
            }
            String string = JDOMUtil.escapeText(str, false, false);
            if (string == null) {
                MyXMLOutputter.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected void printElement(Writer out, Element element, int level, XMLOutputter.NamespaceStack namespaces) throws IOException {
            if (this.myElementOutputFilter == null || this.myElementOutputFilter.accept(element, level)) {
                super.printElement(out, element, level, namespaces);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeAttributeEntities";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeElementEntities";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeAttributeEntities";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeElementEntities";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");

        private LoggerHolder() {
        }
    }
}

