/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NameUtil {
    private static final Function<String, String> LOWERCASE_MAPPING = new Function<String, String>(){

        @Override
        public String fun(String s) {
            return s.toLowerCase();
        }
    };
    private static final int MAX_LENGTH = 40;

    private NameUtil() {
    }

    @NotNull
    public static List<String> nameToWordsLowerCase(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(0);
        }
        List<String> list = ContainerUtil.map(NameUtil.nameToWords(name), LOWERCASE_MAPPING);
        if (list == null) {
            NameUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static String[] nameToWords(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(2);
        }
        ArrayList<String> array = new ArrayList<String>();
        int index = 0;
        while (index < name.length()) {
            String word;
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            if (StringUtil.isEmptyOrSpaces(word = name.substring(wordStart, index))) continue;
            array.add(word);
        }
        String[] stringArray = ArrayUtil.toStringArray(array);
        if (stringArray == null) {
            NameUtil.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(4);
        }
        String string = NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower, false, false);
        if (string == null) {
            NameUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords, boolean forCompletion) {
        boolean endsWithSpace;
        int eol;
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(6);
        }
        if ((eol = pattern.indexOf(10)) != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 40) {
            pattern = pattern.substring(0, 40);
        }
        StringBuilder buffer = new StringBuilder();
        boolean bl = endsWithSpace = !forCompletion && StringUtil.endsWithChar(pattern, ' ');
        if (!forCompletion) {
            pattern = pattern.trim();
        }
        exactPrefixLen = Math.min(exactPrefixLen, pattern.length());
        boolean prevIsUppercase = false;
        if (exactPrefixLen > 0) {
            char c = pattern.charAt(exactPrefixLen - 1);
            prevIsUppercase = Character.isUpperCase(c) || Character.isDigit(c);
        }
        for (int i = 0; i != exactPrefixLen; ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\").append(c);
        }
        if (exactPrefixLen == 0) {
            buffer.append("_*");
        }
        boolean firstIdentifierLetter = exactPrefixLen == 0;
        boolean lastIsUppercase = false;
        for (int i = exactPrefixLen; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            lastIsUppercase = false;
            if (Character.isLetterOrDigit(c)) {
                prevIsUppercase = false;
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    prevIsUppercase = true;
                    lastIsUppercase = true;
                    buffer.append('(');
                    if (!firstIdentifierLetter) {
                        buffer.append("[a-z\\s0-9\\$]*");
                    }
                    buffer.append(c);
                    if (allowToLower) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    if (!firstIdentifierLetter) {
                        buffer.append("|[A-Za-z\\s0-9\\$]*[_-]+[");
                        buffer.append(c);
                        buffer.append(Character.toLowerCase(c));
                        buffer.append("]");
                    }
                    buffer.append(')');
                } else if (Character.isLowerCase(c) && allowToUpper) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                    if (lowerCaseWords) {
                        buffer.append("([a-z\\s0-9\\$]*[-_]+)?");
                    }
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                if (!firstIdentifierLetter) {
                    buffer.append("[a-z\\s0-9\\$]*\\.");
                } else {
                    buffer.append("\\.");
                }
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append("([a-z\\s0-9\\$_-]*[\\ _-]+)+");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ':' || prevIsUppercase) {
                buffer.append("[A-Za-z\\s0-9\\$]*");
            }
            firstIdentifierLetter = true;
            buffer.append("\\").append(c);
        }
        if (!endsWithSpace) {
            buffer.append(".*");
        } else if (lastIsUppercase) {
            buffer.append("[a-z\\s0-9\\$]*");
        }
        String string = buffer.toString();
        if (string == null) {
            NameUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String[] splitNameIntoWords(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(8);
        }
        String[] underlineDelimited = name.split("_");
        ArrayList<String> result2 = new ArrayList<String>();
        for (String word : underlineDelimited) {
            NameUtil.addAllWords(word, result2);
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            NameUtil.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @NotNull
    public static List<String> getSuggestionsByName(@NotNull String name, @NotNull String prefix, @NotNull String suffix, boolean upperCaseStyle, boolean preferLongerNames, boolean isArray) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(10);
        }
        if (prefix == null) {
            NameUtil.$$$reportNull$$$0(11);
        }
        if (suffix == null) {
            NameUtil.$$$reportNull$$$0(12);
        }
        ArrayList<String> answer = new ArrayList<String>();
        String[] words = NameUtil.nameToWords(name);
        for (int step = 0; step < words.length; ++step) {
            int wordCount = preferLongerNames ? words.length - step : step + 1;
            String startWord = words[words.length - wordCount];
            char c = startWord.charAt(0);
            if (c == '_' || !Character.isJavaIdentifierStart(c)) continue;
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, false) + suffix);
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, true) + suffix);
        }
        ArrayList<String> arrayList = answer;
        if (arrayList == null) {
            NameUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static String compoundSuggestion(@NotNull String prefix, boolean upperCaseStyle, @NotNull String[] words, int wordCount, @NotNull String startWord, char c, boolean isArray, boolean skip_) {
        if (prefix == null) {
            NameUtil.$$$reportNull$$$0(14);
        }
        if (words == null) {
            NameUtil.$$$reportNull$$$0(15);
        }
        if (startWord == null) {
            NameUtil.$$$reportNull$$$0(16);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        startWord = upperCaseStyle ? StringUtil.toUpperCase(startWord) : (prefix.isEmpty() || StringUtil.endsWithChar(prefix, '_') ? startWord.toLowerCase() : Character.toUpperCase(c) + startWord.substring(1));
        buffer.append(startWord);
        for (int i = words.length - wordCount + 1; i < words.length; ++i) {
            String word = words[i];
            String prevWord = words[i - 1];
            if (upperCaseStyle) {
                word = StringUtil.toUpperCase(word);
                if (prevWord.charAt(prevWord.length() - 1) != '_' && word.charAt(0) != '_') {
                    word = "_" + word;
                }
            } else {
                if (prevWord.charAt(prevWord.length() - 1) == '_') {
                    word = word.toLowerCase();
                }
                if (skip_) {
                    if (word.equals("_")) continue;
                    if (prevWord.equals("_")) {
                        word = StringUtil.capitalize(word);
                    }
                }
            }
            buffer.append(word);
        }
        String suggestion = buffer.toString();
        if (isArray) {
            suggestion = StringUtil.pluralize(suggestion);
            if (upperCaseStyle) {
                suggestion = StringUtil.toUpperCase(suggestion);
            }
        }
        String string = suggestion;
        if (string == null) {
            NameUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    static int nextWord(@NotNull String text2, int start) {
        int i;
        if (text2 == null) {
            NameUtil.$$$reportNull$$$0(18);
        }
        if (!Character.isLetterOrDigit(text2.charAt(start))) {
            return start + 1;
        }
        for (i = start; i < text2.length() && Character.isDigit(text2.charAt(i)); ++i) {
        }
        if (i > start) {
            return i;
        }
        while (i < text2.length() && Character.isUpperCase(text2.charAt(i))) {
            ++i;
        }
        if (i > start + 1) {
            if (i == text2.length() || !Character.isLetter(text2.charAt(i))) {
                return i;
            }
            return i - 1;
        }
        if (i == start) {
            ++i;
        }
        while (i < text2.length() && Character.isLetter(text2.charAt(i)) && !NameUtil.isWordStart(text2, i)) {
            ++i;
        }
        return i;
    }

    private static void addAllWords(@NotNull String text2, @NotNull List<String> result2) {
        if (text2 == null) {
            NameUtil.$$$reportNull$$$0(19);
        }
        if (result2 == null) {
            NameUtil.$$$reportNull$$$0(20);
        }
        int start = 0;
        while (start < text2.length()) {
            int next = NameUtil.nextWord(text2, start);
            result2.add(text2.substring(start, next));
            start = next;
        }
    }

    static boolean isWordStart(String text2, int i) {
        char c = text2.charAt(i);
        if (Character.isUpperCase(c)) {
            if (i > 0 && Character.isUpperCase(text2.charAt(i - 1))) {
                return i + 1 < text2.length() && Character.isLowerCase(text2.charAt(i + 1));
            }
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        if (!Character.isLetter(c)) {
            return false;
        }
        return i == 0 || !Character.isLetterOrDigit(text2.charAt(i - 1)) || NameUtil.isHardCodedWordStart(text2, i);
    }

    private static boolean isHardCodedWordStart(String text2, int i) {
        return text2.charAt(i) == 'l' && i < text2.length() - 1 && text2.charAt(i + 1) == 'n' && (text2.length() == i + 2 || NameUtil.isWordStart(text2, i + 2));
    }

    @Deprecated
    @NotNull
    public static com.intellij.util.text.Matcher buildCompletionMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(21);
        }
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern, options);
        if (minusculeMatcher == null) {
            NameUtil.$$$reportNull$$$0(22);
        }
        return minusculeMatcher;
    }

    @NotNull
    public static com.intellij.util.text.Matcher buildMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(23);
        }
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern, options);
        if (minusculeMatcher == null) {
            NameUtil.$$$reportNull$$$0(24);
        }
        return minusculeMatcher;
    }

    @Deprecated
    @NotNull
    public static com.intellij.util.text.Matcher buildMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(25);
        }
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern, options);
        if (minusculeMatcher == null) {
            NameUtil.$$$reportNull$$$0(26);
        }
        return minusculeMatcher;
    }

    @NotNull
    public static MatcherBuilder buildMatcher(@NotNull String pattern) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(27);
        }
        MatcherBuilder matcherBuilder = new MatcherBuilder(pattern);
        if (matcherBuilder == null) {
            NameUtil.$$$reportNull$$$0(28);
        }
        return matcherBuilder;
    }

    @NotNull
    public static MinusculeMatcher buildMatcher(@NotNull String pattern, @NotNull MatchingCaseSensitivity options) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(29);
        }
        if (options == null) {
            NameUtil.$$$reportNull$$$0(30);
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern).withCaseSensitivity(options).build();
        if (minusculeMatcher == null) {
            NameUtil.$$$reportNull$$$0(31);
        }
        return minusculeMatcher;
    }

    @NotNull
    public static String capitalizeAndUnderscore(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(32);
        }
        String string = NameUtil.splitWords(name, '_', new Function<String, String>(){

            @Override
            public String fun(String s) {
                return StringUtil.toUpperCase(s);
            }
        });
        if (string == null) {
            NameUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String splitWords(@NotNull String text2, char separator, @NotNull Function<String, String> transformWord) {
        if (text2 == null) {
            NameUtil.$$$reportNull$$$0(34);
        }
        if (transformWord == null) {
            NameUtil.$$$reportNull$$$0(35);
        }
        String[] words = NameUtil.nameToWords(text2);
        boolean insertSeparator = false;
        StringBuilder buf = new StringBuilder();
        for (String word : words) {
            if (!Character.isLetterOrDigit(word.charAt(0))) {
                buf.append(separator);
                insertSeparator = false;
                continue;
            }
            if (insertSeparator) {
                buf.append(separator);
            } else {
                insertSeparator = true;
            }
            buf.append(transformWord.fun(word));
        }
        String string = buf.toString();
        if (string == null) {
            NameUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/NameUtil";
                break;
            }
            case 4: 
            case 6: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startWord";
                break;
            }
            case 18: 
            case 19: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/NameUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWordsLowerCase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWords";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRegexp";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNameIntoWords";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsByName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "compoundSuggestion";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCompletionMatcher";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMatcher";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeAndUnderscore";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "splitWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nameToWordsLowerCase";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "nameToWords";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildRegexp";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "splitNameIntoWords";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsByName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compoundSuggestion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addAllWords";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildCompletionMatcher";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeAndUnderscore";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "splitWords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum MatchingCaseSensitivity {
        NONE,
        FIRST_LETTER,
        ALL;

    }

    public static class MatcherBuilder {
        private final String pattern;
        private String separators = "";
        private MatchingCaseSensitivity caseSensitivity = MatchingCaseSensitivity.NONE;

        public MatcherBuilder(String pattern) {
            this.pattern = pattern;
        }

        public MatcherBuilder withCaseSensitivity(MatchingCaseSensitivity caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
            return this;
        }

        public MatcherBuilder withSeparators(String separators) {
            this.separators = separators;
            return this;
        }

        public MinusculeMatcher build() {
            return new FixingLayoutMatcher(this.pattern, this.caseSensitivity, this.separators);
        }
    }

    @Deprecated
    public static interface Matcher {
        public boolean matches(@NotNull String var1);
    }
}

